/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph;

import ai.stapi.graph.AttributeContainer;
import ai.stapi.graph.EdgeTypeInfo;
import ai.stapi.graph.NodeIdAndType;
import ai.stapi.graph.NodeInfo;
import ai.stapi.graph.NodeTypeInfo;
import ai.stapi.graph.exceptions.EdgeNotFound;
import ai.stapi.graph.exceptions.EdgeWithSameIdAlreadyExists;
import ai.stapi.graph.exceptions.MoreThanOneNodeOfTypeFoundException;
import ai.stapi.graph.exceptions.NodeNotFound;
import ai.stapi.graph.exceptions.NodeOfTypeNotFoundException;
import ai.stapi.graph.exceptions.NodeWithSameIdAlreadyExists;
import ai.stapi.graph.exceptions.OneOrBothNodesOnEdgeDoesNotExist;
import ai.stapi.graph.graphElementForRemoval.EdgeForRemoval;
import ai.stapi.graph.graphElementForRemoval.GraphElementForRemoval;
import ai.stapi.graph.graphElementForRemoval.NodeForRemoval;
import ai.stapi.graph.graphelements.AbstractGraphElement;
import ai.stapi.graph.graphelements.Edge;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graph.inMemoryGraph.DeduplicateOptions;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.inMemoryGraph.exceptions.CannotCreateGraphWithOtherThanGraphElements;
import ai.stapi.graph.inMemoryGraph.exceptions.GraphEdgesCannotBeMerged;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.identity.UniqueIdentifier;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.LinkedMap;

public class Graph {
    private ImmutableMap<UniqueIdentifier, Node> nodeMap;
    private ImmutableMap<UniqueIdentifier, Edge> edgeMap;
    private ImmutableMap<String, Long> nodeTypeCounts;
    private ImmutableMap<String, Long> edgeTypeCounts;

    public Graph() {
        this.nodeMap = ImmutableMap.of();
        this.edgeMap = ImmutableMap.of();
        this.nodeTypeCounts = ImmutableMap.of();
        this.edgeTypeCounts = ImmutableMap.of();
    }

    public Graph(AttributeContainer ... graphElements) {
        this();
        Graph newInMemoryGraph = this.withAll(graphElements);
        this.nodeMap = ImmutableMap.copyOf(newInMemoryGraph.nodeMap);
        this.edgeMap = ImmutableMap.copyOf(newInMemoryGraph.edgeMap);
        this.nodeTypeCounts = ImmutableMap.copyOf(newInMemoryGraph.nodeTypeCounts);
        this.edgeTypeCounts = ImmutableMap.copyOf(newInMemoryGraph.edgeTypeCounts);
    }

    private Graph(Map<UniqueIdentifier, Node> nodeMap, Map<UniqueIdentifier, Edge> edgeMap, Map<String, Long> nodeTypeCounts, Map<String, Long> edgeTypeCounts) {
        this.nodeMap = ImmutableMap.copyOf(nodeMap);
        this.edgeMap = ImmutableMap.copyOf(edgeMap);
        this.nodeTypeCounts = ImmutableMap.copyOf(nodeTypeCounts);
        this.edgeTypeCounts = ImmutableMap.copyOf(edgeTypeCounts);
    }

    private Graph(Map<UniqueIdentifier, Node> nodeMap, Map<UniqueIdentifier, Edge> edgeMap) {
        HashMap newNodeTypeCounts = new HashMap();
        HashMap newEdgeTypeCounts = new HashMap();
        nodeMap.values().forEach(node -> newNodeTypeCounts.put(node.getType(), newNodeTypeCounts.getOrDefault(node.getType(), 0L) + 1L));
        edgeMap.values().forEach(edge -> newEdgeTypeCounts.put(edge.getType(), newEdgeTypeCounts.getOrDefault(edge.getType(), 0L) + 1L));
        this.nodeMap = ImmutableMap.copyOf(nodeMap);
        this.edgeMap = ImmutableMap.copyOf(edgeMap);
        this.nodeTypeCounts = ImmutableMap.copyOf(newNodeTypeCounts);
        this.edgeTypeCounts = ImmutableMap.copyOf(newEdgeTypeCounts);
    }

    public static Graph unsafe(Map<UniqueIdentifier, Node> nodeMap, Map<UniqueIdentifier, Edge> edgeMap) {
        return new Graph(nodeMap, edgeMap);
    }

    public InMemoryGraphRepository traversable() {
        return new InMemoryGraphRepository(this);
    }

    public Graph with(Node node) {
        if (this.nodeExists(node.getId())) {
            throw new NodeWithSameIdAlreadyExists(node.getId(), node.getType());
        }
        LinkedMap newNodeMap = new LinkedMap(this.nodeMap);
        newNodeMap.put(node.getId(), node);
        LinkedMap newNodeTypeCounts = new LinkedMap(this.nodeTypeCounts);
        newNodeTypeCounts.put(node.getType(), newNodeTypeCounts.getOrDefault(node.getType(), 0L) + 1L);
        return new Graph((Map<UniqueIdentifier, Node>)newNodeMap, (Map<UniqueIdentifier, Edge>)this.edgeMap, (Map<String, Long>)newNodeTypeCounts, (Map<String, Long>)this.edgeTypeCounts);
    }

    public Graph with(Edge edge) {
        this.ensureEdgeWithSameIdDoesNotExistsAlready(edge.getId(), edge.getType());
        this.ensureContainsBothNodesOnEdge(edge);
        LinkedMap newEdgeMap = new LinkedMap(this.edgeMap);
        newEdgeMap.put((Object)edge.getId(), (Object)edge);
        LinkedMap newEdgeTypeCounts = new LinkedMap(this.edgeTypeCounts);
        newEdgeTypeCounts.put((Object)edge.getType(), (Object)((Long)newEdgeTypeCounts.getOrDefault((Object)edge.getType(), (Object)0L) + 1L));
        return new Graph((Map<UniqueIdentifier, Node>)this.nodeMap, (Map<UniqueIdentifier, Edge>)newEdgeMap, (Map<String, Long>)this.nodeTypeCounts, (Map<String, Long>)newEdgeTypeCounts);
    }

    private void ensureEdgeWithSameIdDoesNotExistsAlready(UniqueIdentifier id, String edgeType) {
        if (this.edgeExists(id)) {
            throw new EdgeWithSameIdAlreadyExists(id.getId(), edgeType);
        }
    }

    public Graph withAll(AttributeContainer ... graphElements) {
        Graph newGraph = this;
        long invalidObjects = Arrays.stream(graphElements).filter(graphElement -> !(graphElement instanceof Node) && !(graphElement instanceof Edge)).count();
        if (invalidObjects > 0L) {
            throw new CannotCreateGraphWithOtherThanGraphElements();
        }
        for (AttributeContainer graphElement2 : graphElements) {
            if (graphElement2 instanceof Node) {
                Node node = (Node)graphElement2;
                newGraph = newGraph.with(node);
            }
            if (!(graphElement2 instanceof Edge)) continue;
            Edge edge = (Edge)graphElement2;
            newGraph = newGraph.with(edge);
        }
        return newGraph;
    }

    public Node getNode(UniqueIdentifier uniqueIdentifier, String nodeType) {
        if (!this.nodeMap.containsKey((Object)uniqueIdentifier)) {
            throw new NodeNotFound(uniqueIdentifier);
        }
        Node foundNode = (Node)this.nodeMap.get((Object)uniqueIdentifier);
        if (foundNode == null || !foundNode.getType().equals(nodeType)) {
            throw new NodeNotFound(uniqueIdentifier, nodeType);
        }
        return foundNode;
    }

    public Node getNode(UniqueIdentifier uniqueIdentifier) {
        if (!this.nodeMap.containsKey((Object)uniqueIdentifier)) {
            throw new NodeNotFound(uniqueIdentifier);
        }
        return (Node)this.nodeMap.get((Object)uniqueIdentifier);
    }

    public Edge getEdge(UniqueIdentifier uniqueIdentifier) {
        if (!this.edgeMap.containsKey((Object)uniqueIdentifier)) {
            throw new EdgeNotFound(uniqueIdentifier);
        }
        return (Edge)this.edgeMap.get((Object)uniqueIdentifier);
    }

    public Edge getEdge(UniqueIdentifier id, String edgeType) {
        if (!this.edgeMap.containsKey((Object)id)) {
            throw new EdgeNotFound(id);
        }
        Edge foundEdge = (Edge)this.edgeMap.get((Object)id);
        if (foundEdge == null || !foundEdge.getType().equals(edgeType)) {
            throw new EdgeNotFound(id, edgeType);
        }
        return foundEdge;
    }

    public Node getExactlyOneNodeOfType(String nodeType) {
        List<Node> foundNodes = this.getAllNodes(nodeType);
        if (foundNodes.isEmpty()) {
            throw new NodeOfTypeNotFoundException(nodeType);
        }
        if (foundNodes.size() > 1) {
            throw new MoreThanOneNodeOfTypeFoundException(nodeType);
        }
        return foundNodes.get(0);
    }

    public List<Node> getAllNodes() {
        return this.nodeMap.values().stream().toList();
    }

    public List<Node> getAllNodes(String nodeType) {
        return this.nodeMap.values().stream().filter(node -> node.getType().equals(nodeType)).toList();
    }

    public List<Edge> getAllEdges() {
        return this.edgeMap.values().stream().toList();
    }

    public List<Edge> loadAllEdges(String edgeType) {
        return this.edgeMap.values().stream().filter(edge -> edge.getType().equals(edgeType)).toList();
    }

    public Graph replace(Node node) {
        LinkedMap newNodeMap = new LinkedMap(this.nodeMap);
        LinkedMap newNodeTypeCounts = new LinkedMap(this.nodeTypeCounts);
        Node oldNode = (Node)this.nodeMap.get((Object)node.getId());
        newNodeMap.put(node.getId(), node);
        if (newNodeTypeCounts.containsKey(Objects.requireNonNull(oldNode).getType())) {
            long oldCount = (Long)newNodeTypeCounts.get(oldNode.getType());
            newNodeTypeCounts.put(oldNode.getType(), oldCount - 1L);
        }
        if (newNodeTypeCounts.containsKey(node.getType())) {
            long newCount = (Long)newNodeTypeCounts.get(node.getType());
            newNodeTypeCounts.put(node.getType(), newCount + 1L);
        } else {
            newNodeTypeCounts.put(node.getType(), 1L);
        }
        return new Graph((Map<UniqueIdentifier, Node>)newNodeMap, (Map<UniqueIdentifier, Edge>)this.edgeMap, (Map<String, Long>)newNodeTypeCounts, (Map<String, Long>)this.edgeTypeCounts);
    }

    public Graph removeNode(UniqueIdentifier id, String nodeType) {
        if (!this.nodeExists(id, nodeType)) {
            return this;
        }
        LinkedMap newEdgeMap = new LinkedMap(this.edgeMap);
        Set<TraversableEdge> inAndOutEdgesForNode = this.traversable().findInAndOutEdgesForNode(id, nodeType);
        inAndOutEdgesForNode.forEach(arg_0 -> Graph.lambda$removeNode$5((Map)newEdgeMap, arg_0));
        LinkedMap newNodeMap = new LinkedMap(this.nodeMap);
        newNodeMap.remove(id);
        return new Graph((Map<UniqueIdentifier, Node>)newNodeMap, (Map<UniqueIdentifier, Edge>)newEdgeMap);
    }

    public Graph removeNode(NodeForRemoval nodeForRemoval) {
        return this.removeNode(nodeForRemoval.getGraphElementId(), nodeForRemoval.getGraphElementType());
    }

    public boolean nodeExists(UniqueIdentifier id, String type) {
        return this.nodeMap.containsKey((Object)id) && Objects.requireNonNull((Node)this.nodeMap.get((Object)id)).getType().equals(type);
    }

    public boolean nodeExists(UniqueIdentifier id) {
        return this.nodeMap.containsKey((Object)id);
    }

    public boolean containsNodeOfType(String nodeType) {
        return this.nodeTypeCounts.containsKey((Object)nodeType);
    }

    public boolean edgeExists(UniqueIdentifier id, String type) {
        return this.edgeMap.containsKey((Object)id) && Objects.requireNonNull((Edge)this.edgeMap.get((Object)id)).getType().equals(type);
    }

    public boolean edgeExists(UniqueIdentifier id) {
        return this.edgeMap.containsKey((Object)id);
    }

    public List<NodeTypeInfo> getNodeTypeInfos() {
        return this.nodeTypeCounts.entrySet().stream().map(entry -> new NodeTypeInfo((String)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    public List<EdgeTypeInfo> getEdgeTypeInfos() {
        return this.edgeTypeCounts.entrySet().stream().map(entry -> new EdgeTypeInfo((String)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    public List<NodeInfo> getNodeInfosBy(String nodeType) {
        return this.nodeMap.values().stream().filter(graphNode -> graphNode.getType().equals(nodeType)).map(graphNode -> new NodeInfo(graphNode.getId(), graphNode.getType(), this.traversable().loadNode(graphNode.getId(), graphNode.getType()).getSortingNameWithNodeTypeFallback())).sorted(Comparator.comparing(NodeInfo::getName)).collect(Collectors.toList());
    }

    public Graph replace(Edge edge) {
        LinkedMap newEdgeMap = new LinkedMap(this.edgeMap);
        newEdgeMap.put(edge.getId(), edge);
        return new Graph((Map<UniqueIdentifier, Node>)this.nodeMap, (Map<UniqueIdentifier, Edge>)newEdgeMap, (Map<String, Long>)this.nodeTypeCounts, (Map<String, Long>)this.edgeTypeCounts);
    }

    public Graph removeEdge(UniqueIdentifier edgeId, String edgeType) {
        if (!this.edgeExists(edgeId, edgeType)) {
            return this;
        }
        LinkedMap newEdgeMap = new LinkedMap(this.edgeMap);
        newEdgeMap.remove(edgeId);
        LinkedMap newEdgeTypeCounts = new LinkedMap(this.edgeTypeCounts);
        newEdgeTypeCounts.put(edgeType, newEdgeTypeCounts.getOrDefault(edgeType, 1L) - 1L);
        return new Graph((Map<UniqueIdentifier, Node>)this.nodeMap, (Map<UniqueIdentifier, Edge>)newEdgeMap, (Map<String, Long>)this.nodeTypeCounts, (Map<String, Long>)newEdgeTypeCounts);
    }

    public Graph removeEdge(EdgeForRemoval edgeForRemoval) {
        return this.removeEdge(edgeForRemoval.getGraphElementId(), edgeForRemoval.getGraphElementType());
    }

    public Edge findEdgeByTypeAndNodes(String edgeType, NodeIdAndType nodeFromIdAndType, NodeIdAndType nodeToIdAndType) {
        return this.edgeMap.values().stream().filter(edge -> edge.getType().equals(edgeType) && edge.getNodeFromIdAndType().equals(nodeFromIdAndType) && edge.getNodeToIdAndType().equals(nodeToIdAndType)).map(edge -> this.getEdge(edge.getId(), edge.getType())).findFirst().orElse(null);
    }

    public Graph merge(Graph otherGraph) {
        Graph newGraph = this;
        for (Node node : otherGraph.nodeMap.values()) {
            newGraph = newGraph.mergeNodeById(node);
        }
        for (Edge edge : otherGraph.edgeMap.values()) {
            newGraph = newGraph.merge(edge);
        }
        return newGraph;
    }

    public Graph removeGraphElements(GraphElementForRemoval ... graphElementsForRemoval) {
        return this.removeGraphElements(Arrays.stream(graphElementsForRemoval).toList());
    }

    public Graph removeGraphElements(List<GraphElementForRemoval> graphElementsForRemoval) {
        Graph newGraph = this;
        for (GraphElementForRemoval graphElementForRemoval : graphElementsForRemoval) {
            newGraph = newGraph.removeGraphElement(graphElementForRemoval);
        }
        return newGraph;
    }

    public Graph removeGraphElement(GraphElementForRemoval graphElementForRemoval) {
        Graph newGraph = this;
        if (graphElementForRemoval instanceof NodeForRemoval) {
            NodeForRemoval nodeForRemoval = (NodeForRemoval)graphElementForRemoval;
            newGraph = this.removeNode(nodeForRemoval);
        }
        if (graphElementForRemoval instanceof EdgeForRemoval) {
            EdgeForRemoval edgeForRemoval = (EdgeForRemoval)graphElementForRemoval;
            newGraph = this.removeEdge(edgeForRemoval);
        }
        return newGraph;
    }

    public Graph merge(Edge otherEdge) {
        if (!this.nodeExists(otherEdge.getNodeFromId(), otherEdge.getNodeFromType()) || !this.nodeExists(otherEdge.getNodeToId(), otherEdge.getNodeToType())) {
            throw new OneOrBothNodesOnEdgeDoesNotExist();
        }
        Graph graph = this;
        Edge foundEdge = (Edge)graph.edgeMap.get((Object)otherEdge.getId());
        if (foundEdge == null) {
            LinkedMap newEdgeMap = new LinkedMap(graph.edgeMap);
            newEdgeMap.put(otherEdge.getId(), otherEdge);
            LinkedMap newEdgeTypeCounts = new LinkedMap(graph.edgeTypeCounts);
            newEdgeTypeCounts.put(otherEdge.getType(), newEdgeTypeCounts.getOrDefault(otherEdge.getType(), 0L) + 1L);
            return new Graph((Map<UniqueIdentifier, Node>)graph.nodeMap, (Map<UniqueIdentifier, Edge>)newEdgeMap, (Map<String, Long>)graph.nodeTypeCounts, (Map<String, Long>)newEdgeTypeCounts);
        }
        Edge newMergedEdge = foundEdge.mergeOverwrite(otherEdge);
        LinkedMap newEdgeMap = new LinkedMap(graph.edgeMap);
        newEdgeMap.put(newMergedEdge.getId(), newMergedEdge);
        return new Graph((Map<UniqueIdentifier, Node>)graph.nodeMap, (Map<UniqueIdentifier, Edge>)newEdgeMap, (Map<String, Long>)graph.nodeTypeCounts, (Map<String, Long>)graph.edgeTypeCounts);
    }

    private void ensureContainsBothNodesOnEdge(Edge edge) {
        if (!this.nodeExists(edge.getNodeFromId()) || !this.nodeExists(edge.getNodeToId())) {
            throw new OneOrBothNodesOnEdgeDoesNotExist();
        }
    }

    public Graph merge(Graph otherGraph, DeduplicateOptions options) {
        if (options.equals((Object)DeduplicateOptions.SAME_EDGE_TYPES_BETWEEN_SAME_NODES)) {
            return this.mergeWithEdgeDeduplication(otherGraph);
        }
        return this.merge(otherGraph);
    }

    private Graph mergeWithEdgeDeduplication(Graph otherGraph) {
        Graph newGraph = this;
        for (Node node : otherGraph.getAllNodes()) {
            newGraph = newGraph.mergeNodeById(node);
        }
        for (Edge otherGraphEdge : otherGraph.getAllEdges()) {
            List localGraphEdges = newGraph.getAllEdges().stream().filter(processedEdge -> processedEdge.getNodeFromId().equals((Object)otherGraphEdge.getNodeFromId()) && processedEdge.getNodeToId().equals((Object)otherGraphEdge.getNodeToId()) && processedEdge.getType().equals(otherGraphEdge.getType())).collect(Collectors.toList());
            if (localGraphEdges.size() > 1) {
                throw GraphEdgesCannotBeMerged.becauseThereIsMultipleEdgesGivenEdgeCouldBeMergeWith(localGraphEdges.stream().map(AbstractGraphElement::getId).toList());
            }
            if (localGraphEdges.isEmpty()) {
                newGraph = newGraph.merge(otherGraphEdge);
            }
            if (localGraphEdges.size() != 1) continue;
            Edge newEdge = (Edge)((Edge)localGraphEdges.get(0)).mergeAttributesWithAttributesOf(otherGraphEdge);
            newGraph = newGraph.merge(newEdge);
        }
        return newGraph;
    }

    public Graph mergeNodeById(Node otherNode) {
        Node newNode;
        LinkedMap newNodeMap = new LinkedMap(this.nodeMap);
        LinkedMap newNodeTypeCounts = new LinkedMap(this.nodeTypeCounts);
        Node foundNode = (Node)newNodeMap.get((Object)otherNode.getId());
        if (foundNode == null) {
            newNode = otherNode;
            newNodeTypeCounts.put((Object)newNode.getType(), (Object)((Long)newNodeTypeCounts.getOrDefault((Object)newNode.getType(), (Object)0L) + 1L));
        } else {
            newNode = foundNode.mergeOverwrite(otherNode);
        }
        newNodeMap.put((Object)newNode.getId(), (Object)newNode);
        return new Graph((Map<UniqueIdentifier, Node>)newNodeMap, (Map<UniqueIdentifier, Edge>)this.edgeMap, (Map<String, Long>)newNodeTypeCounts, (Map<String, Long>)this.edgeTypeCounts);
    }

    private static /* synthetic */ void lambda$removeNode$5(Map newEdgeMap, TraversableEdge traversableEdge) {
        newEdgeMap.remove(traversableEdge.getId());
    }
}

