/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.attribute;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.CreatedAtMetaData;
import ai.stapi.graph.attribute.MetaData;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractAttribute<T>
implements Attribute<T> {
    private final String name;
    private final Map<String, MetaData> metaData;

    protected AbstractAttribute(String name) {
        this.name = name;
        this.metaData = new HashMap<String, MetaData>();
    }

    protected AbstractAttribute(String name, Timestamp createdAt) {
        this.name = name;
        this.metaData = new HashMap<String, CreatedAtMetaData>(Map.of("createdAt", new CreatedAtMetaData(createdAt)));
    }

    protected AbstractAttribute(String name, Map<String, MetaData> metaData) {
        this.name = name;
        this.metaData = new HashMap<String, MetaData>(metaData);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Timestamp getCreatedAt() {
        MetaData createdAt = this.metaData.get("createdAt");
        if (createdAt == null) {
            return null;
        }
        return CreatedAtMetaData.fromMetaData(createdAt).getTimestamp();
    }

    @Override
    public void setCreatedAt(Timestamp createdAt) {
        this.metaData.put("createdAt", new CreatedAtMetaData(createdAt));
    }

    @Override
    public Map<String, MetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractAttribute)) {
            return false;
        }
        AbstractAttribute otherAttribute = (AbstractAttribute)other;
        return this.getName().equals(otherAttribute.getName()) && this.getValue().equals(otherAttribute.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getValue(), null);
    }
}

