/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.node;

import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.IdLessTextRendererOptions;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.attribute.TextAttributeContainerRenderer;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.node.IdLessTextNodeRenderOutput;
import ai.stapi.graph.renderer.infrastructure.textRenderer.TextRendererOptions;
import ai.stapi.graph.renderer.model.nodeRenderer.NodeRenderer;
import ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.utils.LineFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IdLessTextNodeRenderer
implements NodeRenderer {
    private final TextAttributeContainerRenderer textAttributeContainerRenderer;

    @Autowired
    public IdLessTextNodeRenderer(TextAttributeContainerRenderer textAttributeContainerRenderer) {
        this.textAttributeContainerRenderer = textAttributeContainerRenderer;
    }

    @Override
    public boolean supports(RendererOptions options) {
        return options.getClass().equals(IdLessTextRendererOptions.class);
    }

    @Override
    public IdLessTextNodeRenderOutput render(TraversableNode node) {
        return this.render(node, new IdLessTextRendererOptions());
    }

    @Override
    public IdLessTextNodeRenderOutput render(TraversableNode node, RendererOptions options) {
        IdLessTextRendererOptions downtypedOptions = (IdLessTextRendererOptions)options;
        int indentLevel = downtypedOptions.getIndentLevel();
        Optional<String> relationAnnotation = downtypedOptions.getNodeRelationAnnotationAttributeName();
        String nodeTypeLine = LineFormatter.createLine((String)("node_type: " + node.getType()), (int)indentLevel);
        String hashLine = LineFormatter.createLine((String)("node_hash: " + this.formatHashCodeAsString(node.getIdlessHashCodeWithEdges())), (int)indentLevel);
        String edgesString = this.getRenderedEdges(node, indentLevel, relationAnnotation);
        String attributesString = this.textAttributeContainerRenderer.render(node, new TextRendererOptions(indentLevel)).toPrintableString();
        return new IdLessTextNodeRenderOutput(nodeTypeLine + hashLine + edgesString + attributesString);
    }

    private String formatHashCodeAsString(int hashCode) {
        byte[] bytes = DigestUtils.md5((String)("" + hashCode));
        char[] hex = Hex.encodeHex((byte[])bytes);
        return new String(hex).toUpperCase().substring(0, 5);
    }

    private String getRenderedEdges(TraversableNode node, int indentLevel, Optional<String> annotationAttribute) {
        String line = LineFormatter.createLine((String)"node_edges:", (int)indentLevel);
        List<TraversableEdge> edges = node.getEdges();
        return line + edges.stream().map(edge -> this.getRenderedEdge((TraversableEdge)edge, indentLevel + 1, annotationAttribute)).sorted().collect(Collectors.joining());
    }

    private String getRenderedEdge(TraversableEdge edge, int indentLevel, Optional<String> annotationAttribute) {
        TraversableNode nodeFrom = edge.getNodeFrom();
        TraversableNode nodeTo = edge.getNodeTo();
        String typeRelationString = String.format("%s -> %s -> %s", nodeFrom.getType(), edge.getType(), nodeTo.getType());
        String relationString = "";
        relationString = annotationAttribute.isPresent() ? this.getAttributeRelationString(edge, annotationAttribute.get()) : this.getHashRelationString(edge);
        return LineFormatter.createLine((String)(typeRelationString + " " + relationString), (int)indentLevel);
    }

    private String getHashRelationString(TraversableEdge edge) {
        return String.format("(%s -> %s -> %s)", this.formatHashCodeAsString(edge.getNodeFrom().getIdlessHashCodeWithEdges()), this.formatHashCodeAsString(edge.getIdlessHashCode()), this.formatHashCodeAsString(edge.getNodeTo().getIdlessHashCodeWithEdges()));
    }

    private String getAttributeRelationString(TraversableEdge edge, String attributeName) {
        String nodeFromTag = "";
        String nodeToTag = "";
        nodeFromTag = edge.getNodeFrom().hasAttribute(attributeName) ? (String)edge.getNodeFrom().getAttribute(attributeName).getValue() : this.formatHashCodeAsString(edge.getNodeFrom().getIdlessHashCodeWithEdges());
        nodeToTag = edge.getNodeTo().hasAttribute(attributeName) ? (String)edge.getNodeTo().getAttribute(attributeName).getValue() : this.formatHashCodeAsString(edge.getNodeTo().getIdlessHashCodeWithEdges());
        return String.format("(%s -> %s -> %s)", nodeFromTag, this.formatHashCodeAsString(edge.getIdlessHashCode()), nodeToTag);
    }
}

