/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.renderer.infrastructure.responseRenderer.responseGraph;

import ai.stapi.graph.renderer.infrastructure.responseRenderer.responseGraph.ResponseAttribute;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.responseGraph.ResponseNodeIdAndType;
import ai.stapi.graph.renderer.model.RenderOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ResponseEdge
implements RenderOutput,
Comparable<ResponseEdge> {
    private String uuid;
    private String type;
    private ResponseNodeIdAndType nodeFrom;
    private ResponseNodeIdAndType nodeTo;
    private Map<String, ResponseAttribute<?>> attributes;

    private ResponseEdge() {
    }

    public ResponseEdge(String uuid, String type, ResponseNodeIdAndType nodeFrom, ResponseNodeIdAndType nodeTo, Map<String, ResponseAttribute<?>> attributes) {
        this.uuid = uuid;
        this.type = type;
        this.nodeFrom = nodeFrom;
        this.nodeTo = nodeTo;
        this.attributes = attributes;
    }

    public ResponseEdge(String uuid, String type, ResponseNodeIdAndType nodeFrom, ResponseNodeIdAndType nodeTo) {
        this(uuid, type, nodeFrom, nodeTo, new HashMap());
    }

    @NotNull
    public String getUuid() {
        return this.uuid;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public ResponseNodeIdAndType getNodeFrom() {
        return this.nodeFrom;
    }

    @NotNull
    public ResponseNodeIdAndType getNodeTo() {
        return this.nodeTo;
    }

    @NotNull
    public Map<String, ResponseAttribute<?>> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "ResponseEdge{edgeId='" + this.uuid + "', type='" + this.type + "', nodeFrom=" + this.nodeFrom + ", nodeTo=" + this.nodeTo + ", attributes=" + this.attributes + "}";
    }

    @Override
    public String toPrintableString() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseEdge that = (ResponseEdge)o;
        return this.type.equals(that.type) && this.nodeFrom.equals(that.nodeFrom) && this.nodeTo.equals(that.nodeTo) && this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.nodeFrom, this.nodeTo, this.attributes);
    }

    @Override
    public int compareTo(@NotNull ResponseEdge o) {
        return this.hashCode() - o.hashCode();
    }
}

