/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.attribute.attributeFactory;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.LeafAttribute;
import ai.stapi.graph.attribute.MetaData;
import ai.stapi.graph.attribute.attributeFactory.AttributeFactory;
import ai.stapi.graph.attribute.attributeFactory.AttributeValueFactoryInput;
import ai.stapi.graph.attribute.attributeFactory.attributeValueFactory.GenericAttributeValueFactory;
import ai.stapi.graph.attribute.attributeFactory.exceptions.CannotCreateAttribute;
import ai.stapi.utils.Stringifier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafAttributeFactory
implements AttributeFactory {
    private final Logger logger = LoggerFactory.getLogger(LeafAttributeFactory.class);
    private final GenericAttributeValueFactory attributeValueFactory;

    public LeafAttributeFactory(GenericAttributeValueFactory attributeValueFactory) {
        this.attributeValueFactory = attributeValueFactory;
    }

    @Override
    public Attribute<?> create(String attributeName, List<AttributeValueFactoryInput> parameters, Map<String, MetaData> metaData) {
        if (parameters.isEmpty()) {
            throw CannotCreateAttribute.becauseLeafAttributeHadNoValues(attributeName);
        }
        if (parameters.size() > 1) {
            String stringyfiedValues = parameters.stream().map(Stringifier::convertToString).collect(Collectors.joining(", "));
            String message = "More values were provided, when creating Leaf Attribute, but it should have exactly one.\nAttribute name: %s\nChoosing value at first position.\nValues: %s\n".formatted(attributeName, stringyfiedValues);
            this.logger.warn(message);
        }
        AttributeValueFactoryInput parameter = parameters.get(0);
        return new LeafAttribute(attributeName, metaData, this.attributeValueFactory.create(attributeName, parameter));
    }

    @Override
    public boolean supportsStructureType(String structureType) {
        return structureType.equals("LeafAttribute");
    }
}

