/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.edge;

import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.IdLessTextRendererOptions;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.attribute.TextAttributeContainerRenderer;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.edge.IdlessTextRenderedOutput;
import ai.stapi.graph.renderer.infrastructure.textRenderer.TextRendererOptions;
import ai.stapi.graph.renderer.model.edgeRenderer.EdgeRenderer;
import ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.utils.LineFormatter;
import java.util.Optional;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IdLessTextEdgeRenderer
implements EdgeRenderer {
    private final TextAttributeContainerRenderer textAttributeContainerRenderer;

    @Autowired
    public IdLessTextEdgeRenderer(TextAttributeContainerRenderer textAttributeContainerRenderer) {
        this.textAttributeContainerRenderer = textAttributeContainerRenderer;
    }

    @Override
    public IdlessTextRenderedOutput render(TraversableEdge edge) {
        return this.render(edge, new IdLessTextRendererOptions());
    }

    @Override
    public IdlessTextRenderedOutput render(TraversableEdge edge, RendererOptions options) {
        IdLessTextRendererOptions specificOptions = (IdLessTextRendererOptions)options;
        String typeLine = LineFormatter.createLine((String)("edge_type: " + edge.getType()), (int)specificOptions.getIndentLevel());
        String hashLine = LineFormatter.createLine((String)("edge_hash: " + this.formatHashCodeAsString(edge.getIdlessHashCode())), (int)specificOptions.getIndentLevel());
        String relationLine = this.getRelationLine(edge, specificOptions);
        String attributesLines = this.textAttributeContainerRenderer.render(edge, new TextRendererOptions(specificOptions.getIndentLevel())).toPrintableString();
        return new IdlessTextRenderedOutput(typeLine + hashLine + relationLine + attributesLines);
    }

    private String getRelationLine(TraversableEdge edge, IdLessTextRendererOptions options) {
        TraversableNode nodeFrom = edge.getNodeFrom();
        TraversableNode nodeTo = edge.getNodeTo();
        String typeRelationString = String.format("%s -> %s -> %s", nodeFrom.getType(), edge.getType(), nodeTo.getType());
        String relationString = "";
        Optional<String> attributeName = options.getNodeRelationAnnotationAttributeName();
        relationString = attributeName.isPresent() ? this.getAttributeRelationString(edge, attributeName.get()) : this.getHashRelationString(edge);
        return LineFormatter.createLine((String)(typeRelationString + " " + relationString), (int)options.getIndentLevel());
    }

    private String formatHashCodeAsString(int hashCode) {
        byte[] bytes = DigestUtils.md5((String)("" + hashCode));
        char[] hex = Hex.encodeHex((byte[])bytes);
        return new String(hex).toUpperCase().substring(0, 5);
    }

    private String getHashRelationString(TraversableEdge edge) {
        return String.format("(%s -> %s -> %s)", this.formatHashCodeAsString(edge.getNodeFrom().getIdlessHashCodeWithEdges()), this.formatHashCodeAsString(edge.getIdlessHashCode()), this.formatHashCodeAsString(edge.getNodeTo().getIdlessHashCodeWithEdges()));
    }

    private String getAttributeRelationString(TraversableEdge edge, String attributeName) {
        String nodeFromTag = "";
        String nodeToTag = "";
        nodeFromTag = edge.getNodeFrom().hasAttribute(attributeName) ? (String)edge.getNodeFrom().getAttribute(attributeName).getValue() : this.formatHashCodeAsString(edge.getNodeFrom().getIdlessHashCodeWithEdges());
        nodeToTag = edge.getNodeTo().hasAttribute(attributeName) ? (String)edge.getNodeTo().getAttribute(attributeName).getValue() : this.formatHashCodeAsString(edge.getNodeTo().getIdlessHashCodeWithEdges());
        return String.format("(%s -> %s -> %s)", nodeFromTag, this.formatHashCodeAsString(edge.getIdlessHashCode()), nodeToTag);
    }
}

