/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.renderer.infrastructure.textRenderer.node;

import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.IdLessTextRendererOptions;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.node.IdLessTextNodeRenderer;
import ai.stapi.graph.renderer.infrastructure.textRenderer.TextRendererOptions;
import ai.stapi.graph.renderer.infrastructure.textRenderer.node.TextNodeRenderOutput;
import ai.stapi.graph.renderer.model.RenderOutput;
import ai.stapi.graph.renderer.model.nodeRenderer.NodeRenderer;
import ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.utils.LineFormatter;
import org.springframework.beans.factory.annotation.Autowired;

public class TextNodeRenderer
implements NodeRenderer {
    private IdLessTextNodeRenderer idLessTextNodeRenderer;

    @Autowired
    public TextNodeRenderer(IdLessTextNodeRenderer idLessTextNodeRenderer) {
        this.idLessTextNodeRenderer = idLessTextNodeRenderer;
    }

    @Override
    public boolean supports(RendererOptions options) {
        return options.getClass().equals(TextRendererOptions.class);
    }

    @Override
    public RenderOutput render(TraversableNode node) {
        return this.render(node, new TextRendererOptions());
    }

    @Override
    public RenderOutput render(TraversableNode node, RendererOptions options) {
        TextRendererOptions downtypedOptions = (TextRendererOptions)options;
        int indentLevel = downtypedOptions.getIndentLevel();
        String idLessRenderedNodeString = this.idLessTextNodeRenderer.render(node, new IdLessTextRendererOptions(indentLevel)).toPrintableString();
        String renderedNodeIdLine = LineFormatter.createLine((String)("node_id: " + node.getId()), (int)indentLevel);
        return new TextNodeRenderOutput(renderedNodeIdLine + idLessRenderedNodeString);
    }
}

