/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.renderer.infrastructure.responseRenderer;

import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.ResponseRendererOptions;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.edge.ResponseEdgeRenderer;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.node.ResponseNodeRenderer;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.responseGraph.ResponseEdge;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.responseGraph.ResponseGraph;
import ai.stapi.graph.renderer.infrastructure.responseRenderer.responseGraph.ResponseNode;
import ai.stapi.graph.renderer.model.GraphRenderer;
import ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class ResponseGraphRenderer
implements GraphRenderer {
    private final ResponseNodeRenderer responseNodeRenderer;
    private final ResponseEdgeRenderer responseEdgeRenderer;

    public ResponseGraphRenderer(ResponseNodeRenderer responseNodeRenderer, ResponseEdgeRenderer responseEdgeRenderer) {
        this.responseNodeRenderer = responseNodeRenderer;
        this.responseEdgeRenderer = responseEdgeRenderer;
    }

    @Override
    public boolean supports(RendererOptions options) {
        return options instanceof ResponseRendererOptions;
    }

    @Override
    public ResponseGraph render(InMemoryGraphRepository graph) {
        return this.render(graph, new ResponseRendererOptions());
    }

    @Override
    public ResponseGraph render(InMemoryGraphRepository graph, RendererOptions options) {
        LinkedHashMap<String, ResponseNode> nodes = new LinkedHashMap<String, ResponseNode>();
        LinkedHashMap<String, ResponseEdge> edges = new LinkedHashMap<String, ResponseEdge>();
        graph.loadAllNodes().stream().sorted(Comparator.comparing(node -> node.getSortingNameWithNodeTypeFallback() + node.getIdlessHashCodeWithEdges())).map(traversableNode -> this.responseNodeRenderer.render((TraversableNode)traversableNode, options)).forEach(responseNode -> nodes.put(responseNode.getUuid(), (ResponseNode)responseNode));
        graph.loadAllEdges().stream().map(traversableEdge -> this.responseEdgeRenderer.render((TraversableEdge)traversableEdge, options)).sorted().forEach(responseEdge -> edges.put(responseEdge.getUuid(), (ResponseEdge)responseEdge));
        return new ResponseGraph(nodes, edges);
    }
}

