/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.attribute.attributeFactory.attributeValueFactory;

import ai.stapi.graph.attribute.attributeFactory.attributeValueFactory.AttributeValueFactory;
import ai.stapi.graph.attribute.attributeFactory.exceptions.CannotCreateAttribute;
import ai.stapi.graph.attribute.attributeValue.AttributeValue;
import ai.stapi.graph.attribute.attributeValue.PositiveIntegerAttributeValue;

public class PositiveIntegerValueFactory
implements AttributeValueFactory {
    @Override
    public AttributeValue<?> create(Object value, String attributeName) {
        if (!this.isValidValue(value)) {
            throw CannotCreateAttribute.becauseProvidedValueCouldNotBeConvertedToProvidedDataType(attributeName, "positiveInt", value);
        }
        return new PositiveIntegerAttributeValue((Integer)value);
    }

    @Override
    public boolean supportsDataType(String dataType) {
        return dataType.equals("positiveInt");
    }

    @Override
    public boolean isValidValue(Object value) {
        if (!(value instanceof Integer)) {
            return false;
        }
        Integer integerValue = (Integer)value;
        return integerValue >= 0;
    }
}

