/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graph.versionedAttributes;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.versionedAttributes.ImmutableVersionedAttribute;
import ai.stapi.graph.versionedAttributes.VersionedAttribute;
import ai.stapi.graph.versionedAttributes.exceptions.CannotAddNewVersionOfAttribute;
import ai.stapi.graph.versionedAttributes.exceptions.CannotMergeTwoVersionedAttributes;
import ai.stapi.graph.versionedAttributes.exceptions.VersionedAttributeCannotBeEmpty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AbstractVersionedAttribute<T extends Attribute<?>>
implements VersionedAttribute<T> {
    protected String attributeName;
    protected List<T> attributeVersions;

    protected AbstractVersionedAttribute() {
    }

    protected AbstractVersionedAttribute(List<T> attributeVersions) {
        this();
        if (attributeVersions.isEmpty()) {
            throw new VersionedAttributeCannotBeEmpty();
        }
        this.attributeName = ((Attribute)attributeVersions.get(0)).getName();
        List<Object> newAttributeVersions = new ArrayList();
        for (Attribute attributeVersion : attributeVersions) {
            newAttributeVersions = this.protectedAddToList(attributeVersion, newAttributeVersions);
        }
        this.attributeVersions = ImmutableList.copyOf(newAttributeVersions);
    }

    protected AbstractVersionedAttribute(List<T> attributeVersions, Attribute<?> attribute) {
        this();
        this.attributeName = ((Attribute)attributeVersions.get(0)).getName();
        this.attributeVersions = this.protectedAddToList(attribute, attributeVersions);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributeVersions.stream().anyMatch(attribute -> attribute.getValue().equals(value));
    }

    @Override
    public T getCurrent() {
        return (T)((Attribute)this.attributeVersions.get(0));
    }

    protected VersionedAttribute<T> protectedMergeOverwrite(VersionedAttribute<?> other) {
        if (!this.getName().equals(other.getName())) {
            throw CannotMergeTwoVersionedAttributes.becauseTheyHaveDifferentNames(this, other);
        }
        ArrayList<T> updatedVersions = new ArrayList<T>(this.attributeVersions);
        updatedVersions.addAll(other.streamAttributeVersions().map(attribute -> attribute).filter(otherAttribute -> !this.attributeVersions.contains(otherAttribute)).toList());
        return new ImmutableVersionedAttribute<T>(updatedVersions);
    }

    @Override
    public List<T> getAttributeVersions() {
        return this.attributeVersions;
    }

    @Override
    public Stream<T> streamAttributeVersions() {
        return this.attributeVersions.stream();
    }

    @Override
    public Iterator<T> iterateVersionsFromOldest() {
        return Lists.reverse(this.attributeVersions).iterator();
    }

    @Override
    public int numberOfVersions() {
        return this.attributeVersions.size();
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionedAttribute)) {
            return false;
        }
        VersionedAttribute otherVersionedAttribute = (VersionedAttribute)other;
        return this.getAttributeVersions().equals(otherVersionedAttribute.getAttributeVersions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(Lists.reverse(this.getAttributeVersions()));
    }

    protected List<T> protectedAddToList(Attribute<?> attribute, List<T> currentList) {
        if (currentList == null) {
            return currentList;
        }
        ArrayList<T> newAttributeList = new ArrayList<T>(currentList);
        Attribute mostRecentFromCurrentList = null;
        if (!currentList.isEmpty()) {
            mostRecentFromCurrentList = (Attribute)currentList.get(0);
            if (attribute.getValue().equals(mostRecentFromCurrentList.getValue())) {
                return newAttributeList;
            }
            if (!attribute.getName().equals(mostRecentFromCurrentList.getName())) {
                throw CannotAddNewVersionOfAttribute.becauseNewVersionHasDifferentNames(mostRecentFromCurrentList.getName(), attribute.getName());
            }
        }
        if (currentList.isEmpty() || !Objects.requireNonNull(mostRecentFromCurrentList).equals(attribute.getValue())) {
            if (attribute.getCreatedAt() == null) {
                attribute.setCreatedAt(Instant.now());
            }
            newAttributeList.add(attribute);
            newAttributeList.sort((a1, a2) -> a2.getCreatedAt().compareTo(a1.getCreatedAt()));
        }
        return newAttributeList;
    }
}

