/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql;

import ai.stapi.graphql.generateGraphQlSchema.PrintGraphQlSchema;
import java.util.Arrays;
import java.util.Optional;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;

public class PrintGraphQLCommandLineRunner
implements CommandLineRunner {
    private final CommandGateway commandGateway;
    private final ApplicationContext applicationContext;

    public PrintGraphQLCommandLineRunner(CommandGateway commandGateway, ApplicationContext applicationContext) {
        this.commandGateway = commandGateway;
        this.applicationContext = applicationContext;
    }

    public void run(String ... args) {
        if (args.length == 0) {
            throw new RuntimeException("Please specify path where to print schema as command line argument.");
        }
        Optional<String> path = Arrays.stream(args).filter(arg -> arg.startsWith("_schemaOutputPath:")).map(arg -> arg.replace("_schemaOutputPath:", "")).findFirst();
        PrintGraphQlSchema command = new PrintGraphQlSchema(path.orElse(args[0]));
        this.commandGateway.sendAndWait((Object)command);
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        System.exit(exitCode);
    }
}

