/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator;

import ai.stapi.graphql.generateGraphQlSchema.GraphQlSchemaGenerator;
import ai.stapi.graphql.graphqlJava.CommandGqlDataFetcher;
import ai.stapi.graphql.graphqlJava.GraphLoaderGqlDataFetcher;
import ai.stapi.graphql.graphqlJava.exceptions.CannotGenerateGraphQLSchema;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlFilterInputGenerator;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlObjectTypeGenerator;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlScalarSchemaGenerator;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlSortInputGenerator;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.BoxedPrimitiveStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.PrimitiveStructureType;
import ai.stapi.schema.structureSchema.ResourceStructureType;
import ai.stapi.schema.structureSchema.StructureSchema;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.SchemaPrinter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GraphQlJavaSchemaGenerator
implements GraphQlSchemaGenerator {
    protected static final GraphQLInputObjectType OFFSET_PAGINATION = GraphQLInputObjectType.newInputObject().name("OffsetPaginationOption").field(GraphQLInputObjectField.newInputObjectField().name("offset").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt))).field(GraphQLInputObjectField.newInputObjectField().name("limit").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt))).build();
    protected static final GraphQLObjectType MUTATION_RESPONSE = GraphQLObjectType.newObject().name("MutationResponse").field(GraphQLFieldDefinition.newFieldDefinition().name("successes").type((GraphQLOutputType)Scalars.GraphQLBoolean).build()).build();
    protected static final String ANY_NODE = "AnyNode";
    private final GraphQlSortInputGenerator graphQlSortInputGenerator;
    private final GraphQlFilterInputGenerator graphQlFilterInputGenerator;
    private final GraphQlObjectTypeGenerator graphQlObjectTypeGenerator;
    private final GraphQlScalarSchemaGenerator graphQlScalarSchemaGenerator;
    private final GraphLoaderGqlDataFetcher graphLoaderGqlDataFetcher;
    private final CommandGqlDataFetcher commandGqlDataFetcher;

    public GraphQlJavaSchemaGenerator(GraphQlSortInputGenerator graphQlSortInputGenerator, GraphQlFilterInputGenerator graphQlFilterInputGenerator, GraphQlObjectTypeGenerator graphQlObjectTypeGenerator, GraphQlScalarSchemaGenerator graphQlScalarSchemaGenerator, GraphLoaderGqlDataFetcher graphLoaderGqlDataFetcher, CommandGqlDataFetcher commandGqlDataFetcher) {
        this.graphQlSortInputGenerator = graphQlSortInputGenerator;
        this.graphQlFilterInputGenerator = graphQlFilterInputGenerator;
        this.graphQlObjectTypeGenerator = graphQlObjectTypeGenerator;
        this.graphQlScalarSchemaGenerator = graphQlScalarSchemaGenerator;
        this.graphLoaderGqlDataFetcher = graphLoaderGqlDataFetcher;
        this.commandGqlDataFetcher = commandGqlDataFetcher;
    }

    @Override
    public String generate(StructureSchema graphDefinition, List<ComplexStructureType> operationDefinitions) {
        GraphQLSchema qlSchema = this.generateSchema(graphDefinition, operationDefinitions);
        SchemaPrinter printer = new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeScalarTypes(true).includeIntrospectionTypes(false));
        return printer.print(qlSchema);
    }

    public GraphQLSchema generateSchema(StructureSchema graphDefinition, List<ComplexStructureType> operationDefinitions) {
        GraphQLSchema.Builder schema = GraphQLSchema.newSchema();
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();
        this.generateQuery(graphDefinition, schema, codeRegistry);
        this.generateMutations(operationDefinitions, graphDefinition, schema, codeRegistry);
        return schema.codeRegistry(codeRegistry.build()).build();
    }

    private void generateQuery(StructureSchema graphDefinition, GraphQLSchema.Builder schema, GraphQLCodeRegistry.Builder codeRegistry) {
        Map<String, GraphQLInputObjectType> sortInputs = this.graphQlSortInputGenerator.generateSortInputs(graphDefinition);
        sortInputs.values().forEach(arg_0 -> ((GraphQLSchema.Builder)schema).additionalType(arg_0));
        Map<String, GraphQLInputObjectType> filterInputs = this.graphQlFilterInputGenerator.generateFilterInputs(graphDefinition);
        filterInputs.values().forEach(arg_0 -> ((GraphQLSchema.Builder)schema).additionalType(arg_0));
        this.generateMainQueryObject(graphDefinition, schema, codeRegistry, sortInputs, filterInputs);
        this.generateComplexTypes(graphDefinition, schema, sortInputs, filterInputs);
        this.generatePrimitiveTypes(graphDefinition, schema);
        this.generateAnyNodeUnion(graphDefinition, schema);
    }

    private void generateMainQueryObject(StructureSchema graphDefinition, GraphQLSchema.Builder schema, GraphQLCodeRegistry.Builder codeRegistry, Map<String, GraphQLInputObjectType> sortInputs, Map<String, GraphQLInputObjectType> filterInputs) {
        GraphQLObjectType.Builder queryObjectBuilder = GraphQLObjectType.newObject().name("Query");
        graphDefinition.getStructureTypes().values().stream().filter(definition -> definition instanceof ResourceStructureType).forEach(definition -> this.addResourceToQueryObjectAndCodeRegistry(queryObjectBuilder, codeRegistry, definition.getDefinitionType(), sortInputs, filterInputs));
        schema.query(queryObjectBuilder);
    }

    private void generateComplexTypes(StructureSchema graphDefinition, GraphQLSchema.Builder schema, Map<String, GraphQLInputObjectType> sortInputs, Map<String, GraphQLInputObjectType> filterInputs) {
        graphDefinition.getStructureTypes().values().stream().filter(definition -> definition instanceof ComplexStructureType).map(definition -> this.graphQlObjectTypeGenerator.generateObjectType((AbstractStructureType)definition, graphDefinition, sortInputs, filterInputs)).flatMap(Collection::stream).forEach(arg_0 -> ((GraphQLSchema.Builder)schema).additionalType(arg_0));
    }

    private void generatePrimitiveTypes(StructureSchema graphDefinition, GraphQLSchema.Builder schema) {
        graphDefinition.getStructureTypes().values().stream().filter(definition -> definition instanceof PrimitiveStructureType).map(definition -> (PrimitiveStructureType)definition).map(this.graphQlScalarSchemaGenerator::generateScalarType).forEach(arg_0 -> ((GraphQLSchema.Builder)schema).additionalType(arg_0));
    }

    private void generateAnyNodeUnion(StructureSchema graphDefinition, GraphQLSchema.Builder schema) {
        GraphQLUnionType.Builder anyNodeUnion = new GraphQLUnionType.Builder().name(ANY_NODE).description("High level Union type of all types in this schema.").typeResolver(env -> null);
        List<AbstractStructureType> concreteStructureDefinitions = graphDefinition.getStructureTypes().values().stream().filter(definition -> !(definition instanceof PrimitiveStructureType)).filter(definition -> !definition.isAbstract()).toList();
        if (!concreteStructureDefinitions.isEmpty()) {
            concreteStructureDefinitions.forEach(definition -> anyNodeUnion.possibleType(new GraphQLTypeReference(definition.getDefinitionType())));
            schema.additionalType((GraphQLType)anyNodeUnion.build());
        }
    }

    private void addResourceToQueryObjectAndCodeRegistry(GraphQLObjectType.Builder builder, GraphQLCodeRegistry.Builder codeRegistry, String typeName, Map<String, GraphQLInputObjectType> sortInputTypes, Map<String, GraphQLInputObjectType> filterInputTypes) {
        String getFieldName = "get" + typeName;
        String findFieldName = "find" + typeName + "List";
        builder.field(GraphQLFieldDefinition.newFieldDefinition().name(getFieldName).type((GraphQLOutputType)new GraphQLTypeReference(typeName)).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLString)).build()));
        GraphQLFieldDefinition.Builder filterFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(findFieldName).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)new GraphQLTypeReference(typeName)))));
        GraphQLInputObjectType sortInputType = sortInputTypes.get(this.graphQlSortInputGenerator.createSortInputTypeName(typeName));
        GraphQLInputObjectType filterInputType = filterInputTypes.get(this.graphQlFilterInputGenerator.createLogicalFilterInputTypeName(typeName));
        if (sortInputType != null) {
            filterFieldDefinitionBuilder.argument(GraphQLArgument.newArgument().name("sort").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)sortInputType))));
        }
        if (filterInputType != null) {
            filterFieldDefinitionBuilder.argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)filterInputType))));
        }
        filterFieldDefinitionBuilder.argument(GraphQLArgument.newArgument().name("pagination").type((GraphQLInputType)OFFSET_PAGINATION));
        builder.field(filterFieldDefinitionBuilder);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)"Query", (String)getFieldName), (DataFetcher)this.graphLoaderGqlDataFetcher);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)"Query", (String)findFieldName), (DataFetcher)this.graphLoaderGqlDataFetcher);
    }

    private void generateMutations(List<ComplexStructureType> operationDefinitions, StructureSchema graphDefinition, GraphQLSchema.Builder schema, GraphQLCodeRegistry.Builder codeRegistry) {
        if (operationDefinitions.isEmpty()) {
            return;
        }
        GraphQLObjectType.Builder mutationObjectBuilder = GraphQLObjectType.newObject().name("Mutation");
        operationDefinitions.stream().filter(type -> !type.getAllFields().values().stream().allMatch(FieldDefinition::isUnionType)).forEach(structureType -> this.generateCommand(graphDefinition, (ComplexStructureType)structureType, mutationObjectBuilder, codeRegistry));
        schema.mutation(mutationObjectBuilder);
        this.generateComplexInputTypes(graphDefinition, schema);
    }

    private void generateCommand(StructureSchema graphDefinition, ComplexStructureType structureType, GraphQLObjectType.Builder mutationBuilder, GraphQLCodeRegistry.Builder codeRegistry) {
        String commandPayloadName = this.createCommandPayloadName(structureType.getDefinitionType());
        GraphQLInputObjectType.Builder commandPayloadInputBuilder = GraphQLInputObjectType.newInputObject().name(commandPayloadName).description(structureType.getDescription());
        structureType.getAllFields().values().stream().filter(field -> !field.getName().equals("id")).forEach(field -> {
            if (field.getTypes().isEmpty()) {
                throw CannotGenerateGraphQLSchema.becauseOperationReferencedTypeWhichDoesNotExistInStructureSchema(structureType.getDefinitionType(), "Any");
            }
            if (field.getTypes().size() > 1) {
                GraphQLInputObjectType.Builder fakeUnionTypeBuilder = GraphQLInputObjectType.newInputObject().name(commandPayloadName + StringUtils.capitalize((String)field.getName())).description("Generated input object which works as a union type, only exactly one field should be specified.");
                field.getTypes().forEach(fieldType -> {
                    GraphQLScalarType graphQLInputType;
                    String type = fieldType.getType();
                    AbstractStructureType fieldStructureType = graphDefinition.getDefinition(type);
                    if (fieldStructureType == null) {
                        throw CannotGenerateGraphQLSchema.becauseOperationReferencedTypeWhichDoesNotExistInStructureSchema(structureType.getDefinitionType(), type);
                    }
                    if (fieldStructureType instanceof PrimitiveStructureType) {
                        graphQLInputType = GraphQlObjectTypeGenerator.FIELD_TYPE_SPECIAL_CASES.getOrDefault(type, (GraphQLType)new GraphQLTypeReference(type));
                    } else if (fieldType.isReference()) {
                        graphQLInputType = Scalars.GraphQLID;
                    } else if (fieldStructureType instanceof BoxedPrimitiveStructureType) {
                        String unboxed = this.unbox(type);
                        graphQLInputType = GraphQlObjectTypeGenerator.FIELD_TYPE_SPECIAL_CASES.getOrDefault(unboxed, (GraphQLType)new GraphQLTypeReference(unboxed));
                    } else {
                        graphQLInputType = new GraphQLTypeReference(this.createInputTypeName(type));
                    }
                    fakeUnionTypeBuilder.field(GraphQLInputObjectField.newInputObjectField().name(fieldStructureType instanceof BoxedPrimitiveStructureType ? this.unbox(type) : type).type((GraphQLInputType)graphQLInputType));
                });
                GraphQLInputObjectType fakeUnionType = fakeUnionTypeBuilder.build();
                if (field.getMax().equals("*") || Integer.parseInt(field.getMax()) > 1) {
                    fakeUnionType = GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)fakeUnionType));
                }
                if (field.getMin() > 0) {
                    fakeUnionType = GraphQLNonNull.nonNull((GraphQLType)fakeUnionType);
                }
                commandPayloadInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name(field.getName()).type((GraphQLInputType)fakeUnionType).build());
                return;
            }
            String type = ((FieldType)field.getTypes().get(0)).getType();
            AbstractStructureType fieldStructureType = graphDefinition.getDefinition(type);
            if (fieldStructureType == null) {
                throw CannotGenerateGraphQLSchema.becauseOperationReferencedTypeWhichDoesNotExistInStructureSchema(structureType.getDefinitionType(), type);
            }
            Object graphQLInputType = fieldStructureType instanceof PrimitiveStructureType ? GraphQlObjectTypeGenerator.FIELD_TYPE_SPECIAL_CASES.getOrDefault(type, (GraphQLType)new GraphQLTypeReference(type)) : (fieldStructureType instanceof ResourceStructureType ? Scalars.GraphQLID : new GraphQLTypeReference(this.createInputTypeName(type)));
            if (field.getMax().equals("*") || Integer.parseInt(field.getMax()) > 1) {
                graphQLInputType = GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)graphQLInputType));
            }
            if (field.getMin() > 0) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            commandPayloadInputBuilder.field(GraphQLInputObjectField.newInputObjectField().name(field.getName()).type((GraphQLInputType)graphQLInputType).build());
        });
        String mutationFieldName = StringUtils.uncapitalize((String)structureType.getDefinitionType());
        mutationBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(mutationFieldName).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)Scalars.GraphQLID)).argument(this.createPayloadArgument(commandPayloadInputBuilder)).type((GraphQLOutputType)MUTATION_RESPONSE).build());
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)mutationFieldName), (DataFetcher)this.commandGqlDataFetcher);
    }

    private void generateComplexInputTypes(StructureSchema graphDefinition, GraphQLSchema.Builder schema) {
        if (graphDefinition.containsDefinition("Resource")) {
            AbstractStructureType resourceType = graphDefinition.getDefinition("Resource");
            GraphQLInputObjectType inputType = this.createInputType((ComplexStructureType)resourceType);
            schema.additionalType((GraphQLType)inputType);
        }
        graphDefinition.getStructureTypes().values().stream().filter(ComplexStructureType.class::isInstance).filter(abstractStructureType -> !abstractStructureType.getKind().equals("resource")).map(ComplexStructureType.class::cast).map(this::createInputType).forEach(arg_0 -> ((GraphQLSchema.Builder)schema).additionalType(arg_0));
    }

    private GraphQLInputObjectType createInputType(ComplexStructureType complexStructureType) {
        String inputTypeName = this.createInputTypeName(complexStructureType.getDefinitionType());
        GraphQLInputObjectType.Builder inputTypeBuilder = GraphQLInputObjectType.newInputObject().name(inputTypeName);
        complexStructureType.getAllFields().values().forEach(field -> this.createInputTypeField(inputTypeBuilder, (FieldDefinition)field, inputTypeName));
        return inputTypeBuilder.build();
    }

    private void createInputTypeField(GraphQLInputObjectType.Builder inputTypeBuilder, FieldDefinition field, String parentTypeName) {
        if (field.isAnyType()) {
            return;
        }
        if (!field.isUnionType()) {
            FieldType type2 = (FieldType)field.getTypes().get(0);
            GraphQLInputType graphQLInputType = this.createInputFieldType(type2);
            inputTypeBuilder.field(new GraphQLInputObjectField.Builder().name(field.getName()).type(this.makeInputTypeRequiredAndListIfNeeded(field, graphQLInputType)));
            return;
        }
        GraphQLInputObjectType.Builder fakeUnionType = GraphQLInputObjectType.newInputObject().name(parentTypeName + StringUtils.capitalize((String)field.getName())).description("Generated Input Type, which works as a Union type. Only one field should be filled.");
        field.getTypes().forEach(type -> {
            GraphQLInputType graphQLInputType = this.createInputFieldType((FieldType)type);
            fakeUnionType.field(new GraphQLInputObjectField.Builder().name(type.isBoxed() ? type.getOriginalType() : type.getType()).type(graphQLInputType));
        });
        inputTypeBuilder.field(new GraphQLInputObjectField.Builder().name(field.getName()).type(this.makeInputTypeRequiredAndListIfNeeded(field, (GraphQLInputType)fakeUnionType.build())));
    }

    private GraphQLInputType createInputFieldType(FieldType type) {
        String typeString;
        if (type.isReference()) {
            return Scalars.GraphQLID;
        }
        String string = typeString = type.isBoxed() ? type.getOriginalType() : type.getType();
        if (type.isPrimitiveType() || type.isBoxed()) {
            return (GraphQLInputType)GraphQlObjectTypeGenerator.FIELD_TYPE_SPECIAL_CASES.getOrDefault(typeString, (GraphQLType)new GraphQLTypeReference(typeString));
        }
        return new GraphQLTypeReference(this.createInputTypeName(typeString));
    }

    private GraphQLInputType makeInputTypeRequiredAndListIfNeeded(FieldDefinition field, GraphQLInputType graphQLInputType) {
        if (field.isList()) {
            graphQLInputType = GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)graphQLInputType));
        }
        if (field.isRequired()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        return graphQLInputType;
    }

    private GraphQLArgument.Builder createPayloadArgument(GraphQLInputObjectType.Builder inputBuilder) {
        return GraphQLArgument.newArgument().name("payload").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)inputBuilder.build()));
    }

    @NotNull
    private String createCommandPayloadName(String operationName) {
        return operationName + "CommandPayloadInput";
    }

    private String createInputTypeName(String type) {
        return type + "CommandInput";
    }

    @NotNull
    private String unbox(String type) {
        return StringUtils.uncapitalize((String)type.replace("Boxed", ""));
    }
}

