/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.generateGraphQlSchema;

import ai.stapi.graphql.generateGraphQlSchema.GraphQlSchemaGenerator;
import ai.stapi.graphql.generateGraphQlSchema.PrintGraphQlSchema;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionProvider;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionStructureTypeMapper;
import ai.stapi.schema.structureSchema.StructureSchema;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.axonframework.commandhandling.CommandHandler;

public class PrintGraphQlSchemaCommandHandler {
    private final GraphQlSchemaGenerator graphQlSchemaGenerator;
    private final StructureSchemaProvider graphDefinitionProvider;
    private final OperationDefinitionProvider operationDefinitionProvider;
    private final OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper;

    public PrintGraphQlSchemaCommandHandler(GraphQlSchemaGenerator graphQlSchemaGenerator, StructureSchemaProvider graphDefinitionProvider, OperationDefinitionProvider operationDefinitionProvider, OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper) {
        this.graphQlSchemaGenerator = graphQlSchemaGenerator;
        this.graphDefinitionProvider = graphDefinitionProvider;
        this.operationDefinitionProvider = operationDefinitionProvider;
        this.operationDefinitionStructureTypeMapper = operationDefinitionStructureTypeMapper;
    }

    @CommandHandler
    public void handle(PrintGraphQlSchema command) throws IOException {
        StructureSchema graphDefinition = this.graphDefinitionProvider.provideSchema();
        List operationDefinitions = this.operationDefinitionProvider.provideAll();
        String schema = this.graphQlSchemaGenerator.generate(graphDefinition, this.operationDefinitionStructureTypeMapper.map(operationDefinitions));
        try (FileWriter writer = new FileWriter(command.getOutputPath());){
            writer.write(schema);
        }
    }
}

