/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.graphqlJava;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.UuidIdentityDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.AttributeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.CollectionComparisonOperator;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.NodeQueryGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.OutgoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoader;
import ai.stapi.graphoperations.graphLoader.GraphLoaderFindAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderGetAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.search.SearchOption;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParameters;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParametersBuilder;
import ai.stapi.graphoperations.graphLoader.search.filterOption.AbstractOneValueFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.factory.FilterOptionFactory;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.OffsetPaginationOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.PaginationOption;
import ai.stapi.graphoperations.graphLoader.search.sortOption.AscendingSortOption;
import ai.stapi.graphoperations.graphLoader.search.sortOption.DescendingSortOption;
import ai.stapi.graphoperations.graphLoader.search.sortOption.SortOption;
import ai.stapi.graphql.graphqlJava.exceptions.CannotLoadRequestedDataByGraphQL;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlFilterInputGenerator;
import ai.stapi.identity.UniqueIdentifier;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GraphLoaderGqlDataFetcher
implements DataFetcher<Object> {
    public static final OffsetPaginationOption DEFAULT_MAIN_PAGINATION = new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(10));
    public static final OffsetPaginationOption DEFAULT_INNER_PAGINATION = new OffsetPaginationOption(Integer.valueOf(0), Integer.valueOf(100));
    private final GraphLoader graphLoader;
    private final FilterOptionFactory filterOptionFactory;

    public GraphLoaderGqlDataFetcher(GraphLoader graphLoader, FilterOptionFactory filterOptionFactory) {
        this.graphLoader = graphLoader;
        this.filterOptionFactory = filterOptionFactory;
    }

    public Object get(DataFetchingEnvironment environment) {
        GraphQLNonNull graphQLNonNull;
        GraphQLType innerType;
        NodeQueryGraphDescription graphDescription = this.createGraphDescription(environment);
        GraphQLOutputType type = environment.getFieldDefinition().getType();
        if (type instanceof GraphQLObjectType && environment.containsArgument("id")) {
            String id = (String)environment.getArgument("id");
            GraphLoaderGetAsObjectOutput output = this.graphLoader.get(new UniqueIdentifier(id), (GraphElementQueryDescription)graphDescription, Object.class, new GraphLoaderReturnType[0]);
            return output.getData();
        }
        if (type instanceof GraphQLNonNull && (innerType = (graphQLNonNull = (GraphQLNonNull)type).getWrappedType()) instanceof GraphQLList) {
            GraphLoaderFindAsObjectOutput output = this.graphLoader.find((GraphElementQueryDescription)graphDescription, Object.class, new GraphLoaderReturnType[0]);
            return output.getData();
        }
        throw CannotLoadRequestedDataByGraphQL.becauseInvalidFieldInQuery(environment.getFieldDefinition());
    }

    private NodeQueryGraphDescription createGraphDescription(DataFetchingEnvironment environment) {
        GraphQLOutputType type = environment.getFieldDefinition().getType();
        GraphQLType unwrappedType = this.unwrapFromListOrNonnull((GraphQLType)type);
        OperationDefinition documentDefinition = (OperationDefinition)environment.getDocument().getDefinitions().get(0);
        SelectionSet mainSelectionSet = documentDefinition.getSelectionSet();
        Field mainSelection = (Field)mainSelectionSet.getSelections().stream().filter(Field.class::isInstance).filter(selection -> ((Field)selection).getName().equals(environment.getFieldDefinition().getName())).toList().get(0);
        SelectionSet innerSelectionSet = mainSelection.getSelectionSet();
        if (unwrappedType instanceof GraphQLObjectType) {
            GraphQLObjectType graphQLObjectType = (GraphQLObjectType)unwrappedType;
            List<GraphDescription> childGraphDescriptions = this.createChildGraphDescriptions(innerSelectionSet, graphQLObjectType);
            List arguments = mainSelection.getArguments();
            SearchQueryParameters searchQueryParameters = this.deserializeSearchQueryParameters(arguments, graphQLObjectType, childGraphDescriptions, DEFAULT_MAIN_PAGINATION);
            return new NodeQueryGraphDescription(new NodeDescriptionParameters(graphQLObjectType.getName()), searchQueryParameters, childGraphDescriptions);
        }
        throw CannotLoadRequestedDataByGraphQL.becauseInvalidFieldInQuery(environment.getFieldDefinition());
    }

    private List<GraphDescription> createChildGraphDescriptions(SelectionSet selectionSet, GraphQLObjectType type) {
        return selectionSet.getSelections().stream().filter(Field.class::isInstance).map(Field.class::cast).filter(field -> !field.getName().equals("__typename")).map(field -> this.createChildGraphDescription((Field)field, type.getFieldDefinition(field.getName()))).toList();
    }

    private GraphDescription createChildGraphDescription(Field field, GraphQLFieldDefinition fieldDefinition) {
        GraphQLType unwrappedType = this.unwrapFromListOrNonnull((GraphQLType)fieldDefinition.getType());
        if (unwrappedType instanceof GraphQLScalarType) {
            if (fieldDefinition.getName().equals("id")) {
                return new UuidIdentityDescription();
            }
            return new AttributeQueryDescription(field.getName());
        }
        if (unwrappedType instanceof GraphQLObjectType) {
            GraphQLObjectType graphQLObjectType = (GraphQLObjectType)unwrappedType;
            List<GraphDescription> childGraphDescriptions = this.createChildGraphDescriptions(field.getSelectionSet(), graphQLObjectType);
            List arguments = field.getArguments();
            SearchQueryParameters searchQueryParameters = this.deserializeSearchQueryParameters(arguments, graphQLObjectType, childGraphDescriptions, DEFAULT_INNER_PAGINATION);
            SearchQueryParameters fixedSearchQueryParameters = this.fixChildSearchQueryParameters(graphQLObjectType.getName(), searchQueryParameters);
            NodeQueryGraphDescription nodeQueryGraphDescription = new NodeQueryGraphDescription(new NodeDescriptionParameters(graphQLObjectType.getName()), SearchQueryParameters.from((SearchOption[])new SearchOption[0]), childGraphDescriptions);
            return new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters(fieldDefinition.getName()), fixedSearchQueryParameters, new GraphDescription[]{nodeQueryGraphDescription});
        }
        throw CannotLoadRequestedDataByGraphQL.becauseInnerFieldWasNotObjectOrScalar(fieldDefinition);
    }

    private SearchQueryParameters deserializeSearchQueryParameters(List<Argument> arguments, GraphQLObjectType type, List<GraphDescription> childGraphDescriptions, OffsetPaginationOption defaultPagination) {
        Optional<Argument> optionalPagination = arguments.stream().filter(argument -> argument.getName().equals("pagination")).findFirst();
        Optional<Argument> optionalSort = arguments.stream().filter(argument -> argument.getName().equals("sort")).findFirst();
        Optional<Argument> optionalFilter = arguments.stream().filter(argument -> argument.getName().equals("filter")).findFirst();
        SearchQueryParametersBuilder parametersBuilder = SearchQueryParameters.builder();
        if (optionalPagination.isPresent()) {
            Argument pagination = optionalPagination.get();
            parametersBuilder.setPaginationOption((PaginationOption)this.deserializeOffsetPaginationOption(pagination));
        } else {
            parametersBuilder.setPaginationOption((PaginationOption)defaultPagination);
        }
        if (optionalSort.isPresent()) {
            Argument sort = optionalSort.get();
            parametersBuilder.addSortOptions(this.deserializeSortOptions(sort, type, childGraphDescriptions));
        }
        if (optionalFilter.isPresent()) {
            Argument filter = optionalFilter.get();
            parametersBuilder.addFilterOptions(this.deserializeFilterOptions(filter, type));
        }
        return parametersBuilder.build();
    }

    @NotNull
    private OffsetPaginationOption deserializeOffsetPaginationOption(Argument pagination) {
        ObjectValue paginationValue = (ObjectValue)pagination.getValue();
        List fields = paginationValue.getObjectFields();
        IntValue limit = (IntValue)fields.stream().filter(paginationField -> paginationField.getName().equals("limit")).findFirst().orElseThrow().getValue();
        IntValue offset = (IntValue)fields.stream().filter(paginationField -> paginationField.getName().equals("offset")).findFirst().orElseThrow().getValue();
        return new OffsetPaginationOption(Integer.valueOf(offset.getValue().intValue()), Integer.valueOf(limit.getValue().intValue()));
    }

    private List<SortOption> deserializeSortOptions(Argument sort, GraphQLObjectType type, List<GraphDescription> childGraphDescriptions) {
        ArrayValue sortValue = (ArrayValue)sort.getValue();
        return sortValue.getValues().stream().map(value -> this.deserializeSortOption((ObjectValue)value, type, childGraphDescriptions)).toList();
    }

    private List<FilterOption<?>> deserializeFilterOptions(Argument filter, GraphQLObjectType type) {
        ArrayValue filterValue = (ArrayValue)filter.getValue();
        ArrayList filterOptions = new ArrayList();
        filterValue.getValues().forEach(value -> filterOptions.add(this.deserializeFilterOption((ObjectValue)value, type)));
        return filterOptions;
    }

    private SortOption deserializeSortOption(ObjectValue sortOptionValue, GraphQLObjectType type, List<GraphDescription> childGraphDescriptions) {
        List fields = sortOptionValue.getObjectFields();
        if (fields.size() != 1) {
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedSortOptionDidNotHaveExactlyOneField(sortOptionValue);
        }
        ObjectField field = (ObjectField)fields.get(0);
        Value value = field.getValue();
        if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            if (enumValue.getName().equals("ASC")) {
                return new AscendingSortOption(field.getName());
            }
            return new DescendingSortOption(field.getName());
        }
        value = field.getValue();
        if (value instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)value;
            String fieldName = field.getName();
            GraphQLOutputType fieldType = type.getFieldDefinition(fieldName).getType();
            GraphQLObjectType unwrappedType = (GraphQLObjectType)this.unwrapFromListOrNonnull((GraphQLType)fieldType);
            Optional<OutgoingEdgeQueryDescription> maybeInnerEdgeDescription = childGraphDescriptions.stream().filter(OutgoingEdgeQueryDescription.class::isInstance).map(OutgoingEdgeQueryDescription.class::cast).filter(outgoingEdgeQueryDescription -> {
                EdgeDescriptionParameters params = (EdgeDescriptionParameters)outgoingEdgeQueryDescription.getParameters();
                return params.getEdgeType().equals(fieldName);
            }).findFirst();
            List<Object> newChildGraphDescriptions = new ArrayList<GraphDescription>();
            SearchQueryParameters edgeSearchOptions = SearchQueryParameters.from((SearchOption[])new SearchOption[0]);
            SearchQueryParameters nodeSearchOptions = SearchQueryParameters.from((SearchOption[])new SearchOption[0]);
            if (maybeInnerEdgeDescription.isPresent()) {
                OutgoingEdgeQueryDescription innerEdgeDescription = maybeInnerEdgeDescription.get();
                edgeSearchOptions = innerEdgeDescription.getSearchQueryParameters();
                Optional<NodeQueryGraphDescription> maybeInnerNodeDescription = innerEdgeDescription.getChildGraphDescriptions().stream().filter(NodeQueryGraphDescription.class::isInstance).map(NodeQueryGraphDescription.class::cast).findFirst();
                if (maybeInnerNodeDescription.isPresent()) {
                    NodeQueryGraphDescription innerNodeDescription = maybeInnerNodeDescription.get();
                    nodeSearchOptions = innerNodeDescription.getSearchQueryParameters();
                    newChildGraphDescriptions = innerNodeDescription.getChildGraphDescriptions();
                }
            }
            SortOption innerSort = this.deserializeSortOption(objectValue, unwrappedType, newChildGraphDescriptions);
            OutgoingEdgeQueryDescription newGraphDescription = new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters(fieldName), edgeSearchOptions, new GraphDescription[]{new NodeQueryGraphDescription(new NodeDescriptionParameters(unwrappedType.getName()), nodeSearchOptions, new GraphDescription[]{(GraphDescription)innerSort.getParameters()})});
            if (innerSort instanceof DescendingSortOption) {
                return new DescendingSortOption((PositiveGraphDescription)newGraphDescription);
            }
            return new AscendingSortOption((PositiveGraphDescription)newGraphDescription);
        }
        throw CannotLoadRequestedDataByGraphQL.becauseProvidedSortOptionWasOfUnknownType(field.getValue());
    }

    private FilterOption<?> deserializeFilterOption(ObjectValue filterOptionValue, GraphQLObjectType type) {
        List fields = filterOptionValue.getObjectFields();
        if (fields.size() != 1) {
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedFilterOptionDidNotHaveExactlyOneField(filterOptionValue);
        }
        ObjectField field = (ObjectField)fields.get(0);
        String fieldName = field.getName();
        Value fieldValue = field.getValue();
        int underscoreIndex = fieldName.indexOf("_");
        if (underscoreIndex == -1) {
            if (StringUtils.isAllUpperCase((CharSequence)fieldName)) {
                String filterStrategy = fieldName.toLowerCase();
                if (GraphQlFilterInputGenerator.MULTI_LOGICAL_FILTER_STRATEGIES.contains(filterStrategy)) {
                    if (fieldValue instanceof ArrayValue) {
                        ArrayValue arrayValue = (ArrayValue)fieldValue;
                        List<Value> invalidValueItems = arrayValue.getValues().stream().filter(itemValue -> !(itemValue instanceof ObjectValue)).toList();
                        if (!invalidValueItems.isEmpty()) {
                            throw CannotLoadRequestedDataByGraphQL.becauseProvidedLogicalFilterInputHadInvalidType(filterStrategy, invalidValueItems);
                        }
                        ArrayList children = new ArrayList();
                        arrayValue.getValues().stream().map(ObjectValue.class::cast).map(itemValue -> this.deserializeFilterOption((ObjectValue)itemValue, type)).forEach(children::add);
                        return this.filterOptionFactory.createLogical(filterStrategy, children);
                    }
                    throw CannotLoadRequestedDataByGraphQL.becauseProvidedMultiLogicalFilterInputWasNotOfArrayValue(filterStrategy, fieldValue);
                }
                if (filterStrategy.equals("not")) {
                    if (fieldValue instanceof ObjectValue) {
                        ObjectValue objectValue = (ObjectValue)fieldValue;
                        FilterOption<?> child = this.deserializeFilterOption(objectValue, type);
                        return this.filterOptionFactory.createLogical(filterStrategy, List.of(child));
                    }
                    throw CannotLoadRequestedDataByGraphQL.becauseProvidedLogicalFilterInputHadInvalidType(filterStrategy, List.of(fieldValue));
                }
            }
            if (fieldValue instanceof ObjectValue) {
                ObjectValue objectValue = (ObjectValue)fieldValue;
                GraphQLOutputType fieldType = type.getFieldDefinition(fieldName).getType();
                GraphQLObjectType unwrappedType = (GraphQLObjectType)this.unwrapFromListOrNonnull((GraphQLType)fieldType);
                FilterOption<?> innerFilter = this.deserializeFilterOption(objectValue, unwrappedType);
                PositiveGraphDescription innerGraphDescription = this.filterOptionFactory.getAttributeNamePath(innerFilter);
                OutgoingEdgeQueryDescription newGraphDescription = new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters(fieldName), SearchQueryParameters.from((SearchOption[])new SearchOption[0]), new GraphDescription[]{new NodeQueryGraphDescription(new NodeDescriptionParameters(unwrappedType.getName()), SearchQueryParameters.from((SearchOption[])new SearchOption[0]), new GraphDescription[]{innerGraphDescription})});
                return this.filterOptionFactory.copyWithNewAttributeNamePath(innerFilter, (PositiveGraphDescription)newGraphDescription);
            }
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedDeepFilterWasNotOfObjectValue(fieldName, fieldValue);
        }
        String attributeName = fieldName.substring(0, underscoreIndex);
        String filterStrategy = fieldName.substring(underscoreIndex + 1).toLowerCase();
        if (GraphQlFilterInputGenerator.LEAF_FILTER_STRATEGIES.contains(filterStrategy)) {
            return this.filterOptionFactory.createLeaf(filterStrategy, attributeName, this.deserializeScalarValue(field.getValue()));
        }
        if (GraphQlFilterInputGenerator.LIST_FILTER_STRATEGIES.contains(filterStrategy)) {
            if (fieldValue instanceof ObjectValue) {
                ObjectValue objectValue = (ObjectValue)fieldValue;
                List innerFields = objectValue.getObjectFields();
                if (innerFields.size() != 1) {
                    throw CannotLoadRequestedDataByGraphQL.becauseProvidedFilterOptionDidNotHaveExactlyOneField(objectValue);
                }
                ObjectField innerField = (ObjectField)innerFields.get(0);
                String innerFieldName = innerField.getName();
                if (StringUtils.isAllUpperCase((CharSequence)innerFieldName.replace("_", ""))) {
                    AbstractOneValueFilterOption leafFilter = this.filterOptionFactory.createLeaf(innerFieldName.toLowerCase(), attributeName, this.deserializeScalarValue(innerField.getValue()));
                    return this.filterOptionFactory.createList(filterStrategy, leafFilter);
                }
                GraphQLOutputType fieldType = type.getFieldDefinition(attributeName).getType();
                GraphQLObjectType unwrappedType = (GraphQLObjectType)this.unwrapFromListOrNonnull((GraphQLType)fieldType);
                FilterOption<?> innerFilter = this.deserializeFilterOption(objectValue, unwrappedType);
                PositiveGraphDescription innerGraphDescription = this.filterOptionFactory.getAttributeNamePath(innerFilter);
                OutgoingEdgeQueryDescription newGraphDescription = new OutgoingEdgeQueryDescription(new EdgeDescriptionParameters(attributeName), SearchQueryParameters.from((SearchOption[])new SearchOption[0]), this.getCollectionComparisonOperatorFromFilterStrategy(filterStrategy), new GraphDescription[]{new NodeQueryGraphDescription(new NodeDescriptionParameters(unwrappedType.getName()), SearchQueryParameters.from((SearchOption[])new SearchOption[0]), new GraphDescription[]{innerGraphDescription})});
                return this.filterOptionFactory.copyWithNewAttributeNamePath(innerFilter, (PositiveGraphDescription)newGraphDescription);
            }
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedListFilterInputWasNotOfObjectValue(filterStrategy, attributeName, fieldValue);
        }
        throw CannotLoadRequestedDataByGraphQL.becauseProvidedFilterOptionWasOfUnknownStrategy(filterStrategy);
    }

    private SearchQueryParameters fixChildSearchQueryParameters(String nodeType, SearchQueryParameters searchQueryParameters) {
        SearchQueryParametersBuilder builder = SearchQueryParameters.builder();
        builder.setPaginationOption(searchQueryParameters.getPaginationOption());
        searchQueryParameters.getSortOptions().forEach(sort -> {
            NodeDescription newGraphDescription = new NodeDescription(nodeType, new GraphDescription[]{(GraphDescription)sort.getParameters()});
            if (sort instanceof DescendingSortOption) {
                builder.addSortOption((SortOption)new DescendingSortOption((PositiveGraphDescription)newGraphDescription));
            } else {
                builder.addSortOption((SortOption)new AscendingSortOption((PositiveGraphDescription)newGraphDescription));
            }
        });
        searchQueryParameters.getFilterOptions().forEach(filter -> {
            NodeDescription newGraphDescription = new NodeDescription(nodeType, new GraphDescription[]{this.filterOptionFactory.getAttributeNamePath(filter)});
            builder.addFilterOption(this.filterOptionFactory.copyWithNewAttributeNamePath(filter, (PositiveGraphDescription)newGraphDescription));
        });
        return builder.build();
    }

    private Object deserializeScalarValue(Value<?> value) {
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return stringValue.getValue();
        }
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return booleanValue.isValue();
        }
        if (value instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value;
            return Float.valueOf(floatValue.getValue().floatValue());
        }
        if (value instanceof IntValue) {
            IntValue intValue = (IntValue)value;
            return intValue.getValue().intValue();
        }
        return value;
    }

    @NotNull
    private CollectionComparisonOperator getCollectionComparisonOperatorFromFilterStrategy(String filterStrategy) {
        if (filterStrategy.equals("none_match")) {
            return CollectionComparisonOperator.NONE;
        }
        if (filterStrategy.equals("all_match")) {
            return CollectionComparisonOperator.ALL;
        }
        return CollectionComparisonOperator.ANY;
    }

    private GraphQLType unwrapFromListOrNonnull(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLList) {
            GraphQLList graphQLList = (GraphQLList)graphQLType;
            return this.unwrapFromListOrNonnull(graphQLList.getWrappedType());
        }
        if (graphQLType instanceof GraphQLNonNull) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)graphQLType;
            return this.unwrapFromListOrNonnull(graphQLNonNull.getWrappedType());
        }
        return graphQLType;
    }

    private GraphQLType unwrapFromNonnull(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNonNull) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)graphQLType;
            return this.unwrapFromNonnull(graphQLNonNull.getWrappedType());
        }
        return graphQLType;
    }
}

