/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator;

import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlObjectTypeGenerator;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.PrimitiveStructureType;
import ai.stapi.schema.structureSchema.StructureSchema;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphQlFilterInputGenerator {
    public static final List<String> LEAF_FILTER_STRATEGIES = List.of("contains", "ends_with", "equals", "greater_than", "greater_than_or_equals", "lower_than", "lower_than_or_equals", "not_equals", "starts_with");
    public static final List<String> LIST_FILTER_STRATEGIES = List.of("all_match", "any_match", "none_match");
    public static final List<String> MULTI_LOGICAL_FILTER_STRATEGIES = List.of("and", "or");
    private static final List<String> STRING_TYPES = List.of("base64Binary", "canonical", "code", "id", "markdown", "oid", "string", "uri", "url", "uuid");
    private static final List<String> NUMBER_TYPES = List.of("date", "dateTime", "decimal", "instant", "integer", "positiveInt", "time", "unsignedInt");
    private static final List<String> STRING_FILTER_STRATEGIES = List.of("contains", "ends_with", "equals", "greater_than", "greater_than_or_equals", "lower_than", "lower_than_or_equals", "not_equals", "starts_with");
    private static final List<String> NUMBER_FILTER_STRATEGIES = List.of("equals", "greater_than", "greater_than_or_equals", "lower_than", "lower_than_or_equals", "not_equals");
    private static final List<String> DEFAULT_FILTER_STRATEGIES = List.of("equals", "not_equals");

    public Map<String, GraphQLInputObjectType> generateFilterInputs(StructureSchema structureSchema) {
        HashMap<String, GraphQLInputObjectType> filterInputTypeMap = new HashMap<String, GraphQLInputObjectType>();
        structureSchema.getStructureTypes().values().stream().filter(definition -> definition instanceof ComplexStructureType).map(definition -> (ComplexStructureType)definition).flatMap(definition -> this.generate((ComplexStructureType)definition, structureSchema).stream()).forEach(filterInput -> filterInputTypeMap.put(filterInput.getName(), (GraphQLInputObjectType)filterInput));
        return filterInputTypeMap;
    }

    private List<GraphQLInputObjectType> generate(ComplexStructureType structureType, StructureSchema structureSchema) {
        FilterFieldsAndSubtypes fieldsAndSubTypes = this.createFieldsAndSubTypes(structureType, structureSchema);
        String name = structureType.getDefinitionType();
        ArrayList<GraphQLInputObjectType> types = new ArrayList<GraphQLInputObjectType>();
        String logicalFilterInputTypeName = this.createLogicalFilterInputTypeName(name);
        GraphQLInputObjectType.Builder logicalBuilder = new GraphQLInputObjectType.Builder().name(logicalFilterInputTypeName);
        String filterInputTypeName = this.createFilterInputTypeName(name);
        GraphQLInputObjectType.Builder builder = new GraphQLInputObjectType.Builder().name(filterInputTypeName);
        fieldsAndSubTypes.fields().forEach(arg_0 -> ((GraphQLInputObjectType.Builder)logicalBuilder).field(arg_0));
        fieldsAndSubTypes.fields().forEach(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0));
        if (!fieldsAndSubTypes.fields().isEmpty()) {
            MULTI_LOGICAL_FILTER_STRATEGIES.stream().map(strategy -> new GraphQLInputObjectField.Builder().name(strategy.toUpperCase()).type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)new GraphQLTypeReference(logicalFilterInputTypeName))))).forEach(arg_0 -> ((GraphQLInputObjectType.Builder)logicalBuilder).field(arg_0));
            logicalBuilder.field(new GraphQLInputObjectField.Builder().name("not".toUpperCase()).type((GraphQLInputType)new GraphQLTypeReference(logicalFilterInputTypeName)));
            types.add(logicalBuilder.build());
            types.add(builder.build());
        }
        types.addAll(fieldsAndSubTypes.subtypes());
        return types;
    }

    private FilterFieldsAndSubtypes createFieldsAndSubTypes(ComplexStructureType structureType, StructureSchema structureSchema) {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
        ArrayList<GraphQLInputObjectType> subtypes = new ArrayList<GraphQLInputObjectType>();
        structureType.getAllFields().values().forEach(fieldDefinition -> {
            FilterFieldsAndSubtypes fieldAndSubtypes = this.createFieldsAndSubtypes(structureType, (FieldDefinition)fieldDefinition, structureSchema);
            if (fieldAndSubtypes != null) {
                fields.addAll(fieldAndSubtypes.fields());
                subtypes.addAll(fieldAndSubtypes.subtypes());
            }
        });
        return new FilterFieldsAndSubtypes(fields, subtypes);
    }

    @Nullable
    private FilterFieldsAndSubtypes createFieldsAndSubtypes(ComplexStructureType structureType, FieldDefinition fieldDefinition, StructureSchema structureSchema) {
        List<String> types = fieldDefinition.getTypes().stream().map(FieldType::getType).toList();
        ArrayList<GraphQLInputObjectType> subtypes = new ArrayList<GraphQLInputObjectType>();
        if (types.isEmpty()) {
            return null;
        }
        List<AbstractStructureType> typeGraphDefinitions = types.stream().map(arg_0 -> ((StructureSchema)structureSchema).getDefinition(arg_0)).toList();
        if (types.size() > 1) {
            return null;
        }
        AbstractStructureType typeGraphDefinition = typeGraphDefinitions.get(0);
        if (typeGraphDefinition instanceof PrimitiveStructureType) {
            if (this.isFieldList(fieldDefinition)) {
                List<GraphQLInputObjectField> defaultFilterStrategiesFields = DEFAULT_FILTER_STRATEGIES.stream().map(strategy -> GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName() + "_" + strategy.toUpperCase()).type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)this.getSpecialOrDefaultType(types)))).build()).toList();
                List<GraphQLInputObjectField> innerFields = this.getFilterGraphQLInputObjectFields(fieldDefinition, types, typeGraphDefinition, true);
                String childFilterInputTypeName = this.createFilterInputTypeName(structureType.getDefinitionType() + StringUtils.capitalize((String)fieldDefinition.getName()) + "Child");
                GraphQLInputObjectType.Builder childOptionsBuilder = new GraphQLInputObjectType.Builder().name(childFilterInputTypeName);
                innerFields.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)childOptionsBuilder).field(arg_0));
                subtypes.add(childOptionsBuilder.build());
                List<GraphQLInputObjectField> listFilterStrategiesFields = LIST_FILTER_STRATEGIES.stream().map(strategy -> GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName() + "_" + strategy.toUpperCase()).type((GraphQLInputType)new GraphQLTypeReference(childFilterInputTypeName)).build()).toList();
                ArrayList<GraphQLInputObjectField> finalFields = new ArrayList<GraphQLInputObjectField>(defaultFilterStrategiesFields);
                finalFields.addAll(listFilterStrategiesFields);
                return new FilterFieldsAndSubtypes(finalFields, subtypes);
            }
            List<GraphQLInputObjectField> fields = this.getFilterGraphQLInputObjectFields(fieldDefinition, types, typeGraphDefinition, false);
            return new FilterFieldsAndSubtypes(fields, subtypes);
        }
        if (this.isFieldList(fieldDefinition)) {
            return new FilterFieldsAndSubtypes(LIST_FILTER_STRATEGIES.stream().map(strategy -> GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName() + "_" + strategy.toUpperCase()).type((GraphQLInputType)new GraphQLTypeReference(this.createFilterInputTypeName((String)types.get(0)))).build()).toList(), subtypes);
        }
        return new FilterFieldsAndSubtypes(List.of(GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName()).type((GraphQLInputType)new GraphQLTypeReference(this.createFilterInputTypeName(types.get(0)))).build()), subtypes);
    }

    private List<GraphQLInputObjectField> getFilterGraphQLInputObjectFields(FieldDefinition fieldDefinition, List<String> types, AbstractStructureType typeGraphDefinition, boolean withShortNames) {
        if (STRING_TYPES.contains(typeGraphDefinition.getDefinitionType())) {
            return STRING_FILTER_STRATEGIES.stream().map(strategy -> GraphQLInputObjectField.newInputObjectField().name(this.getFieldName(fieldDefinition, (String)strategy, withShortNames)).type((GraphQLInputType)this.getSpecialOrDefaultType(types)).build()).toList();
        }
        if (NUMBER_TYPES.contains(typeGraphDefinition.getDefinitionType())) {
            return NUMBER_FILTER_STRATEGIES.stream().map(strategy -> GraphQLInputObjectField.newInputObjectField().name(this.getFieldName(fieldDefinition, (String)strategy, withShortNames)).type((GraphQLInputType)this.getSpecialOrDefaultType(types)).build()).toList();
        }
        if (typeGraphDefinition.getDefinitionType().equals("boolean")) {
            return DEFAULT_FILTER_STRATEGIES.stream().map(strategy -> GraphQLInputObjectField.newInputObjectField().name(this.getFieldName(fieldDefinition, (String)strategy, withShortNames)).type((GraphQLInputType)this.getSpecialOrDefaultType(types)).build()).toList();
        }
        return new ArrayList<GraphQLInputObjectField>();
    }

    @NotNull
    private String getFieldName(FieldDefinition fieldDefinition, String strategy, boolean withShortNames) {
        if (withShortNames) {
            return strategy.toUpperCase();
        }
        return fieldDefinition.getName() + "_" + strategy.toUpperCase();
    }

    @NotNull
    private GraphQLType getSpecialOrDefaultType(List<String> types) {
        String name = types.get(0);
        return GraphQlObjectTypeGenerator.FIELD_TYPE_SPECIAL_CASES.getOrDefault(name, (GraphQLType)new GraphQLTypeReference(name));
    }

    public String createLogicalFilterInputTypeName(String originalTypeName) {
        return originalTypeName + "LogicalFilterOption";
    }

    public String createFilterInputTypeName(String originalTypeName) {
        return originalTypeName + "FilterOption";
    }

    private boolean isFieldList(FieldDefinition fieldDefinition) {
        return fieldDefinition.getMax().equals("*") || Integer.parseInt(fieldDefinition.getMax()) > 1;
    }

    protected record FilterFieldsAndSubtypes(List<GraphQLInputObjectField> fields, List<GraphQLInputObjectType> subtypes) {
    }
}

