/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.graphqlJava;

import ai.stapi.graphql.graphqlJava.exceptions.CannotLoadRequestedDataByGraphQL;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionStructureTypeMapper;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.identity.UniversallyUniqueIdentifier;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.PrimitiveStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaProvider;
import ai.stapi.schema.structureSchemaProvider.exception.CannotProvideStructureSchema;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.axonframework.commandhandling.gateway.CommandGateway;

public class CommandGqlDataFetcher
implements DataFetcher<MutationResponse> {
    private final CommandGateway commandGateway;
    private final AggregateDefinitionProvider aggregateDefinitionProvider;
    private final StructureSchemaProvider graphDefinitionProvider;
    private final OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper;

    public CommandGqlDataFetcher(CommandGateway commandGateway, AggregateDefinitionProvider aggregateDefinitionProvider, StructureSchemaProvider graphDefinitionProvider, OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper) {
        this.commandGateway = commandGateway;
        this.aggregateDefinitionProvider = aggregateDefinitionProvider;
        this.graphDefinitionProvider = graphDefinitionProvider;
        this.operationDefinitionStructureTypeMapper = operationDefinitionStructureTypeMapper;
    }

    public MutationResponse get(DataFetchingEnvironment environment) throws Exception {
        Map<String, Object> mapPayload;
        String commandName = StringUtils.capitalize((String)environment.getFieldDefinition().getName());
        Optional<OperationDefinitionDTO> operationDefinition = this.aggregateDefinitionProvider.provideAll().stream().flatMap(aggregateDefinitionDTO -> aggregateDefinitionDTO.getCommand().stream()).map(CommandHandlerDefinitionDTO::getOperation).filter(operation -> operation.getId().equals(commandName)).findFirst();
        if (operationDefinition.isEmpty()) {
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedMutationDidNotHaveCorrespondingOperationDefinition(commandName);
        }
        OperationDefinition documentDefinition = (OperationDefinition)environment.getDocument().getDefinitions().get(0);
        SelectionSet mainSelectionSet = documentDefinition.getSelectionSet();
        Field mainSelection = mainSelectionSet.getSelections().stream().filter(Field.class::isInstance).map(Field.class::cast).filter(selection -> selection.getName().equals(environment.getFieldDefinition().getName())).toList().get(0);
        List arguments = mainSelection.getArguments();
        Value originalPayload = arguments.stream().filter(argument -> argument.getName().equals("payload")).findFirst().orElseThrow().getValue();
        if (originalPayload instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)originalPayload;
            mapPayload = this.transformToMap(objectValue);
        } else {
            mapPayload = (Map<String, Object>)environment.getVariables().get("payload");
        }
        ComplexStructureType fakedType = this.operationDefinitionStructureTypeMapper.map(operationDefinition.get());
        Map<String, Object> finalPayload = this.fixInnerPayload(fakedType.getDefinitionType(), fakedType, mapPayload);
        String id = (String)environment.getArgument("id");
        Object identifier = id == null ? UniversallyUniqueIdentifier.randomUUID() : UniqueIdentifier.fromString((String)id);
        DynamicCommand command = new DynamicCommand((UniqueIdentifier)identifier, commandName, finalPayload);
        this.commandGateway.send((Object)command);
        return new MutationResponse(true);
    }

    private Map<String, Object> fixInnerPayload(String commandName, ComplexStructureType parentStructureType, Map<?, ?> originalPayload) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        parentStructureType.getAllFields().values().forEach(fieldDefinition -> {
            AbstractStructureType structure;
            String fieldName = fieldDefinition.getName();
            if (originalPayload.keySet().stream().noneMatch(key -> key.toString().equals(fieldName))) {
                return;
            }
            Object originalValue = originalPayload.entrySet().stream().filter(field -> field.getKey().equals(fieldName)).findFirst().orElseThrow().getValue();
            if (fieldDefinition.isUnionType()) {
                if (originalValue instanceof List) {
                    List listOriginalValue = (List)originalValue;
                    finalPayload.put(fieldName, listOriginalValue.stream().map(valueItem -> this.getUnionMember(commandName, parentStructureType.getDefinitionType(), fieldDefinition.getName(), fieldDefinition.getTypes(), valueItem)).collect(Collectors.toList()));
                    return;
                }
                Object unionMemberValue = this.getUnionMember(commandName, parentStructureType.getDefinitionType(), fieldDefinition.getName(), fieldDefinition.getTypes(), originalValue);
                finalPayload.put(fieldName, unionMemberValue);
                return;
            }
            String fieldType = ((FieldType)fieldDefinition.getTypes().get(0)).getType();
            try {
                structure = this.graphDefinitionProvider.provideSpecific(fieldType);
            }
            catch (CannotProvideStructureSchema e) {
                throw CannotLoadRequestedDataByGraphQL.becauseProvidedMutationHadParameterOfComplexTypeWithSomeFieldWhichDoesNotHaveStructureSchema(commandName, parentStructureType.getDefinitionType(), fieldName, fieldType, e);
            }
            if (structure instanceof PrimitiveStructureType) {
                if (originalValue instanceof List) {
                    List listValue = (List)originalValue;
                    finalPayload.put(fieldName, listValue);
                    return;
                }
                finalPayload.put(fieldName, originalValue);
                return;
            }
            if (((FieldType)fieldDefinition.getTypes().get(0)).isReference()) {
                if (originalValue instanceof List) {
                    List listValue = (List)originalValue;
                    finalPayload.put(fieldName, listValue.stream().map(id -> Map.of("id", id)));
                    return;
                }
                finalPayload.put(fieldName, Map.of("id", originalValue));
                return;
            }
            if (structure instanceof ComplexStructureType) {
                ComplexStructureType complexStructureType = (ComplexStructureType)structure;
                if (originalValue instanceof Map) {
                    Map objectOriginalParameter = (Map)originalValue;
                    finalPayload.put(fieldName, this.fixInnerPayload(commandName, complexStructureType, objectOriginalParameter));
                    return;
                }
                if (originalValue instanceof List) {
                    List arrayValue = (List)originalValue;
                    finalPayload.put(fieldName, arrayValue.stream().map(originalItem -> this.fixInnerPayload(commandName, complexStructureType, (Map)originalItem)).collect(Collectors.toList()));
                    return;
                }
            }
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedMutationHadParameterOfComplexTypeWithSomeFieldOfUnknownType(commandName, parentStructureType.getDefinitionType(), fieldName, fieldType);
        });
        return finalPayload;
    }

    private Object getUnionMember(String commandName, String parentTypeName, String fieldName, List<FieldType> fieldTypes, Object originalFieldValue) {
        AbstractStructureType structure;
        if (!(originalFieldValue instanceof Map)) {
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedMutationHadParameterOfComplexTypeWithSomeInvalidUnionValue(commandName, parentTypeName, fieldName, originalFieldValue);
        }
        Map objectValue = (Map)originalFieldValue;
        if (objectValue.keySet().size() != 1) {
            throw CannotLoadRequestedDataByGraphQL.becauseUnionInputDidNotHaveExactlyOneMemberSpecified(commandName, parentTypeName, fieldName, originalFieldValue);
        }
        Map.Entry unionMemberField = (Map.Entry)objectValue.entrySet().stream().findFirst().orElseThrow();
        String memberType = (String)unionMemberField.getKey();
        Object memberValue = unionMemberField.getValue();
        FieldType fieldStructureType = fieldTypes.stream().filter(fieldType -> fieldType.isBoxed() ? fieldType.getOriginalType().equals(memberType) : fieldType.getType().equals(memberType)).findFirst().orElseThrow();
        try {
            structure = this.graphDefinitionProvider.provideSpecific(memberType);
        }
        catch (CannotProvideStructureSchema e) {
            throw CannotLoadRequestedDataByGraphQL.becauseProvidedMutationHadParameterOfComplexTypeWithSomeFieldWhichDoesNotHaveStructureSchema(commandName, parentTypeName, fieldName, memberType, e);
        }
        if (structure instanceof PrimitiveStructureType) {
            return Map.of("serializationType", String.format("Boxed%s", StringUtils.capitalize((String)memberType)), "value", memberValue);
        }
        if (fieldStructureType.isReference()) {
            return Map.of("serializationType", memberType, "id", memberValue);
        }
        if (structure instanceof ComplexStructureType) {
            ComplexStructureType complexStructureType = (ComplexStructureType)structure;
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            resultingMap.put("serializationType", memberType);
            resultingMap.putAll(this.fixInnerPayload(commandName, complexStructureType, (Map)memberValue));
            return resultingMap;
        }
        throw CannotLoadRequestedDataByGraphQL.becauseProvidedMutationHadParameterOfComplexTypeWithSomeFieldOfUnknownType(commandName, parentTypeName, fieldName, memberType);
    }

    private Map<String, Object> transformToMap(ObjectValue originalPayload) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ObjectField field : originalPayload.getObjectFields()) {
            String fieldName = field.getName();
            Value fieldValue = field.getValue();
            if (fieldValue instanceof ObjectValue) {
                ObjectValue objectValue = (ObjectValue)fieldValue;
                result.put(fieldName, this.transformToMap(objectValue));
                continue;
            }
            if (fieldValue instanceof ArrayValue) {
                ArrayValue arrayValue = (ArrayValue)fieldValue;
                ArrayList<Object> arrayResult = new ArrayList<Object>();
                for (Value itemValue : arrayValue.getValues()) {
                    if (itemValue instanceof ObjectValue) {
                        ObjectValue itemObjectValue = (ObjectValue)itemValue;
                        arrayResult.add(this.transformToMap(itemObjectValue));
                        continue;
                    }
                    arrayResult.add(this.deserializeScalarValue(itemValue));
                }
                result.put(fieldName, arrayResult);
                continue;
            }
            result.put(fieldName, this.deserializeScalarValue(fieldValue));
        }
        return result;
    }

    private Object deserializeScalarValue(Value<?> value) {
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return stringValue.getValue();
        }
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return booleanValue.isValue();
        }
        if (value instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value;
            return Float.valueOf(floatValue.getValue().floatValue());
        }
        if (value instanceof IntValue) {
            IntValue intValue = (IntValue)value;
            return intValue.getValue().intValue();
        }
        return value;
    }

    public static class MutationResponse {
        private final boolean success;

        public MutationResponse(boolean success) {
            this.success = success;
        }

        public boolean getSuccess() {
            return this.success;
        }
    }
}

