/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structuredefinition;

import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.serialization.SerializableObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class StructureDefinitionData
implements SerializableObject {
    public static final String SERIALIZATION_TYPE = "StructureDefinition";
    private String id;
    private String url;
    private String status;
    private String description;
    private String kind;
    private Boolean isAbstract;
    private String type;
    private String baseDefinition;
    private UniqueIdentifier baseDefinitionReference;
    private Differential differential;

    protected StructureDefinitionData() {
    }

    public StructureDefinitionData(String id, String url, String status, String description, String kind, Boolean isAbstract, String type, String baseDefinition, UniqueIdentifier baseDefinitionReference, Differential differential) {
        this.id = id;
        this.url = url;
        this.status = status;
        this.description = description;
        this.kind = kind;
        this.isAbstract = isAbstract;
        this.type = type;
        this.baseDefinition = baseDefinition;
        this.baseDefinitionReference = baseDefinitionReference;
        this.differential = differential;
    }

    public StructureDefinitionData(String id, String url, String status, String description, String kind, Boolean isAbstract, String type, String baseDefinition, UniqueIdentifier baseDefinitionReference, List<ElementDefinition> differential) {
        this.id = id;
        this.url = url;
        this.status = status;
        this.description = description;
        this.kind = kind;
        this.isAbstract = isAbstract;
        this.type = type;
        this.baseDefinition = baseDefinition;
        this.baseDefinitionReference = baseDefinitionReference;
        this.differential = new Differential(differential, this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="abstract")
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public String getType() {
        return this.type;
    }

    public Differential getDifferential() {
        return this.differential;
    }

    public UniqueIdentifier getBaseDefinitionReference() {
        return this.baseDefinitionReference;
    }

    public String getBaseDefinition() {
        return this.baseDefinition;
    }

    @JsonIgnore
    public String getSerializationType() {
        return SERIALIZATION_TYPE;
    }

    public String toString() {
        return "StructureDefinitionDTO{id='" + this.id + "', url='" + this.url + "', status='" + this.status + "', description='" + this.description + "', kind='" + this.kind + "', isAbstract=" + this.isAbstract + ", type='" + this.type + "', baseDefinition=" + this.baseDefinitionReference + ", differential=" + this.differential + "}";
    }

    public static class Differential
    implements SerializableObject {
        public static final String SERIALIZATION_TYPE = "StructureDefinitionDifferential";
        private List<ElementDefinition> element;
        private String parent;

        private Differential() {
        }

        public Differential(List<ElementDefinition> element, String parent) {
            this.element = element;
            this.parent = parent;
        }

        public List<ElementDefinition> getElement() {
            return this.element;
        }

        public String getParent() {
            return this.parent;
        }

        public String toString() {
            return "Differential{element=" + this.element + "}";
        }

        public String getSerializationType() {
            return SERIALIZATION_TYPE;
        }
    }
}

