/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchema;

import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.BoxedPrimitiveStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.ResourceStructureType;
import ai.stapi.schema.structureSchema.builder.ComplexStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.StructureSchemaBuilder;
import ai.stapi.schema.structureSchema.exception.StructureSchemaCreationException;
import ai.stapi.schema.structureSchema.exception.StructureSchemaException;
import ai.stapi.schema.structureSchemaMapper.UnresolvableSerializationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class StructureSchema {
    private Map<String, AbstractStructureType> definitions;

    public StructureSchema() {
        this.definitions = new HashMap<String, AbstractStructureType>();
    }

    public StructureSchema(Map<String, AbstractStructureType> abstractStructureType) {
        this.definitions = new HashMap<String, AbstractStructureType>(abstractStructureType);
        List<UnresolvableSerializationType> unresolvableTypes = new StructureSchemaBuilder(this.definitions).getUnresolvableTypesWithFailingDependencyList();
        if (unresolvableTypes.size() > 0) {
            throw StructureSchemaCreationException.becauseItContainsUnresolvableTypes(unresolvableTypes);
        }
    }

    public StructureSchema(AbstractStructureType ... types) {
        this(List.of(types));
    }

    public StructureSchema(List<AbstractStructureType> types) {
        this(StructureSchema.typesToMap(types));
    }

    public static StructureSchema createChecked(List<AbstractStructureType> types) {
        StructureSchema schema = new StructureSchema();
        schema.definitions = types.stream().collect(Collectors.toMap(AbstractStructureType::getDefinitionType, Function.identity()));
        return schema;
    }

    @NotNull
    private static HashMap<String, AbstractStructureType> typesToMap(List<AbstractStructureType> types) {
        HashMap<String, AbstractStructureType> definitions = new HashMap<String, AbstractStructureType>();
        types.forEach(type -> definitions.put(type.getDefinitionType(), (AbstractStructureType)((Object)type)));
        return definitions;
    }

    public Map<String, AbstractStructureType> getStructureTypes() {
        return this.definitions;
    }

    public AbstractStructureType getDefinition(String serializationType) {
        return this.definitions.get(serializationType);
    }

    public boolean containsDefinition(String serializationType) {
        return this.definitions.containsKey(serializationType);
    }

    public StructureSchema merge(StructureSchema other) {
        StructureSchemaBuilder schemaBuilder = new StructureSchemaBuilder(this);
        other.definitions.forEach((key, structureType) -> {
            if (this.definitions.containsKey(key) && !((Object)((Object)this.definitions.get(key))).equals(structureType)) {
                AbstractStructureType localStructure = this.definitions.get(key);
                if (localStructure instanceof ComplexStructureType) {
                    ComplexStructureType complexStructureType = (ComplexStructureType)localStructure;
                    if (!(localStructure instanceof BoxedPrimitiveStructureType)) {
                        ComplexStructureType otherStructure = (ComplexStructureType)((Object)structureType);
                        Map<String, FieldDefinition> otherFields = otherStructure.getAllFields();
                        Map<String, FieldDefinition> localFields = complexStructureType.getAllFields();
                        HashMap<String, FieldDefinition> combinedFields = new HashMap<String, FieldDefinition>();
                        combinedFields.putAll(localFields);
                        combinedFields.putAll(otherFields);
                        ComplexStructureTypeBuilder newStructure = new ComplexStructureTypeBuilder().copyToBuilder(localStructure);
                        if (!otherStructure.getParent().isBlank()) {
                            newStructure.setParent(otherStructure.getParent());
                        }
                        newStructure.setParent(otherStructure.getParent());
                        combinedFields.forEach((fieldName, field) -> newStructure.addField((String)fieldName).setMin(field.getMin()).setMax(field.getMax()).setName(field.getName()).setDescription(field.getDescription()).setTypes(field.getTypes()).setParentDefinitionType(field.getParentDefinitionType()));
                        this.definitions.put((String)key, newStructure.build(schemaBuilder));
                        return;
                    }
                }
                this.definitions.put((String)key, (AbstractStructureType)((Object)structureType));
                return;
            }
            this.definitions.put((String)key, (AbstractStructureType)((Object)structureType));
        });
        this.resolveParentFields();
        return this;
    }

    private void resolveParentFields() {
        ArrayList<ComplexStructureType> updatedDefinitions = new ArrayList<ComplexStructureType>();
        this.definitions.forEach((key, definition) -> {
            if (definition instanceof ComplexStructureType) {
                ComplexStructureType complexStructureType = (ComplexStructureType)((Object)definition);
                Map<String, FieldDefinition> parentFields = this.collectParentFields(complexStructureType);
                Map<String, FieldDefinition> definitionFields = complexStructureType.getAllFields();
                parentFields.putAll(definitionFields);
                if (complexStructureType instanceof BoxedPrimitiveStructureType) {
                    BoxedPrimitiveStructureType boxed = (BoxedPrimitiveStructureType)complexStructureType;
                    updatedDefinitions.add(boxed.copyWithNewFields((Map)parentFields));
                } else if (complexStructureType instanceof ResourceStructureType) {
                    ResourceStructureType resource = (ResourceStructureType)complexStructureType;
                    updatedDefinitions.add(resource.copyWithNewFields((Map)parentFields));
                } else {
                    updatedDefinitions.add(complexStructureType.copyWithNewFields(parentFields));
                }
            }
        });
        updatedDefinitions.forEach(updatedDefinition -> this.definitions.put(updatedDefinition.getDefinitionType(), (AbstractStructureType)((Object)updatedDefinition)));
    }

    private Map<String, FieldDefinition> collectParentFields(ComplexStructureType complexStructureType) {
        String parent = complexStructureType.getParent();
        if (parent.isBlank()) {
            return new HashMap<String, FieldDefinition>();
        }
        if (!this.definitions.containsKey(parent)) {
            throw StructureSchemaException.becauseParentDefinitionIsMissing(complexStructureType.getDefinitionType(), parent);
        }
        AbstractStructureType parentDefinition = this.definitions.get(parent);
        if (parentDefinition instanceof ComplexStructureType) {
            ComplexStructureType complexParent = (ComplexStructureType)parentDefinition;
            Map<String, FieldDefinition> map = this.collectParentFields(complexParent);
            map.putAll(complexParent.getAllFields());
            return map;
        }
        return new HashMap<String, FieldDefinition>();
    }

    public List<AbstractStructureType> getChildDefinitions(String parentSerializationType) {
        return this.definitions.values().stream().filter(abstractStructureType -> abstractStructureType.getParent() != null).filter(abstractStructureType -> abstractStructureType.getParent().equals(parentSerializationType)).toList();
    }

    public boolean has(String serializationType) {
        return this.definitions.containsKey(serializationType);
    }
}

