/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchemaMapper;

import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.StructureSchema;
import ai.stapi.schema.structureSchema.builder.AbstractStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.ComplexStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.FieldDefinitionBuilder;
import ai.stapi.schema.structureSchema.builder.PrimitiveStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.StructureSchemaBuilder;
import ai.stapi.schema.structureSchemaMapper.MappingOutcome;
import ai.stapi.schema.structureSchemaMapper.UnresolvableSerializationType;
import ai.stapi.schema.structureSchemaMapper.UnresolvableType;
import ai.stapi.schema.structureSchemaMapper.exception.UnresolvableTypeException;
import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.schema.structuredefinition.ElementDefinitionType;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionDataMerger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class StructureDefinitionToSSMapper {
    public MappingOutcome map(StructureDefinitionData structureDefinitions) {
        return this.map(List.of(structureDefinitions), new StructureSchema());
    }

    public MappingOutcome map(StructureDefinitionData structureDefinitions, StructureSchema context) {
        return this.map(List.of(structureDefinitions), context);
    }

    public MappingOutcome map(List<StructureDefinitionData> structureDefinitions) {
        return this.map(structureDefinitions, new StructureSchema());
    }

    public MappingOutcome map(List<StructureDefinitionData> structureDefinitions, StructureSchema context) {
        if (structureDefinitions.isEmpty()) {
            return new MappingOutcome(context, new ArrayList<UnresolvableType>(), new ArrayList<String>());
        }
        StructureSchemaBuilder schemaBuilder = new StructureSchemaBuilder(context);
        structureDefinitions.forEach(definition -> {
            if (definition.getKind() == null) {
                throw new UnresolvableTypeException("Kind is null for " + definition.getId());
            }
            if (definition.getKind().equals("primitive-type")) {
                schemaBuilder.addStructureTypeBuilder(this.createPrimitiveTypeBuilder((StructureDefinitionData)definition));
            } else {
                schemaBuilder.addStructureTypeBuilders(this.createComplexTypeBuilders((StructureDefinitionData)definition));
            }
        });
        List<UnresolvableSerializationType> unresolvableSerializationTypesWithCause = schemaBuilder.getUnresolvableTypesWithFailingDependencyList();
        List<UnresolvableType> unresolvableTypes = unresolvableSerializationTypesWithCause.stream().map((? super T unresolvableSerializationType) -> {
            StructureDefinitionData structureDefinitionDTO = structureDefinitions.stream().filter(definition -> definition.getId().equals(unresolvableSerializationType.serializationType())).reduce(StructureDefinitionDataMerger::merge).orElse(null);
            return new UnresolvableType(structureDefinitionDTO, unresolvableSerializationType.missingDependencies());
        }).filter(unresolvableType -> unresolvableType.structureDefinitionData() != null).toList();
        List<String> unresolvableSerializationTypes = unresolvableTypes.stream().map(UnresolvableType::structureDefinitionData).map(StructureDefinitionData::getId).toList();
        List<String> successfullyResolvedTypes = structureDefinitions.stream().map(StructureDefinitionData::getId).filter(id -> !unresolvableSerializationTypes.contains(id)).distinct().toList();
        StructureSchema builtSchema = schemaBuilder.build();
        return new MappingOutcome(builtSchema, unresolvableTypes, successfullyResolvedTypes);
    }

    public String createAnonymousComplexTypeNameFromElementPath(String elementDefinitionPath) {
        String[] pathParts = elementDefinitionPath.split("\\.");
        return Arrays.stream(pathParts).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    private AbstractStructureTypeBuilder createPrimitiveTypeBuilder(StructureDefinitionData definitionDTO) {
        PrimitiveStructureTypeBuilder builder = new PrimitiveStructureTypeBuilder();
        builder.setSerializationType(definitionDTO.getId()).setDescription(definitionDTO.getDescription()).setIsAbstract(definitionDTO.getIsAbstract());
        if (definitionDTO.getBaseDefinitionReference() != null) {
            builder.setParent(definitionDTO.getBaseDefinitionReference().toString());
        }
        return builder;
    }

    private List<AbstractStructureTypeBuilder> createComplexTypeBuilders(StructureDefinitionData structureDefinitionData) {
        ComplexStructureTypeBuilder builder = new ComplexStructureTypeBuilder();
        builder.setSerializationType(structureDefinitionData.getId()).setDescription(structureDefinitionData.getDescription()).setIsAbstract(structureDefinitionData.getIsAbstract()).setKind(structureDefinitionData.getKind());
        if (structureDefinitionData.getBaseDefinitionReference() != null) {
            builder.setParent(structureDefinitionData.getBaseDefinitionReference().toString());
        }
        ArrayList<AbstractStructureTypeBuilder> resultBuilders = new ArrayList<AbstractStructureTypeBuilder>();
        resultBuilders.add(builder);
        StructureDefinitionData.Differential differential = structureDefinitionData.getDifferential();
        if (differential == null) {
            return resultBuilders;
        }
        differential.getElement().stream().filter(definition -> definition.getPath().split("\\.").length == 2).forEach(elementDefinition -> {
            FieldType referencedType;
            String fieldName = elementDefinition.getPath().split("\\.")[1].replace("[x]", "");
            List<FieldType> elementTypes = this.resolveElementTypes((ElementDefinition)elementDefinition);
            FieldDefinitionBuilder fieldBuilder = builder.addField(fieldName);
            fieldBuilder.setMin(elementDefinition.getMin()).setMax(elementDefinition.getMax()).setDescription(elementDefinition.getDefinition());
            if (elementDefinition.getContentReference() != null && (referencedType = this.createContentReferencedType(structureDefinitionData, elementDefinition.getContentReference())) != null) {
                fieldBuilder.addType(referencedType);
            }
            elementTypes.forEach(fieldBuilder::addType);
        });
        HashMap anonymousBuilders = new HashMap();
        differential.getElement().forEach(elementDefinition -> {
            FieldType referencedType;
            String[] splitPath = elementDefinition.getPath().split("\\.");
            if (splitPath.length < 3) {
                return;
            }
            String fieldName = splitPath[splitPath.length - 1].replace("[x]", "");
            CharSequence[] anonymousSplitPath = Arrays.copyOfRange(splitPath, 0, splitPath.length - 1);
            String anonymousPath = String.join((CharSequence)".", anonymousSplitPath);
            String anonymousObjectName = this.createAnonymousComplexTypeNameFromElementPath(anonymousPath);
            ComplexStructureTypeBuilder anonymousBuilder = anonymousBuilders.computeIfAbsent(anonymousObjectName, key -> this.createAnonymousBuilder(structureDefinitionData, anonymousObjectName));
            Optional<ElementDefinition> maybeParent = differential.getElement().stream().filter(definition -> definition.getPath().equals(anonymousPath)).findFirst();
            maybeParent.ifPresent(parent -> {
                List<ElementDefinitionType> type = parent.getType();
                if (type.isEmpty()) {
                    return;
                }
                anonymousBuilder.setParent(type.get(0).getCode());
            });
            List<FieldType> fieldTypes = this.resolveElementTypes((ElementDefinition)elementDefinition);
            FieldDefinitionBuilder fieldBuilder = anonymousBuilder.addField(fieldName);
            fieldBuilder.setMin(elementDefinition.getMin()).setMax(elementDefinition.getMax()).setDescription(elementDefinition.getDefinition());
            if (elementDefinition.getContentReference() != null && (referencedType = this.createContentReferencedType(structureDefinitionData, elementDefinition.getContentReference())) != null) {
                fieldBuilder.addType(referencedType);
            }
            fieldTypes.forEach(fieldBuilder::addType);
        });
        resultBuilders.addAll(anonymousBuilders.values());
        return resultBuilders;
    }

    private ComplexStructureTypeBuilder createAnonymousBuilder(StructureDefinitionData containedInDefinition, String anonymousObjectName) {
        return new ComplexStructureTypeBuilder().setSerializationType(anonymousObjectName).setKind("complex-type").setIsAbstract(false).setDescription("Type for anonymous field contained in " + containedInDefinition.getId()).setContainedInNonAnonymousType(containedInDefinition.getId());
    }

    private List<FieldType> resolveElementTypes(ElementDefinition elementDefinition) throws UnresolvableTypeException {
        ArrayList<FieldType> fixedTypes = new ArrayList<FieldType>();
        if (elementDefinition.getType() == null) {
            return fixedTypes;
        }
        elementDefinition.getType().forEach(type -> fixedTypes.addAll(this.createFieldType(elementDefinition, (ElementDefinitionType)type)));
        return fixedTypes;
    }

    private List<FieldType> createFieldType(ElementDefinition elementDefinition, ElementDefinitionType type) {
        if (this.isAnonymousElement(type.getCode())) {
            return List.of(FieldType.asAnonymousType(this.createAnonymousComplexTypeNameFromElementPath(elementDefinition.getPath()), type.getCode()));
        }
        if (this.isPrimitiveType(type.getCode()) && this.isUnionType(elementDefinition)) {
            return List.of(FieldType.asBoxedType(type.getCode()));
        }
        if (this.isReference(type.getCode())) {
            if (type.getTargetProfile().isEmpty()) {
                return List.of(FieldType.asReferenceType("Reference"));
            }
            return type.getTargetProfile().stream().map((? super T targetProfile) -> {
                String[] splitTargetProfile = targetProfile.split("/");
                String targetType = splitTargetProfile[splitTargetProfile.length - 1];
                return FieldType.asReferenceType(targetType);
            }).toList();
        }
        return List.of(FieldType.asPlainType(type.getCode()));
    }

    private boolean isAnonymousElement(String type) {
        return type.equals("BackboneElement") || type.equals("Element");
    }

    private boolean isReference(String type) {
        return type.equals("Reference");
    }

    private boolean isPrimitiveType(String type) {
        return Character.isLowerCase(type.charAt(0));
    }

    private boolean isUnionType(ElementDefinition elementDefinition) {
        return elementDefinition.getType().size() > 1;
    }

    @Nullable
    private FieldType createContentReferencedType(StructureDefinitionData containedInDefinition, String referencedTypePath) {
        String trimmedPath = referencedTypePath.replace("#", "");
        Optional<ElementDefinition> referencedElementDefinition = containedInDefinition.getDifferential().getElement().stream().filter(definition -> definition.getPath().equals(trimmedPath)).findFirst();
        if (referencedElementDefinition.isPresent()) {
            String anonymousTypeName = this.createAnonymousComplexTypeNameFromElementPath(trimmedPath);
            return FieldType.asContentReferenced(anonymousTypeName, referencedElementDefinition.get().getType().get(0).getCode());
        }
        return null;
    }
}

