/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.adHocLoaders;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FileLoader {
    private final Logger logger = LoggerFactory.getLogger(FileLoader.class);

    @Nullable
    public static FixtureFileInfo getFixtureFileInfo(Resource resource) {
        String fileURI;
        try {
            fileURI = resource.getURI().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] parts = fileURI.split("/");
        if (parts.length < 2) {
            return null;
        }
        String lastFolderName = parts[parts.length - 2];
        String filename = lastFolderName + File.separator + parts[parts.length - 1];
        return new FixtureFileInfo(filename, lastFolderName);
    }

    public List<Resource> loadFixtureFiles(Class<?> rootClass) {
        return this.loadFixtureFiles(rootClass, Set.of());
    }

    public List<Resource> loadFixtureFiles(Class<?> rootClass, String lastFolderName) {
        return this.loadFixtureFiles(rootClass, Set.of(), "json", lastFolderName);
    }

    public List<Resource> loadFixtureFiles(Class<?> rootClass, Set<String> processedFileNames) {
        return this.loadFixtureFiles(rootClass, processedFileNames, "json", null);
    }

    private List<Resource> loadFixtureFiles(Class<?> rootClass, Set<String> processedFileNames, String fileAppendix, @Nullable String lastFolderName) {
        Resource[] resources;
        String relativePath = this.getRelativePath(rootClass);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(rootClass.getClassLoader());
        if (fileAppendix.startsWith(".")) {
            fileAppendix = fileAppendix.substring(1);
        }
        String resourceLocation = String.format("classpath*:%s/**/*." + fileAppendix, relativePath);
        try {
            resources = resolver.getResources(resourceLocation);
        }
        catch (IOException e) {
            this.logger.warn("Error at " + resourceLocation);
            throw new RuntimeException(String.format("Unable to reaf fixture files.\nRelative Path: %s\nOriginal error: %s", relativePath, e));
        }
        ConcurrentHashMap.KeySetView currentlyLoadedFixtureFiles = ConcurrentHashMap.newKeySet();
        return Arrays.stream(resources).filter(resource -> {
            FixtureFileInfo fileInfo = FileLoader.getFixtureFileInfo(resource);
            if (fileInfo == null) {
                return false;
            }
            if (lastFolderName != null && !fileInfo.getLastFolderName().equals(lastFolderName)) {
                return false;
            }
            boolean wasAlreadyProcessed = processedFileNames.contains(fileInfo.getFullName());
            boolean wasCurrentlyLoaded = currentlyLoadedFixtureFiles.contains(fileInfo.getFullName());
            if (!wasAlreadyProcessed && !wasCurrentlyLoaded) {
                currentlyLoadedFixtureFiles.add(fileInfo.getFullName());
            }
            return !wasAlreadyProcessed && !wasCurrentlyLoaded;
        }).toList();
    }

    private String getRelativePath(Class<?> rootClass) {
        String relativeCanonicalPart = rootClass.getCanonicalName();
        String[] partsOfRelativePart = relativeCanonicalPart.split("\\.");
        return String.join((CharSequence)File.separator, Arrays.copyOfRange(relativeCanonicalPart.split("\\."), 0, partsOfRelativePart.length - 1));
    }

    public static class FixtureFileInfo {
        private final String fullName;
        private final String lastFolderName;

        public FixtureFileInfo(String fullName, String lastFolderName) {
            this.fullName = fullName;
            this.lastFolderName = lastFolderName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getLastFolderName() {
            return this.lastFolderName;
        }
    }
}

