/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchema.builder;

import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.builder.AbstractStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.FieldDefinitionBuilder;
import ai.stapi.schema.structureSchema.builder.StructureSchemaBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractComplexStructureTypeBuilder
extends AbstractStructureTypeBuilder {
    protected final Map<String, FieldDefinitionBuilder> fields = new HashMap<String, FieldDefinitionBuilder>();

    @Override
    public Map<String, FieldDefinitionBuilder> getAllFields(StructureSchemaBuilder structureSchemaBuilder) {
        AbstractStructureTypeBuilder parentBuilder;
        HashMap<String, FieldDefinitionBuilder> allFields = new HashMap<String, FieldDefinitionBuilder>(this.fields);
        if (this.getParent() != null && !this.getParent().isBlank() && (parentBuilder = structureSchemaBuilder.getStructureTypeBuilder(this.getParent())) != null) {
            Map<String, FieldDefinitionBuilder> parentFields = parentBuilder.getAllFields(structureSchemaBuilder);
            parentFields.forEach((fieldName, fieldDefinitionBuilder) -> {
                if (!allFields.containsKey(fieldName)) {
                    allFields.put((String)fieldName, (FieldDefinitionBuilder)fieldDefinitionBuilder);
                }
            });
        }
        return allFields;
    }

    public FieldDefinitionBuilder addField(String fieldName) {
        FieldDefinitionBuilder fieldBuilder = new FieldDefinitionBuilder().setName(fieldName).setParentDefinitionType(this.serializationType);
        this.fields.put(fieldName, fieldBuilder);
        return fieldBuilder;
    }

    @Override
    public List<FieldType> getAllFieldTypes() {
        return this.fields.values().stream().map(FieldDefinitionBuilder::getTypes).flatMap(Collection::stream).distinct().toList();
    }
}

