/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structuredefinition;

import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import java.util.ArrayList;
import java.util.List;

public class StructureDefinitionDataMerger {
    private StructureDefinitionDataMerger() {
    }

    public static StructureDefinitionData merge(StructureDefinitionData slave, StructureDefinitionData master) {
        if (!slave.getId().equals(master.getId())) {
            throw new RuntimeException("Cannot merge two different structure definitions.\nSlave id: " + slave.getId() + "Master id: " + master.getId());
        }
        List<ElementDefinition> masterDifferential = master.getDifferential().getElement();
        List<ElementDefinition> slaveDifferential = slave.getDifferential().getElement();
        ArrayList<ElementDefinition> mergedDifferential = new ArrayList<ElementDefinition>(masterDifferential);
        slaveDifferential.stream().filter(slaveElement -> !StructureDefinitionDataMerger.isContainedInMaster(masterDifferential, slaveElement)).forEach(mergedDifferential::add);
        return new StructureDefinitionData(master.getId() != null ? master.getId() : slave.getId(), master.getUrl() != null ? master.getUrl() : slave.getUrl(), master.getStatus() != null ? master.getStatus() : slave.getStatus(), master.getDescription() != null ? master.getDescription() : slave.getDescription(), master.getKind() != null ? master.getKind() : slave.getKind(), master.getIsAbstract() != null ? master.getIsAbstract() : slave.getIsAbstract(), master.getType() != null ? master.getType() : slave.getType(), master.getBaseDefinition() != null ? master.getBaseDefinition() : slave.getBaseDefinition(), master.getBaseDefinitionRef() != null ? master.getBaseDefinitionRef() : slave.getBaseDefinitionRef(), mergedDifferential);
    }

    private static boolean isContainedInMaster(List<ElementDefinition> masterDifferential, ElementDefinition slaveElement) {
        return masterDifferential.stream().anyMatch(masterElement -> masterElement.getPath().equals(slaveElement.getPath()));
    }
}

