/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structuredefinition;

import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.schema.structuredefinition.ElementDefinitionType;
import ai.stapi.schema.structuredefinition.RawStructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureDefinitionNormalizer {
    private StructureDefinitionNormalizer() {
    }

    public static StructureDefinitionData normalize(RawStructureDefinitionData imported) {
        ArrayList<ElementDefinition> fixedElements = StructureDefinitionNormalizer.getFixedElements(imported);
        String replaced = null;
        String baseDefinition = imported.getBaseDefinition();
        if (baseDefinition != null) {
            replaced = baseDefinition.replace("http://hl7.org/fhir/StructureDefinition/", "");
        }
        return new StructureDefinitionData(imported.getId(), imported.getUrl(), imported.getStatus(), imported.getDescription(), imported.getKind(), imported.getIsAbstract(), imported.getType(), baseDefinition, (UniqueIdentifier)(baseDefinition == null ? null : new StructureDefinitionId(replaced)), fixedElements == null ? null : new StructureDefinitionData.Differential(fixedElements));
    }

    public static Map<String, Object> normalize(Map<String, Object> structureDefinition) {
        ArrayList<Map<String, Object>> fixedElements = StructureDefinitionNormalizer.getFixedElements(structureDefinition);
        String replaced = null;
        String baseDefinition = (String)structureDefinition.get("baseDefinition");
        if (baseDefinition != null) {
            replaced = baseDefinition.replace("http://hl7.org/fhir/StructureDefinition/", "");
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>(structureDefinition);
        if (baseDefinition != null) {
            newMap.put("baseDefinitionRef", (Object)new StructureDefinitionId(replaced));
        }
        if (fixedElements != null) {
            newMap.put("differential", new HashMap<String, ArrayList<Map<String, Object>>>(Map.of("element", fixedElements)));
        }
        newMap.remove("snapshot");
        return newMap;
    }

    @Nullable
    private static ArrayList<ElementDefinition> getFixedElements(RawStructureDefinitionData imported) {
        if (imported.getDifferential() == null) {
            return null;
        }
        return imported.getDifferential().getElement().stream().map(element -> {
            ArrayList fixedTypes = new ArrayList();
            if (element.getType() != null) {
                fixedTypes = element.getType().stream().map(type -> {
                    if (type.getCode().contains("http://hl7.org/fhirpath/System.")) {
                        String fixedCode = StringUtils.uncapitalize((String)type.getCode().replace("http://hl7.org/fhirpath/System.", ""));
                        return new ElementDefinitionType(type.getCode(), new UniqueIdentifier(fixedCode), type.getTargetProfile(), StructureDefinitionNormalizer.fixTargetProfile(type.getTargetProfile()));
                    }
                    return new ElementDefinitionType(type.getCode(), new UniqueIdentifier(type.getCode()), type.getTargetProfile(), StructureDefinitionNormalizer.fixTargetProfile(type.getTargetProfile()));
                }).collect(Collectors.toCollection(ArrayList::new));
            }
            return new ElementDefinition(element.getPath(), fixedTypes, element.getMin(), element.getMax(), element.getShortDescription(), element.getDefinition(), element.getComment(), element.getContentReference());
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nullable
    private static ArrayList<Map<String, Object>> getFixedElements(Map<String, Object> structureDefinition) {
        Map differential = (Map)structureDefinition.get("differential");
        if (differential == null) {
            return null;
        }
        List elements = (List)differential.get("element");
        return elements.stream().map(element -> {
            ArrayList fixedTypes = new ArrayList();
            List types = (List)element.get("type");
            if (types != null) {
                fixedTypes = types.stream().map(type -> {
                    String code = (String)type.get("code");
                    HashMap<String, Object> fixedType = new HashMap<String, Object>((Map<String, Object>)type);
                    if (code.contains("http://hl7.org/fhirpath/System.")) {
                        String fixedCode = StringUtils.uncapitalize((String)code.replace("http://hl7.org/fhirpath/System.", ""));
                        fixedType.put("codeRef", new UniqueIdentifier(fixedCode));
                    } else {
                        fixedType.put("codeRef", new UniqueIdentifier(code));
                    }
                    List targetProfile = (List)type.get("targetProfile");
                    if (targetProfile != null) {
                        fixedType.put("targetProfileRef", StructureDefinitionNormalizer.fixTargetProfile(targetProfile));
                    }
                    return fixedType;
                }).collect(Collectors.toCollection(ArrayList::new));
            }
            HashMap<String, ArrayList> fixedElement = new HashMap<String, ArrayList>((Map<String, ArrayList>)element);
            fixedElement.put("type", fixedTypes);
            return fixedElement;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    private static List<UniqueIdentifier> fixTargetProfile(List<String> targetProfile) {
        return targetProfile.stream().map(profile -> profile.replace("http://hl7.org/fhir/StructureDefinition/", "")).map(UniqueIdentifier::new).toList();
    }
}

