/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchema.builder;

import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.BoxedPrimitiveStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.builder.AbstractComplexStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.AbstractStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.StructureSchemaBuilder;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class BoxedStructureTypeBuilder
extends AbstractComplexStructureTypeBuilder {
    protected String originalSerializationType = "";
    private String containedInNonAnonymousType;

    public BoxedStructureTypeBuilder() {
        this.kind = "primitive-type";
    }

    @Override
    public AbstractStructureType build(StructureSchemaBuilder structureSchemaBuilder) {
        HashMap<String, FieldDefinition> builtFields = new HashMap<String, FieldDefinition>();
        this.getAllFields(structureSchemaBuilder).forEach((key, value) -> builtFields.put((String)key, value.build()));
        return new BoxedPrimitiveStructureType(this.boxifySerializationType(this.serializationType), this.description, builtFields, this.isAbstract, this.parent);
    }

    @Override
    public String getContainedInNonAnonymousType() {
        return this.containedInNonAnonymousType;
    }

    @Override
    public BoxedStructureTypeBuilder setContainedInNonAnonymousType(String containedInNonAnonymousType) {
        this.containedInNonAnonymousType = containedInNonAnonymousType;
        return this;
    }

    @Override
    public AbstractStructureTypeBuilder specificMergeOverwrite(AbstractStructureTypeBuilder other) {
        return other;
    }

    @Override
    public String getOriginalSerializationType() {
        return this.originalSerializationType;
    }

    @Override
    public BoxedStructureTypeBuilder copyToBuilder(AbstractStructureType abstractStructureType) {
        if (!(abstractStructureType instanceof BoxedPrimitiveStructureType)) {
            throw new RuntimeException("Trying to copy AbstractStructureType with wrong builder.");
        }
        BoxedPrimitiveStructureType boxedPrimitiveStructureType = (BoxedPrimitiveStructureType)abstractStructureType;
        BoxedStructureTypeBuilder boxed = new BoxedStructureTypeBuilder().setSerializationType(boxedPrimitiveStructureType.getOriginalDefinitionType()).setIsAbstract(boxedPrimitiveStructureType.isAbstract()).setDescription(boxedPrimitiveStructureType.getDescription()).setParent(boxedPrimitiveStructureType.getParent());
        boxedPrimitiveStructureType.getAllFields().forEach((key, value) -> boxed.addField((String)key).setDescription(value.getDescription()).setMax(value.getMax()).setMin(value.getMin()).setTypes(value.getTypes()).setName(value.getName()).setParentDefinitionType(value.getParentDefinitionType()));
        return boxed;
    }

    public BoxedStructureTypeBuilder setSerializationType(String serializationType) {
        this.serializationType = this.boxifySerializationType(serializationType);
        this.originalSerializationType = serializationType;
        this.addField("value").setMin(0).setMax("1").setDescription("Primitive value for " + this.boxifySerializationType(serializationType)).addType(FieldType.asPlainType(this.originalSerializationType));
        return this;
    }

    @Override
    public BoxedStructureTypeBuilder setParent(String parent) {
        this.parent = parent != null && !parent.isBlank() ? (parent.equals("Element") ? parent : this.boxifySerializationType(parent)) : "Element";
        return this;
    }

    public BoxedStructureTypeBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public BoxedStructureTypeBuilder setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    private String boxifySerializationType(String serializationType) {
        if (serializationType.startsWith("Boxed")) {
            return serializationType;
        }
        return "Boxed" + StringUtils.capitalize((String)serializationType);
    }
}

