/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchema.builder;

import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.ResourceStructureType;
import ai.stapi.schema.structureSchema.builder.AbstractComplexStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.AbstractStructureTypeBuilder;
import ai.stapi.schema.structureSchema.builder.StructureSchemaBuilder;
import java.util.HashMap;

public class ComplexStructureTypeBuilder
extends AbstractComplexStructureTypeBuilder {
    private String containedInNonAnonymousType;

    public ComplexStructureTypeBuilder setSerializationType(String serializationType) {
        this.serializationType = serializationType;
        return this;
    }

    @Override
    public ComplexStructureTypeBuilder copyToBuilder(AbstractStructureType abstractStructureType) {
        if (!(abstractStructureType instanceof ComplexStructureType)) {
            throw new RuntimeException("Trying to copy AbstractStructureType with wrong builder.");
        }
        ComplexStructureType complexStructureType = (ComplexStructureType)abstractStructureType;
        ComplexStructureTypeBuilder complex = new ComplexStructureTypeBuilder().setSerializationType(complexStructureType.getDefinitionType()).setIsAbstract(complexStructureType.isAbstract()).setKind(complexStructureType.getKind()).setDescription(complexStructureType.getDescription()).setParent(complexStructureType.getParent());
        complexStructureType.getAllFields().forEach((key, value) -> complex.addField((String)key).setDescription(value.getDescription()).setMax(value.getMax()).setMin(value.getMin()).setTypes(value.getTypes()).setName(value.getName()).setParentDefinitionType(value.getParentDefinitionType()));
        return complex;
    }

    @Override
    public AbstractStructureType build(StructureSchemaBuilder structureSchemaBuilder) {
        HashMap<String, FieldDefinition> builtFields = new HashMap<String, FieldDefinition>();
        this.getAllFields(structureSchemaBuilder).forEach((key, value) -> builtFields.put((String)key, value.build()));
        switch (this.kind) {
            case "resource": {
                return new ResourceStructureType(this.serializationType, builtFields, this.description, this.parent, this.isAbstract);
            }
            case "complex-type": {
                return new ComplexStructureType(this.serializationType, builtFields, this.description, this.parent, this.isAbstract);
            }
        }
        throw new RuntimeException("FHIR kind '" + this.kind + "' is not recognizable.");
    }

    @Override
    public ComplexStructureTypeBuilder setParent(String parent) {
        this.parent = parent;
        return this;
    }

    public ComplexStructureTypeBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ComplexStructureTypeBuilder setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public ComplexStructureTypeBuilder setKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public String getContainedInNonAnonymousType() {
        return this.containedInNonAnonymousType;
    }

    @Override
    public ComplexStructureTypeBuilder setContainedInNonAnonymousType(String containedInNonAnonymousType) {
        this.containedInNonAnonymousType = containedInNonAnonymousType;
        return this;
    }

    @Override
    protected AbstractStructureTypeBuilder specificMergeOverwrite(AbstractStructureTypeBuilder other) {
        if (!(other instanceof ComplexStructureTypeBuilder)) {
            throw new RuntimeException("Merging incompatible builders!");
        }
        ComplexStructureTypeBuilder otherComplex = (ComplexStructureTypeBuilder)other;
        if (otherComplex.getContainedInNonAnonymousType() != null) {
            this.containedInNonAnonymousType = otherComplex.getContainedInNonAnonymousType();
        }
        this.fields.putAll(otherComplex.fields);
        return this;
    }
}

