/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.scopeProvider;

import ai.stapi.schema.scopeProvider.ScopeOptions;
import ai.stapi.schema.scopeProvider.ScopeProvider;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeCacher {
    private final ScopeProvider scopeProvider;
    private final Map<ScopeOptions, Map<Class<?>, Object>> cache;

    public ScopeCacher(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
        this.cache = new ConcurrentHashMap();
    }

    public void cache(Class<?> consumerClass, Object cachedData) {
        ScopeOptions currentScope = this.scopeProvider.provide();
        Map<Class<?>, Object> scoped = this.getCurrentScopeCache(currentScope);
        scoped.put(consumerClass, cachedData);
    }

    public boolean hasCached(Class<?> consumerClass) {
        ScopeOptions currentScope = this.scopeProvider.provide();
        Map<Class<?>, Object> scoped = this.getCurrentScopeCache(currentScope);
        return scoped.containsKey(consumerClass);
    }

    public <T> T getCachedOrCompute(Class<?> consumerClass, ComputeFunction<T> computeFunction) {
        ScopeOptions currentScope = this.scopeProvider.provide();
        Map<Class<?>, Object> scoped = this.getCurrentScopeCache(currentScope);
        Object current = scoped.get(consumerClass);
        if (current != null) {
            return (T)current;
        }
        T computed = computeFunction.compute(currentScope);
        scoped.put(consumerClass, computed);
        return computed;
    }

    @Nullable
    public <T> T getCached(Class<?> consumerClass) {
        ScopeOptions currentScope = this.scopeProvider.provide();
        Map<Class<?>, Object> scoped = this.getCurrentScopeCache(currentScope);
        return (T)scoped.get(consumerClass);
    }

    public <T> T recompute(Class<?> consumerClass, T initialValue, RecomputeWithInitialValueFunction<T> computeFunction) {
        ScopeOptions currentScope;
        Map<Class<?>, Object> scoped = this.getCurrentScopeCache(currentScope = this.scopeProvider.provide());
        Object previous = scoped.get(consumerClass);
        T newCache = computeFunction.compute(currentScope, previous == null ? initialValue : previous);
        scoped.put(consumerClass, newCache);
        return newCache;
    }

    public <T> T recompute(Class<?> consumerClass, RecomputeFunction<T> computeFunction) {
        ScopeOptions currentScope;
        Map<Class<?>, Object> scoped = this.getCurrentScopeCache(currentScope = this.scopeProvider.provide());
        Object previous = scoped.get(consumerClass);
        T newCache = computeFunction.compute(currentScope, previous == null ? Optional.empty() : Optional.of(previous));
        scoped.put(consumerClass, newCache);
        return newCache;
    }

    @NotNull
    private Map<Class<?>, Object> getCurrentScopeCache(ScopeOptions currentScope) {
        return this.cache.computeIfAbsent(currentScope, key -> new ConcurrentHashMap());
    }

    public static interface ComputeFunction<T> {
        public T compute(ScopeOptions var1);
    }

    public static interface RecomputeWithInitialValueFunction<T> {
        public T compute(ScopeOptions var1, T var2);
    }

    public static interface RecomputeFunction<T> {
        public T compute(ScopeOptions var1, Optional<T> var2);
    }
}

