/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.scopeProvider;

import java.util.HashSet;
import java.util.List;

public class ScopeOptions {
    public static final String DOMAIN_TAG = "domain";
    public static final String TEST_TAG = "test";
    private List<String> scopes;
    private List<String> tags;

    public ScopeOptions() {
        this.scopes = List.of();
        this.tags = List.of();
    }

    public ScopeOptions(List<String> scopes, List<String> tags) {
        this.scopes = scopes;
        this.tags = tags;
    }

    public ScopeOptions(String scope, String tag) {
        this.scopes = List.of(scope);
        this.tags = List.of(tag);
    }

    public ScopeOptions with(ScopeOptions scopeOptions) {
        HashSet<String> newScopes = new HashSet<String>(this.scopes);
        newScopes.addAll(scopeOptions.getScopes());
        HashSet<String> newTags = new HashSet<String>(this.tags);
        newTags.addAll(scopeOptions.getTags());
        return new ScopeOptions(newScopes.stream().toList(), newTags.stream().toList());
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getStringHash() {
        return this.scopes.toString() + this.tags.toString();
    }

    public String toReadableString() {
        return "ScopeOptions{scopes=" + this.scopes + ", tags=" + this.tags + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeOptions that = (ScopeOptions)o;
        if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) {
            return false;
        }
        return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
    }

    public int hashCode() {
        int result = this.scopes != null ? this.scopes.hashCode() : 0;
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        return result;
    }
}

