/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchema.builder;

import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.FieldTypeGroup;
import ai.stapi.schema.structureSchema.builder.FieldDefinitionBuilder;
import ai.stapi.schema.structureSchema.builder.StructureSchemaBuilder;
import ai.stapi.schema.structureSchemaMapper.UnresolvableSerializationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStructureTypeBuilder {
    protected boolean isAbstract = false;
    protected String description = "";
    protected String serializationType = "";
    protected String parent = "";
    protected String kind = "";

    public abstract AbstractStructureType build(StructureSchemaBuilder var1);

    public abstract AbstractStructureTypeBuilder copyToBuilder(AbstractStructureType var1);

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isPrimitiveType() {
        return this.kind.equals("primitive-type");
    }

    public String getDescription() {
        return this.description;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public String getOriginalSerializationType() {
        return this.serializationType;
    }

    public String getParent() {
        return this.parent;
    }

    public AbstractStructureTypeBuilder setParent(String parent) {
        this.parent = parent;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public List<UnresolvableSerializationType> getDirectlyUnresolvableTypesWithFailingDependencyList(StructureSchemaBuilder structureSchemaBuilder) {
        ArrayList<String> missingDependencies = new ArrayList<String>(this.findMissingTypesForFields(structureSchemaBuilder));
        if (missingDependencies.size() == 0) {
            return List.of();
        }
        return List.of(new UnresolvableSerializationType(this.getSerializationType(), this.getOriginalSerializationType(), missingDependencies));
    }

    @NotNull
    protected ArrayList<String> findMissingDependenciesForParent(StructureSchemaBuilder structureSchemaBuilder) {
        ArrayList<String> missingFieldsOnParent = new ArrayList<String>();
        if (this.getParent() != null && !this.getParent().isBlank()) {
            AbstractStructureTypeBuilder parentBuilder = structureSchemaBuilder.getStructureTypeBuilder(this.getParent());
            if (parentBuilder == null) {
                String originalParentName = structureSchemaBuilder.getStructureTypeBuilder(this.getSerializationType()).getParent();
                if (originalParentName == null || originalParentName.isBlank()) {
                    originalParentName = this.getParent();
                }
                missingFieldsOnParent.add(originalParentName);
            } else {
                List<String> missingOnParents = parentBuilder.findMissingTypesForFields(structureSchemaBuilder);
                missingFieldsOnParent.addAll(missingOnParents);
            }
        }
        return missingFieldsOnParent;
    }

    public List<String> findMissingTypesForFields(StructureSchemaBuilder structureSchemaBuilder) {
        ArrayList<String> allMissingFields = new ArrayList<String>();
        List<FieldType> allFieldTypes = this.getAllFieldTypes();
        List<String> missingFieldsOnCurrent = allFieldTypes.stream().filter(fieldType -> !structureSchemaBuilder.containsType(fieldType.getType())).map(fieldType1 -> fieldType1.getTypeGroup().equals((Object)FieldTypeGroup.BOXED) ? fieldType1.getOriginalType() : fieldType1.getType()).toList();
        List<FieldType> allAnonymousTypesOnFields = this.getAllFields(structureSchemaBuilder).values().stream().map(FieldDefinitionBuilder::getTypes).flatMap(Collection::stream).distinct().filter(type -> structureSchemaBuilder.getStructureTypeBuilder(type.getType()) != null ? structureSchemaBuilder.getStructureTypeBuilder(type.getType()).getContainedInNonAnonymousType() != null : false).toList();
        List missingFieldsOnAllAnonymousTypesOnFields = allAnonymousTypesOnFields.stream().filter(fieldType -> !fieldType.isContentReferenced()).map(fieldType -> structureSchemaBuilder.getMissingFieldsOnType(fieldType.getType())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        ArrayList<String> missingFieldsOnParent = this.findMissingDependenciesForParent(structureSchemaBuilder);
        allMissingFields.addAll(missingFieldsOnCurrent);
        allMissingFields.addAll(missingFieldsOnAllAnonymousTypesOnFields);
        allMissingFields.addAll(missingFieldsOnParent);
        return allMissingFields;
    }

    public abstract List<FieldType> getAllFieldTypes();

    public abstract String getContainedInNonAnonymousType();

    public abstract AbstractStructureTypeBuilder setContainedInNonAnonymousType(String var1);

    public AbstractStructureTypeBuilder mergeOverwrite(AbstractStructureTypeBuilder other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new RuntimeException(String.format("Merging incompatible builders!\nThis builder: %s\nOther builder: %s\n", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
        }
        this.specificMergeOverwrite(other);
        if (other.getDescription() != null && !other.getDescription().isBlank()) {
            this.description = other.getDescription();
        }
        if (other.getParent() != null && !other.getParent().isBlank()) {
            this.parent = other.getParent();
        }
        if (other.getKind() != null && !other.getParent().isBlank()) {
            this.kind = other.getKind();
        }
        if (other.getSerializationType() != null && !other.getSerializationType().isBlank()) {
            this.serializationType = other.getSerializationType();
        }
        this.isAbstract = other.isAbstract();
        return this;
    }

    protected abstract AbstractStructureTypeBuilder specificMergeOverwrite(AbstractStructureTypeBuilder var1);

    public abstract Map<String, FieldDefinitionBuilder> getAllFields(StructureSchemaBuilder var1);
}

