/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structureSchema;

import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.exception.FieldDoesNotExist;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ComplexStructureType
extends AbstractStructureType {
    public static final String SERIALIZATION_TYPE = "ComplexStructureType";
    public static final String KIND = "complex-type";
    private Map<String, FieldDefinition> fields;

    protected ComplexStructureType() {
    }

    protected ComplexStructureType(String serializationType, String kind, String definitionType, Map<String, FieldDefinition> fields, String description, String parent, boolean isAbstract) {
        super(serializationType, kind, definitionType, description, isAbstract, parent);
        this.fields = new HashMap<String, FieldDefinition>(fields);
    }

    public ComplexStructureType(String definitionType, Map<String, FieldDefinition> fields, String description, String parent, boolean isAbstract) {
        super(SERIALIZATION_TYPE, KIND, definitionType, description, isAbstract, parent);
        this.fields = new HashMap<String, FieldDefinition>(fields);
    }

    public Map<String, FieldDefinition> getAllFields() {
        return this.fields;
    }

    public Map<String, FieldDefinition> getOwnFields() {
        return this.fields.entrySet().stream().filter(entry -> ((FieldDefinition)((Object)((Object)entry.getValue()))).getParentDefinitionType().equals(this.definitionType)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public FieldDefinition getField(String fieldName) {
        if (!this.fields.containsKey(fieldName)) {
            throw new FieldDoesNotExist(String.format("Field '%s' does not exist on '%s'.", fieldName, this.getDefinitionType()));
        }
        return this.fields.get(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public ComplexStructureType copyWithNewFields(Map<String, FieldDefinition> newFields) {
        return new ComplexStructureType(this.definitionType, newFields, this.description, this.parent, this.isAbstract);
    }
}

