/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.schema.structuredefinition.loader;

import ai.stapi.schema.adHocLoaders.GenericAdHocModelDefinitionsLoader;
import ai.stapi.schema.scopeProvider.ScopeCacher;
import ai.stapi.schema.scopeProvider.ScopeOptions;
import ai.stapi.schema.structuredefinition.RawStructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionNormalizer;
import ai.stapi.schema.structuredefinition.loader.StructureDefinitionLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AdHocStructureDefinitionLoader
implements StructureDefinitionLoader {
    private final GenericAdHocModelDefinitionsLoader genericAdHocModelDefinitionsLoader;
    private final ScopeCacher scopeCacher;

    public AdHocStructureDefinitionLoader(GenericAdHocModelDefinitionsLoader genericAdHocModelDefinitionsLoader, ScopeCacher scopeCacher) {
        this.genericAdHocModelDefinitionsLoader = genericAdHocModelDefinitionsLoader;
        this.scopeCacher = scopeCacher;
    }

    @Override
    public List<StructureDefinitionData> load() {
        return this.scopeCacher.getCachedOrCompute(AdHocStructureDefinitionLoader.class, this::load);
    }

    private List<StructureDefinitionData> load(ScopeOptions scopeOptions) {
        List<StructureDefinitionData> rawStructure = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "RawStructureDefinitionData", RawStructureDefinitionData.class).stream().map(StructureDefinitionNormalizer::normalize).toList();
        List<StructureDefinitionData> structureDefinition = this.genericAdHocModelDefinitionsLoader.load(scopeOptions, "StructureDefinition", StructureDefinitionData.class);
        ArrayList<StructureDefinitionData> finalStructures = new ArrayList<StructureDefinitionData>(rawStructure);
        finalStructures.addAll(structureDefinition);
        return this.sortDefinitionsByKind(finalStructures);
    }

    @NotNull
    private ArrayList<StructureDefinitionData> sortDefinitionsByKind(List<StructureDefinitionData> definitionDTOs) {
        ArrayList<StructureDefinitionData> sortedList = new ArrayList<StructureDefinitionData>();
        sortedList.addAll(definitionDTOs.stream().filter(dto -> dto.getKind().equals("primitive-type")).toList());
        sortedList.addAll(definitionDTOs.stream().filter(dto -> dto.getKind().equals("complex-type")).toList());
        sortedList.addAll(definitionDTOs.stream().filter(dto -> dto.getKind().equals("resource")).toList());
        return sortedList;
    }
}

