/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extractor;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.StorageArea;
import ai.starlake.extractor.ExtractScriptGenConfig;
import ai.starlake.extractor.ExtractScriptGenConfig$;
import ai.starlake.extractor.TemplateParams;
import ai.starlake.extractor.TemplateParams$;
import ai.starlake.extractor.config.Settings$;
import ai.starlake.job.transform.AutoTaskJob;
import ai.starlake.schema.handlers.HdfsStorageHandler;
import ai.starlake.schema.handlers.LaunchHandler;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.SimpleLauncher;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Engine$BQ$;
import ai.starlake.schema.model.Engine$SPARK$;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.Views;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.Formatter$;
import ai.starlake.workflow.IngestionWorkflow;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.TemplateEngine$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\b\u0011\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005:\u0001\t\u0005\t\u0015a\u0003;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001dI\u0005A1A\u0005\u0002)Ca!\u0016\u0001!\u0002\u0013Y\u0005\"\u0002,\u0001\t\u00039\u0006\"B:\u0001\t\u0003!\bbBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\t\u0005\u0001C\u0001\u0003+Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002v\u0001!I!a\u001e\u0003\u0013M\u001b'/\u001b9u\u000f\u0016t'BA\t\u0013\u0003%)\u0007\u0010\u001e:bGR|'O\u0003\u0002\u0014)\u0005A1\u000f^1sY\u0006\\WMC\u0001\u0016\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nAb]2bY\u0006dwnZ4j]\u001eT!a\t\u0013\u0002\u0011QL\b/Z:bM\u0016T\u0011!J\u0001\u0004G>l\u0017BA\u0014!\u00055\u0019FO]5di2{wmZ5oO\u0006q1\u000f^8sC\u001e,\u0007*\u00198eY\u0016\u0014\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003!A\u0017M\u001c3mKJ\u001c(B\u0001\u0018\u0013\u0003\u0019\u00198\r[3nC&\u0011\u0001g\u000b\u0002\u000f'R|'/Y4f\u0011\u0006tG\r\\3s\u00035\u00198\r[3nC\"\u000bg\u000e\u001a7feB\u0011!fM\u0005\u0003i-\u0012QbU2iK6\f\u0007*\u00198eY\u0016\u0014\u0018!\u00047bk:\u001c\u0007\u000eS1oI2,'\u000f\u0005\u0002+o%\u0011\u0001h\u000b\u0002\u000e\u0019\u0006,hn\u00195IC:$G.\u001a:\u0002\u0011M,G\u000f^5oON\u0004\"a\u000f \u000e\u0003qR!!\u0010\n\u0002\r\r|gNZ5h\u0013\tyDH\u0001\u0005TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q!!IR$I)\t\u0019U\t\u0005\u0002E\u00015\t\u0001\u0003C\u0003:\u000b\u0001\u000f!\bC\u0003)\u000b\u0001\u0007\u0011\u0006C\u00032\u000b\u0001\u0007!\u0007C\u00036\u000b\u0001\u0007a'\u0001\u0004f]\u001eLg.Z\u000b\u0002\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\bg\u000e\fG.\u0019;f\u0015\t\u0001\u0016+\u0001\u0006gkN,7o\\;sG\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+N\u00059!V-\u001c9mCR,WI\\4j]\u0016\fq!\u001a8hS:,\u0007%\u0001\u0006uK6\u0004H.\u0019;ju\u0016$2\u0001\u00177o!\rI\u0016\r\u001a\b\u00035~s!a\u00170\u000e\u0003qS!!\u0018\f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012B\u00011\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\t1K7\u000f\u001e\u0006\u0003Aj\u0001\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u000b\u0019LG.Z:\u000b\u0003%\faAY3ui\u0016\u0014\u0018BA6g\u0005\u00111\u0015\u000e\\3\t\u000b5D\u0001\u0019\u00013\u0002\u0011Q,W\u000e\u001d7bi\u0016DQa\u001c\u0005A\u0002A\fa\u0002^3na2\fG/\u001a)be\u0006l7\u000f\u0005\u0002Ec&\u0011!\u000f\u0005\u0002\u000f)\u0016l\u0007\u000f\\1uKB\u000b'/Y7t\u000399WM\\3sCR,Gi\\7bS:$\"\u0002W;~\u007f\u0006\r\u0011QDA\u0011\u0011\u00151\u0018\u00021\u0001x\u0003\u0019!w.\\1j]B\u0011\u0001p_\u0007\u0002s*\u0011!0L\u0001\u0006[>$W\r\\\u0005\u0003yf\u0014a\u0001R8nC&t\u0007\"\u0002@\n\u0001\u0004!\u0017AE:de&\u0004H\u000fV3na2\fG/\u001a$jY\u0016Da!!\u0001\n\u0001\u0004!\u0017!E:de&\u0004Ho](viB,H\u000fU1uQ\"9\u0011QA\u0005A\u0002\u0005\u001d\u0011aE:de&\u0004HoT;uaV$\b+\u0019;uKJt\u0007#B\r\u0002\n\u00055\u0011bAA\u00065\t1q\n\u001d;j_:\u0004B!a\u0004\u0002\u00189!\u0011\u0011CA\n!\tY&$C\u0002\u0002\u0016i\ta\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b5!9\u0011qD\u0005A\u0002\u0005\u001d\u0011A\u00053fM\u0006,H\u000e\u001e#fYR\f7i\u001c7v[:Dq!a\t\n\u0001\u0004\t)#\u0001\u0007eK2$\u0018mQ8mk6t7\u000f\u0005\u0005\u0002\u0010\u0005\u001d\u0012QBA\u0007\u0013\u0011\tI#a\u0007\u0003\u00075\u000b\u0007/A\u0006hK:,'/\u0019;f\u0015>\u0014G#\u00033\u00020\u0005e\u00121HA \u0011\u001d\t\tD\u0003a\u0001\u0003g\t1A[8c!\rA\u0018QG\u0005\u0004\u0003oI(aC!vi>TuN\u0019#fg\u000eDQA \u0006A\u0002\u0011Da!!\u0010\u000b\u0001\u0004!\u0017aE:de&\u0004Ho](viB,HOR8mI\u0016\u0014\bbBA\u0003\u0015\u0001\u0007\u0011qA\u0001\u0004eVtG\u0003BA#\u0003\u0017\u00022!GA$\u0013\r\tIE\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\tie\u0003a\u0001\u0003\u001f\nA!\u0019:hgB)\u0011$!\u0015\u0002\u000e%\u0019\u00111\u000b\u000e\u0003\u000b\u0005\u0013(/Y=\u0015\t\u0005]\u00131\f\u000b\u0005\u0003\u000b\nI\u0006C\u0003:\u0019\u0001\u000f!\b\u0003\u0004>\u0019\u0001\u0007\u0011Q\f\t\u0004\t\u0006}\u0013bAA1!\t1R\t\u001f;sC\u000e$8k\u0019:jaR<UM\\\"p]\u001aLw-\u0001\u0007sk:|e\u000eR8nC&t7\u000f\u0006\u0005\u0002F\u0005\u001d\u0014\u0011NA6\u0011\u0019iT\u00021\u0001\u0002^!)\u0011'\u0004a\u0001e!9\u0011QN\u0007A\u0002\u0005=\u0014a\u00033p[\u0006LgNT1nKN\u0004R!WA9\u0003\u001bI1!a\u001dd\u0005\r\u0019V-]\u0001\neVtwJ\u001c&pEN$\u0002\"!\u0012\u0002z\u0005m\u0014Q\u0010\u0005\u0007{9\u0001\r!!\u0018\t\u000bEr\u0001\u0019\u0001\u001a\t\u000f\u0005}d\u00021\u0001\u0002p\u0005A!n\u001c2OC6,7\u000f")
public class ScriptGen
implements StrictLogging {
    private final SchemaHandler schemaHandler;
    private final Settings settings;
    private final TemplateEngine engine;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public TemplateEngine engine() {
        return this.engine;
    }

    public List<File> templatize(File template, TemplateParams templateParams) {
        Iterator iterator;
        if (template.isDirectory(template.isDirectory$default$1())) {
            iterator = template.list().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.pathAsString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$templatize$2(name))).map((Function1 & Serializable & scala.Serializable)name -> new Tuple2(name, (Object)ScriptGen.formatFilename$1(name, templateParams)));
        } else {
            String outputFilename = (String)templateParams.scriptOutputFile().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.pathAsString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ScriptGen.formatFilename$1(template.pathAsString(), templateParams));
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)template.pathAsString(), (Object)outputFilename)}));
        }
        Iterator filesPath = iterator;
        return filesPath.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            File outputFile;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                String inputPath = (String)tuple2._1();
                String outputPath = (String)tuple2._2();
                String scriptPayload = this.engine().layout(inputPath, templateParams.paramMap(), this.engine().layout$default$3());
                outputFile = File$.MODULE$.apply(outputPath, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                boolean x$1 = outputFile.createFileIfNotExists$default$1();
                Seq x$2 = outputFile.createFileIfNotExists$default$2(x$1);
                Seq x$3 = outputFile.createFileIfNotExists$default$3(x$1);
                File qual$1 = outputFile.createFileIfNotExists(x$1, x$2, x$3);
                String x$4 = scriptPayload;
                Seq x$5 = qual$1.overwrite$default$2(x$4);
                Charset x$6 = qual$1.overwrite$default$3(x$4);
                qual$1.overwrite(x$4, x$5, x$6);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Successfully generated script {}", new Object[]{outputFile});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            File file = outputFile;
            return file;
        }).toList();
    }

    public List<File> generateDomain(Domain domain, File scriptTemplateFile, File scriptsOutputPath, Option<String> scriptOutputPattern, Option<String> defaultDeltaColumn, Map<String, String> deltaColumns) {
        List<TemplateParams> templateSettings = TemplateParams$.MODULE$.fromDomain(domain, scriptsOutputPath, scriptOutputPattern, defaultDeltaColumn, deltaColumns, this.settings);
        return (List)templateSettings.flatMap((Function1 & Serializable & scala.Serializable)ts -> this.templatize(scriptTemplateFile, (TemplateParams)ts), List$.MODULE$.canBuildFrom());
    }

    public File generateJob(AutoJobDesc job, File scriptTemplateFile, File scriptsOutputFolder, Option<String> scriptOutputPattern) {
        BoxedUnit boxedUnit;
        IngestionWorkflow workflow = new IngestionWorkflow(this.settings.metadataStorageHandler(), this.schemaHandler, new SimpleLauncher(), this.settings);
        Seq<AutoTaskJob> actions = workflow.buildTasks(job.name(), (Map<String, String>)Predef$.MODULE$.Map().empty());
        actions.map((Function1 & Serializable & scala.Serializable)action -> {
            Tuple3<List<String>, String, List<String>> tuple3;
            Engine engine = action.engine();
            if (((Object)Engine$BQ$.MODULE$).equals(engine)) {
                tuple3 = action.buildQueryBQ();
            } else if (((Object)Engine$SPARK$.MODULE$).equals(engine)) {
                tuple3 = action.buildQuerySpark();
            } else {
                throw new Exception("not supported");
            }
            Tuple3<List<String>, String, List<String>> tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            List preSql = (List)tuple32._1();
            String sql = (String)tuple32._2();
            List postSql = (List)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)preSql, (Object)sql, (Object)postSql);
            Tuple3 tuple34 = tuple33;
            List preSql2 = (List)tuple34._1();
            String sql2 = (String)tuple34._2();
            List postSql2 = (List)tuple34._3();
            Some x$1 = new Some((Object)preSql2);
            Option x$2 = Option$.MODULE$.apply((Object)sql2);
            Some x$3 = new Some((Object)postSql2);
            Option<String> x$4 = action.task().copy$default$1();
            String x$5 = action.task().copy$default$3();
            String x$6 = action.task().copy$default$4();
            WriteMode x$7 = action.task().copy$default$5();
            Option<List<String>> x$8 = action.task().copy$default$6();
            Option<StorageArea> x$9 = action.task().copy$default$9();
            Option<Sink> x$10 = action.task().copy$default$10();
            Option<List<RowLevelSecurity>> x$11 = action.task().copy$default$11();
            Option<Map<String, String>> x$12 = action.task().copy$default$12();
            Option<Engine> x$13 = action.task().copy$default$13();
            AutoTaskDesc x$14 = action.task().copy(x$4, (Option<String>)x$2, x$5, x$6, x$7, x$8, (Option<List<String>>)x$1, (Option<List<String>>)x$3, x$9, x$10, x$11, x$12, x$13);
            String x$15 = action.copy$default$1();
            StorageArea x$16 = action.copy$default$2();
            Option<String> x$17 = action.copy$default$3();
            boolean x$18 = action.copy$default$4();
            Option<String> x$19 = action.copy$default$5();
            Views x$20 = action.copy$default$6();
            Engine x$21 = action.copy$default$7();
            Map<String, String> x$22 = action.copy$default$9();
            Settings x$23 = $this.settings;
            HdfsStorageHandler x$24 = $this.settings.metadataStorageHandler();
            SchemaHandler x$25 = $this.schemaHandler;
            return action.copy(x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$14, x$22, x$23, x$24, x$25);
        }, Seq$.MODULE$.canBuildFrom());
        String scriptPayload = this.engine().layout(scriptTemplateFile.pathAsString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job"), (Object)job), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actions"), actions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"env"), this.schemaHandler.activeEnv())})), this.engine().layout$default$3());
        String scriptOutputFileName = (String)scriptOutputPattern.map((Function1 & Serializable & scala.Serializable)x$4 -> Formatter$.MODULE$.RichFormatter((String)x$4).richFormat((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job"), (Object)job.name())}))), $this.settings)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append(job.name()).append(".py").toString());
        File scriptOutputFile = scriptsOutputFolder.$div(scriptOutputFileName);
        boolean x$26 = scriptOutputFile.createFileIfNotExists$default$1();
        Seq x$27 = scriptOutputFile.createFileIfNotExists$default$2(x$26);
        Seq x$28 = scriptOutputFile.createFileIfNotExists$default$3(x$26);
        File qual$1 = scriptOutputFile.createFileIfNotExists(x$26, x$27, x$28);
        String x$29 = scriptPayload;
        Seq x$30 = qual$1.overwrite$default$2(x$29);
        Charset x$31 = qual$1.overwrite$default$3(x$29);
        File scriptFile = qual$1.overwrite(x$29, x$30, x$31);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Successfully generated job script {}", new Object[]{scriptFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return scriptFile;
    }

    public boolean run(String[] args) {
        boolean bl;
        BoxedUnit boxedUnit;
        List arglist = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running Starlake {}", new Object[]{arglist});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<ExtractScriptGenConfig> option = ExtractScriptGenConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (option instanceof Some) {
            Some some = (Some)option;
            ExtractScriptGenConfig config = (ExtractScriptGenConfig)some.value();
            bl = this.run(config, this.settings);
        } else {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Program execution or parameters are wrong, please check usage");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(ExtractScriptGenConfig config, Settings settings) {
        BoxedUnit boxedUnit;
        DatasetArea$.MODULE$.initMetadata(settings.metadataStorageHandler(), settings);
        SchemaHandler schemaHandler = new SchemaHandler(settings.metadataStorageHandler(), settings);
        Tuple2 tuple2 = new Tuple2(config.domain(), config.jobs());
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq seq2 = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq) && Nil$.MODULE$.equals(seq2)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("One of domain or jobs should be provided");
                    boxedUnit2 = BoxedUnit.UNIT;
                    return false;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return false;
            }
        }
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq jobNames = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return this.runOnJobs(config, schemaHandler, (Seq<String>)jobNames);
            }
        }
        if (tuple2 != null) {
            Seq domainNames = (Seq)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return this.runOnDomains(config, schemaHandler, (Seq<String>)domainNames);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Only one of domain or job list should be passed as an argument");
            boxedUnit = BoxedUnit.UNIT;
            return false;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return false;
    }

    private boolean runOnDomains(ExtractScriptGenConfig config, SchemaHandler schemaHandler, Seq<String> domainNames) {
        List<Domain> domains = schemaHandler.domains();
        return ((IterableLike)domainNames.map((Function1 & Serializable & scala.Serializable)domainName -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$1(this, domains, config, domainName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$4(BoxesRunTime.unboxToBoolean((Object)x$6))));
    }

    private boolean runOnJobs(ExtractScriptGenConfig config, SchemaHandler schemaHandler, Seq<String> jobNames) {
        Map<String, AutoJobDesc> jobs2 = schemaHandler.jobs();
        return ((IterableLike)jobNames.map((Function1 & Serializable & scala.Serializable)jobName -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnJobs$1(this, jobs2, config, jobName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnJobs$2(BoxesRunTime.unboxToBoolean((Object)x$7))));
    }

    private static final String formatFilename$1(String name, TemplateParams templateParams$1) {
        return name.substring(0, name.lastIndexOf(".")).replaceAll("domain", templateParams$1.domainToExport()).replaceAll("schema", templateParams$1.tableToExport());
    }

    public static final /* synthetic */ boolean $anonfun$templatize$2(String name) {
        return name.endsWith(".ssp") || name.endsWith(".mustache");
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$2(String domainName$1, Domain x$5) {
        String string = x$5.name();
        String string2 = domainName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$1(ScriptGen $this, List domains$1, ExtractScriptGenConfig config$1, String domainName) {
        boolean bl;
        Option option = domains$1.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$2(domainName, x$5)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Domain domain = (Domain)some.value();
            $this.generateDomain(domain, config$1.scriptTemplateFile(), config$1.scriptOutputDir(), config$1.scriptOutputPattern(), (Option<String>)config$1.deltaColumn().orElse((Function0 & Serializable & scala.Serializable)() -> Settings$.MODULE$.deltaColumns().defaultColumn()), Settings$.MODULE$.deltaColumns().deltaColumns());
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No domain found for domain name {}", new Object[]{config$1.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$4(boolean x$6) {
        return x$6;
    }

    public static final /* synthetic */ boolean $anonfun$runOnJobs$1(ScriptGen $this, Map jobs$1, ExtractScriptGenConfig config$2, String jobName) {
        boolean bl;
        Option option = jobs$1.get((Object)jobName);
        if (option instanceof Some) {
            Some some = (Some)option;
            AutoJobDesc job = (AutoJobDesc)some.value();
            $this.generateJob(job, config$2.scriptTemplateFile(), config$2.scriptOutputDir(), config$2.scriptOutputPattern());
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No file found for domain name {}", new Object[]{config$2.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$runOnJobs$2(boolean x$7) {
        return x$7;
    }

    public ScriptGen(StorageHandler storageHandler, SchemaHandler schemaHandler, LaunchHandler launchHandler, Settings settings) {
        this.schemaHandler = schemaHandler;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.engine = new TemplateEngine(TemplateEngine$.MODULE$.$lessinit$greater$default$1(), TemplateEngine$.MODULE$.$lessinit$greater$default$2());
    }
}

