/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.index.connectionload;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.job.index.connectionload.ConnectionLoadConfig;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.JobInfo;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r4AAC\u0006\u0001-!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0015\r\u0011b\u0001*\u0011!\u0001\u0004A!A!\u0002\u0013Q\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\u001c\u0001\t\u0003B\u0004b\u0002#\u0001\u0005\u0004%\t!\u0012\u0005\u0007#\u0002\u0001\u000b\u0011\u0002$\t\u000bI\u0003A\u0011A*\t\u000bu\u0003A\u0011\t0\u0003#\r{gN\\3di&|g\u000eT8bI*{'M\u0003\u0002\r\u001b\u0005q1m\u001c8oK\u000e$\u0018n\u001c8m_\u0006$'B\u0001\b\u0010\u0003\u0015Ig\u000eZ3y\u0015\t\u0001\u0012#A\u0002k_\nT!AE\n\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011\u0001F\u0001\u0003C&\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0012\u0003\u0015)H/\u001b7t\u0013\t\u0011sD\u0001\u0005Ta\u0006\u00148NS8c\u0003%\u0019G.[\"p]\u001aLw\r\u0005\u0002&M5\t1\"\u0003\u0002(\u0017\t!2i\u001c8oK\u000e$\u0018n\u001c8M_\u0006$7i\u001c8gS\u001e\f\u0001b]3ui&twm]\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011Q&E\u0001\u0007G>tg-[4\n\u0005=b#\u0001C*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00024mQ\u0011A'\u000e\t\u0003K\u0001AQ\u0001\u000b\u0003A\u0004)BQa\t\u0003A\u0002\u0011\nAA\\1nKV\t\u0011\b\u0005\u0002;\u0003:\u00111h\u0010\t\u0003yei\u0011!\u0010\u0006\u0003}U\ta\u0001\u0010:p_Rt\u0014B\u0001!\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001K\u0012\u0001B2p]\u001a,\u0012A\u0012\t\u0003\u000f>k\u0011\u0001\u0013\u0006\u0003\t&S!AS&\u0002\r!\fGm\\8q\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%!D\"p]\u001aLw-\u001e:bi&|g.A\u0003d_:4\u0007%A\u0004sk:TEIQ\"\u0015\u0003Q\u00032!\u0016-[\u001b\u00051&BA,\u001a\u0003\u0011)H/\u001b7\n\u0005e3&a\u0001+ssB\u0011adW\u0005\u00039~\u0011ab\u00159be.TuN\u0019*fgVdG/A\u0002sk:$\u0012a\u0018\t\u0004+b\u0003\u0007C\u0001\u0010b\u0013\t\u0011wDA\u0005K_\n\u0014Vm];mi\u0002")
public class ConnectionLoadJob
implements SparkJob {
    private final ConnectionLoadConfig cliConfig;
    private final Settings settings;
    private final Configuration conf;
    private SparkEnv sparkEnv;
    private SparkSession session;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        return SparkJob.withExtraSparkConf$(this, sourceConfig);
    }

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionedDatasetWriter$(this, dataset, partition);
    }

    @Override
    public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionDataset$(this, dataset, partition);
    }

    @Override
    public Object analyze(String fullTableName) {
        return SparkJob.analyze$(this, fullTableName);
    }

    @Override
    public void createSparkViews(Views views, Map<String, String> sqlParameters) {
        SparkJob.createSparkViews$(this, views, sqlParameters);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private SparkEnv sparkEnv$lzycompute() {
        ConnectionLoadJob connectionLoadJob = this;
        synchronized (connectionLoadJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkEnv = SparkJob.sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkEnv;
    }

    @Override
    public SparkEnv sparkEnv() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkEnv$lzycompute() : this.sparkEnv;
    }

    private SparkSession session$lzycompute() {
        ConnectionLoadJob connectionLoadJob = this;
        synchronized (connectionLoadJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(14).append("jdbcload-JDBC-").append(this.cliConfig.outputTable()).toString();
    }

    public Configuration conf() {
        return this.conf;
    }

    public Try<SparkJobResult> runJDBC() {
        BoxedUnit boxedUnit;
        Either<String, Dataset<Row>> inputPath = this.cliConfig.sourceFile();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Input path {}", new Object[]{inputPath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataset;
            Either either = inputPath;
            if (either instanceof Left) {
                Left left = (Left)either;
                String path = (String)left.value();
                dataset = this.session().read().format(this.settings().comet().defaultFormat()).load(path);
            } else if (either instanceof Right) {
                Dataset df;
                Right right = (Right)either;
                dataset = df = (Dataset)right.value();
            } else {
                throw new MatchError((Object)either);
            }
            Dataset sourceDF = dataset;
            JobInfo.WriteDisposition writeDisposition = $this.cliConfig.writeDisposition();
            JobInfo.WriteDisposition writeDisposition2 = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            SaveMode writeMode = !(writeDisposition != null ? !writeDisposition.equals(writeDisposition2) : writeDisposition2 != null) ? SaveMode.Overwrite : SaveMode.Append;
            JobInfo.WriteDisposition writeDisposition3 = $this.cliConfig.writeDisposition();
            JobInfo.WriteDisposition writeDisposition4 = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            DataFrameWriter dfw = sourceDF.write().format($this.cliConfig.format()).option("truncate", !(writeDisposition3 != null ? !writeDisposition3.equals(writeDisposition4) : writeDisposition4 != null)).option("dbtable", $this.cliConfig.outputTable()).mode((String)$this.cliConfig.mode().getOrElse((Function0 & Serializable & scala.Serializable)() -> writeMode.toString()));
            dfw.options($this.cliConfig.options()).save();
            return new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$);
        });
    }

    @Override
    public Try<JobResult> run() {
        Try<SparkJobResult> res = this.runJDBC();
        return Utils$.MODULE$.logFailure(res, this.logger());
    }

    public ConnectionLoadJob(ConnectionLoadConfig cliConfig, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
        this.conf = this.session().sparkContext().hadoopConfiguration();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JDBC Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

