/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.index.esload;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.job.index.esload.ESLoadConfig;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u000b\u0017\u0001\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0015\r\u0011b\u0001B\u0011!A\u0005A!A!\u0002\u0013\u0011\u0005\"B%\u0001\t\u0003Q\u0005bB)\u0001\u0005\u0004%\tA\u0015\u0005\u0007W\u0002\u0001\u000b\u0011B*\t\u000f1\u0004!\u0019!C\u0001[\"1\u0011\u000f\u0001Q\u0001\n9DqA\u001d\u0001C\u0002\u0013\u00051\u000f\u0003\u0004}\u0001\u0001\u0006I\u0001\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u001d\ti\u0005\u0001Q\u0001\n}D\u0011\"a\u0014\u0001\u0005\u0004%\t!!\u0015\t\u000f\u0005M\u0003\u0001)A\u0005C\"I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011q\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002Z!9\u0011Q\f\u0001\u0005B\u0005E\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0002\n\u000bNcu.\u00193K_\nT!a\u0006\r\u0002\r\u0015\u001cHn\\1e\u0015\tI\"$A\u0003j]\u0012,\u0007P\u0003\u0002\u001c9\u0005\u0019!n\u001c2\u000b\u0005uq\u0012\u0001C:uCJd\u0017m[3\u000b\u0003}\t!!Y5\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tIC&D\u0001+\u0015\tYC$A\u0003vi&d7/\u0003\u0002.U\tA1\u000b]1sW*{'-A\u0005dY&\u001cuN\u001c4jOB\u0011\u0001'M\u0007\u0002-%\u0011!G\u0006\u0002\r\u000bNcu.\u00193D_:4\u0017nZ\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0005iC:$G.\u001a:t\u0015\tID$\u0001\u0004tG\",W.Y\u0005\u0003wY\u0012ab\u0015;pe\u0006<W\rS1oI2,'/A\u0007tG\",W.\u0019%b]\u0012dWM\u001d\t\u0003kyJ!a\u0010\u001c\u0003\u001bM\u001b\u0007.Z7b\u0011\u0006tG\r\\3s\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015c\u0012AB2p]\u001aLw-\u0003\u0002H\t\nA1+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u00051A(\u001b8jiz\"Ba\u0013(P!R\u0011A*\u0014\t\u0003a\u0001AQ\u0001\u0011\u0004A\u0004\tCQA\f\u0004A\u0002=BQa\r\u0004A\u0002QBQ\u0001\u0010\u0004A\u0002u\n!\"Z:sKN|WO]2f+\u0005\u0019\u0006cA\u0012U-&\u0011Q\u000b\n\u0002\u0005'>lW\r\u0005\u0003$/f\u000b\u0017B\u0001-%\u0005\u0019!V\u000f\u001d7feA\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0005Y\u0006twMC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&AB*ue&tw\r\u0005\u0002cS:\u00111m\u001a\t\u0003I\u0012j\u0011!\u001a\u0006\u0003M\u0002\na\u0001\u0010:p_Rt\u0014B\u00015%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001M\u001b\u0006\u0003Q\u0012\n1\"Z:sKN|WO]2fA\u0005!Qm]%e+\u0005q\u0007cA\u0012p-&\u0011\u0001\u000f\n\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000b\u0015\u001c\u0018\n\u001a\u0011\u0002\u0013\u0015\u001c8\t\\5D_:4W#\u0001;\u0011\tUT\u0018-Y\u0007\u0002m*\u0011q\u000f_\u0001\nS6lW\u000f^1cY\u0016T!!\u001f\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002|m\n\u0019Q*\u00199\u0002\u0015\u0015\u001c8\t\\5D_:4\u0007%\u0001\u0003qCRDW#A@\u0011\u0011\u0005\u0005\u00111BA\t\u0003SqA!a\u0001\u0002\b9\u0019A-!\u0002\n\u0003\u0015J1!!\u0003%\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t1Q)\u001b;iKJT1!!\u0003%!\u0011\t\u0019\"!\n\u000e\u0005\u0005U!\u0002BA\f\u00033\t!AZ:\u000b\t\u0005m\u0011QD\u0001\u0007Q\u0006$wn\u001c9\u000b\t\u0005}\u0011\u0011E\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0012aA8sO&!\u0011qEA\u000b\u0005\u0011\u0001\u0016\r\u001e5\u0011\t\u0005-\u0012q\t\b\u0005\u0003[\t\u0019E\u0004\u0003\u00020\u0005ub\u0002BA\u0019\u0003sqA!a\r\u000289\u0019A-!\u000e\n\u0005\u0005\r\u0012\u0002BA\u0010\u0003CIA!a\u000f\u0002\u001e\u0005)1\u000f]1sW&!\u0011qHA!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0005\u0003w\ti\"\u0003\u0003\u0002\n\u0005\u0015#\u0002BA \u0003\u0003JA!!\u0013\u0002L\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003\u0013\t)%A\u0003qCRD\u0007%\u0001\u0004g_Jl\u0017\r^\u000b\u0002C\u00069am\u001c:nCR\u0004\u0013a\u00023bi\u0006\u001cX\r^\u000b\u0003\u00033\u00022aI8\u0000\u0003!!\u0017\r^1tKR\u0004\u0013\u0001\u00028b[\u0016\f1A];o)\t\t\u0019\u0007\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003OR1!!\u001b%\u0003\u0011)H/\u001b7\n\t\u00055\u0014q\r\u0002\u0004)JL\bcA\u0015\u0002r%\u0019\u00111\u000f\u0016\u0003\u0013){'MU3tk2$\b")
public class ESLoadJob
implements SparkJob {
    private final ESLoadConfig cliConfig;
    private final StorageHandler storageHandler;
    private final SchemaHandler schemaHandler;
    private final Settings settings;
    private final Some<Tuple2<String, String>> esresource;
    private final Option<Tuple2<String, String>> esId;
    private final scala.collection.immutable.Map<String, String> esCliConf;
    private final Either<Path, Dataset<Row>> path;
    private final String format;
    private final Option<Either<Path, Dataset<Row>>> dataset;
    private SparkEnv sparkEnv;
    private SparkSession session;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        return SparkJob.withExtraSparkConf$(this, sourceConfig);
    }

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionedDatasetWriter$(this, dataset, partition);
    }

    @Override
    public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionDataset$(this, dataset, partition);
    }

    @Override
    public Object analyze(String fullTableName) {
        return SparkJob.analyze$(this, fullTableName);
    }

    @Override
    public void createSparkViews(Views views, scala.collection.immutable.Map<String, String> sqlParameters) {
        SparkJob.createSparkViews$(this, views, sqlParameters);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private SparkEnv sparkEnv$lzycompute() {
        ESLoadJob eSLoadJob = this;
        synchronized (eSLoadJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkEnv = SparkJob.sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkEnv;
    }

    @Override
    public SparkEnv sparkEnv() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkEnv$lzycompute() : this.sparkEnv;
    }

    private SparkSession session$lzycompute() {
        ESLoadJob eSLoadJob = this;
        synchronized (eSLoadJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    public Some<Tuple2<String, String>> esresource() {
        return this.esresource;
    }

    public Option<Tuple2<String, String>> esId() {
        return this.esId;
    }

    public scala.collection.immutable.Map<String, String> esCliConf() {
        return this.esCliConf;
    }

    public Either<Path, Dataset<Row>> path() {
        return this.path;
    }

    public String format() {
        return this.format;
    }

    public Option<Either<Path, Dataset<Row>>> dataset() {
        return this.dataset;
    }

    @Override
    public String name() {
        return new StringBuilder(6).append("Index ").append(this.path()).toString();
    }

    @Override
    public Try<JobResult> run() {
        List allConf;
        BoxedUnit boxedUnit;
        Dataset dataset;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Indexing resource {} with {}", new Object[]{this.cliConfig.getResource(), this.cliConfig});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Either<Path, Dataset<Row>> either = this.path();
        if (either instanceof Left) {
            Dataset dataset2;
            Left left = (Left)either;
            Path path2 = (Path)left.value();
            String string = this.format();
            if ("json".equals(string)) {
                dataset2 = this.session().read().option("multiline", true).json(path2.toString());
            } else if ("json-array".equals(string)) {
                Dataset jsonDS = this.session().read().textFile(path2.toString());
                dataset2 = this.session().read().json(jsonDS);
            } else if ("parquet".equals(string)) {
                dataset2 = this.session().read().format("parquet").load(path2.toString());
            } else if ("delta".equals(string)) {
                dataset2 = this.session().read().format("delta").load(path2.toString());
            } else {
                throw new MatchError((Object)string);
            }
            dataset = dataset2;
        } else if (either instanceof Right) {
            Dataset df;
            Right right = (Right)either;
            dataset = df = (Dataset)right.value();
        } else {
            throw new MatchError(either);
        }
        Dataset inputDF = dataset;
        Dataset df = (Dataset)this.cliConfig.getTimestampCol().map((Function1 & Serializable & scala.Serializable)tsCol -> inputDF.withColumn("comet_es_tmp", functions$.MODULE$.date_format(functions$.MODULE$.col(tsCol), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).drop(tsCol).withColumnRenamed("comet_es_tmp", tsCol)).getOrElse((Function0 & Serializable & scala.Serializable)() -> inputDF);
        String content = (String)this.cliConfig.mapping().map((Function1 & Serializable & scala.Serializable)path -> $this.storageHandler.read((Path)path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Option dynamicTemplate = $this.schemaHandler.getDomain($this.cliConfig.domain()).flatMap((Function1 & Serializable & scala.Serializable)domain -> domain.schemas().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ESLoadJob.$anonfun$run$6(this, x$2))).map((Function1 & Serializable & scala.Serializable)schema -> schema.esMapping(domain.esMapping((Schema)schema, this.settings()), domain.name(), $this.schemaHandler, this.settings())));
            return (String)dynamicTemplate.getOrElse((Function0 & Serializable & scala.Serializable)() -> Schema$.MODULE$.mapping($this.cliConfig.domain(), $this.cliConfig.schema(), new StructField("ignore", (DataType)df.schema(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), $this.schemaHandler, this.settings()));
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Registering template {}_{} -> {}", new Object[]{this.cliConfig.domain().toLowerCase(), this.cliConfig.schema().toLowerCase(), content});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        scala.collection.immutable.Map<String, String> esOptions = this.settings().comet().elasticsearch().options();
        String host = (String)esOptions.getOrElse((Object)"es.nodes", (Function0 & Serializable & scala.Serializable)() -> "localhost");
        int port = new StringOps(Predef$.MODULE$.augmentString((String)esOptions.getOrElse((Object)"es.port", (Function0 & Serializable & scala.Serializable)() -> "9200"))).toInt();
        boolean ssl = new StringOps(Predef$.MODULE$.augmentString((String)esOptions.getOrElse((Object)"es.net.ssl", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        String protocol = ssl ? "https" : "http";
        Option username = esOptions.get((Object)"net.http.auth.user");
        Option password = esOptions.get((Object)"net.http.auth.password");
        CloseableHttpClient client = HttpClients.createDefault();
        Option basicHeader2 = username.flatMap((Function1 & Serializable & scala.Serializable)u -> password.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(6).append("Basic ").append(Base64.getEncoder().encodeToString("$u:$p".getBytes(StandardCharsets.UTF_8))).toString()));
        String templateURL = new StringBuilder(15).append(protocol).append("://").append(host).append(":").append(port).append("/_template/").append(this.cliConfig.getIndexName()).toString();
        HttpDelete delRequest = new HttpDelete(templateURL);
        delRequest.setHeader("Content-Type", "application/json");
        basicHeader2.foreach((Function1 & Serializable & scala.Serializable)basicHeader -> {
            delRequest.setHeader("Authorization", basicHeader);
            return BoxedUnit.UNIT;
        });
        client.execute((HttpUriRequest)delRequest);
        HttpPut putRequest = new HttpPut(templateURL);
        putRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        basicHeader2.foreach((Function1 & Serializable & scala.Serializable)basicHeader -> {
            delRequest.setHeader("Authorization", basicHeader);
            return BoxedUnit.UNIT;
        });
        CloseableHttpResponse responsePut = client.execute((HttpUriRequest)putRequest);
        boolean ok = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(200), 299).contains(responsePut.getStatusLine().getStatusCode());
        if (ok) {
            BoxedUnit boxedUnit3;
            allConf = (List)esOptions.toList().$plus$plus((GenTraversableOnce)this.esCliConf().toList(), List$.MODULE$.canBuildFrom());
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("sending {} documents to Elasticsearch using {}", new Object[]{BoxesRunTime.boxToLong((long)df.count()), allConf});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
        } else {
            Failure failure;
            Failure failure2 = failure;
            Failure failure3 = failure;
            throw new Exception("Failed to create template");
        }
        DataFrameWriter writer = df.write().options((Map)allConf.toMap(Predef$.MODULE$.$conforms())).format("org.elasticsearch.spark.sql").mode(SaveMode.Overwrite);
        writer.save(this.cliConfig.getResource());
        return new Success((Object)new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$run$6(ESLoadJob $this, Schema x$2) {
        String string = x$2.name();
        String string2 = $this.cliConfig.schema();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ESLoadJob(ESLoadConfig cliConfig, StorageHandler storageHandler, SchemaHandler schemaHandler, Settings settings) {
        this.cliConfig = cliConfig;
        this.storageHandler = storageHandler;
        this.schemaHandler = schemaHandler;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
        this.esresource = new Some((Object)new Tuple2((Object)"es.resource.write", (Object)String.valueOf(cliConfig.getResource())));
        this.esId = cliConfig.id().map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.mapping.id"), x$1));
        this.esCliConf = cliConfig.options().$plus$plus((GenTraversableOnce)((TraversableOnce)new .colon.colon(this.esresource(), (List)new .colon.colon(this.esId(), (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms()));
        this.path = cliConfig.getDataset(settings);
        this.format = cliConfig.format();
        this.dataset = cliConfig.dataset();
    }
}

