/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.generator;

import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.schema.generator.XlsModel;
import ai.starlake.schema.generator.Yml2XlsConfig;
import ai.starlake.schema.generator.Yml2XlsConfig$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$POSITION$;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Schema;
import better.files.File;
import better.files.File$;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001%4AAB\u0004\u0001!!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003-\u0001\u0011\u0005Q\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003F\u0001\u0011\u0005a\tC\u0003^\u0001\u0011\u0005aLA\u0007Z[2\u0014\u0004\f\\:Xe&$XM\u001d\u0006\u0003\u0011%\t\u0011bZ3oKJ\fGo\u001c:\u000b\u0005)Y\u0011AB:dQ\u0016l\u0017M\u0003\u0002\r\u001b\u0005A1\u000f^1sY\u0006\\WMC\u0001\u000f\u0003\t\t\u0017n\u0001\u0001\u0014\t\u0001\tr#\t\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ayR\"A\r\u000b\u0005iY\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u000f\u001e\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0010\u0002\u0007\r|W.\u0003\u0002!3\tYA*\u0019>z\u0019><w-\u001b8h!\t\u00113%D\u0001\b\u0013\t!sA\u0001\u0005YYNlu\u000eZ3m\u00035\u00198\r[3nC\"\u000bg\u000e\u001a7feB\u0011qEK\u0007\u0002Q)\u0011\u0011&C\u0001\tQ\u0006tG\r\\3sg&\u00111\u0006\u000b\u0002\u000e'\u000eDW-\\1IC:$G.\u001a:\u0002\rqJg.\u001b;?)\tqs\u0006\u0005\u0002#\u0001!)QE\u0001a\u0001M\u0005\u0019!/\u001e8\u0015\u0005I*\u0004C\u0001\n4\u0013\t!4C\u0001\u0003V]&$\b\"\u0002\u001c\u0004\u0001\u00049\u0014\u0001B1sON\u00042A\u0005\u001d;\u0013\tI4CA\u0003BeJ\f\u0017\u0010\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{Mi\u0011A\u0010\u0006\u0003\u007f=\ta\u0001\u0010:p_Rt\u0014BA!\u0014\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u001b\u0012aC4f]\u0016\u0014\u0018\r^3YYN$2a\u0012)\\)\t\u0011\u0004\nC\u0003J\t\u0001\u000f!*\u0001\u0005tKR$\u0018N\\4t!\tYe*D\u0001M\u0015\ti5\"\u0001\u0004d_:4\u0017nZ\u0005\u0003\u001f2\u0013\u0001bU3ui&twm\u001d\u0005\u0006#\u0012\u0001\rAU\u0001\fI>l\u0017-\u001b8OC6,7\u000fE\u0002T1jr!\u0001\u0016,\u000f\u0005u*\u0016\"\u0001\u000b\n\u0005]\u001b\u0012a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t96\u0003C\u0003]\t\u0001\u0007!(A\u0005pkR\u0004X\u000f\u001e#je\u0006qqO]5uK\u0012{W.Y5o12\u001cHc\u0001\u001a`O\")\u0001-\u0002a\u0001C\u00061Am\\7bS:\u0004\"AY3\u000e\u0003\rT!\u0001Z\u0005\u0002\u000b5|G-\u001a7\n\u0005\u0019\u001c'A\u0002#p[\u0006Lg\u000eC\u0003i\u000b\u0001\u0007!(\u0001\u0004g_2$WM\u001d")
public class Yml2XlsWriter
implements LazyLogging,
XlsModel {
    private final SchemaHandler schemaHandler;
    private final List<Tuple2<String, String>> allDomainHeaders;
    private final List<Tuple2<String, String>> allSchemaHeaders;
    private final List<Tuple2<String, String>> allAttributeHeaders;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public List<Tuple2<String, String>> allDomainHeaders() {
        return this.allDomainHeaders;
    }

    @Override
    public List<Tuple2<String, String>> allSchemaHeaders() {
        return this.allSchemaHeaders;
    }

    @Override
    public List<Tuple2<String, String>> allAttributeHeaders() {
        return this.allAttributeHeaders;
    }

    @Override
    public void ai$starlake$schema$generator$XlsModel$_setter_$allDomainHeaders_$eq(List<Tuple2<String, String>> x$1) {
        this.allDomainHeaders = x$1;
    }

    @Override
    public void ai$starlake$schema$generator$XlsModel$_setter_$allSchemaHeaders_$eq(List<Tuple2<String, String>> x$1) {
        this.allSchemaHeaders = x$1;
    }

    @Override
    public void ai$starlake$schema$generator$XlsModel$_setter_$allAttributeHeaders_$eq(List<Tuple2<String, String>> x$1) {
        this.allAttributeHeaders = x$1;
    }

    private Logger logger$lzycompute() {
        Yml2XlsWriter yml2XlsWriter = this;
        synchronized (yml2XlsWriter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void run(String[] args) {
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        Option<Yml2XlsConfig> option = Yml2XlsConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (option instanceof Some) {
            Some some = (Some)option;
            Yml2XlsConfig config = (Yml2XlsConfig)some.value();
            this.generateXls(config.domains(), config.xlsDirectory(), settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)Yml2XlsConfig$.MODULE$.usage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void generateXls(Seq<String> domainNames, String outputDir, Settings settings) {
        Seq<String> seq = domainNames;
        List list = Nil$.MODULE$.equals(seq) ? this.schemaHandler.domains() : (List)this.schemaHandler.domains().filter((Function1 & Serializable & scala.Serializable)domain -> BoxesRunTime.boxToBoolean((boolean)seq.contains((Object)domain.name())));
        List domains = list;
        domains.foreach((Function1 & Serializable & scala.Serializable)domain -> {
            this.writeDomainXls(domain, outputDir);
            return BoxedUnit.UNIT;
        });
    }

    public void writeDomainXls(Domain domain, String folder) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)14);
        font.setFontName("Calibri");
        font.setBold(true);
        XSSFCellStyle boldStyle = workbook.createCellStyle();
        boldStyle.setFont((Font)font);
        File xlsOut = File$.MODULE$.apply(folder, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append(domain.name()).append(".xlsx").toString()}));
        XSSFSheet domainSheet = workbook.createSheet("domain");
        Yml2XlsWriter.fillHeaders$1(this.allDomainHeaders(), domainSheet, boldStyle);
        XSSFRow domainRow = domainSheet.createRow(2);
        domainRow.createCell(0).setCellValue(domain.name());
        domainRow.createCell(1).setCellValue(domain.resolveDirectory());
        domainRow.createCell(2).setCellValue((String)domain.resolveAck().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        domainRow.createCell(3).setCellValue((String)domain.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        domainRow.createCell(4).setCellValue(((TraversableOnce)domain.schemaRefs().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).mkString(","));
        this.allDomainHeaders().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> domainSheet.autoSizeColumn(i));
        XSSFSheet schemaSheet = workbook.createSheet("schemas");
        Yml2XlsWriter.fillHeaders$1(this.allSchemaHeaders(), schemaSheet, boldStyle);
        ((List)domain.schemas().zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$9(this, domain, schemaSheet, workbook, boldStyle, x0$1);
            return BoxedUnit.UNIT;
        });
        xlsOut.delete(true, xlsOut.delete$default$2());
        workbook.write((OutputStream)xlsOut.newFileOutputStream(false));
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$2(XSSFRow header$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        int columnIndex = tuple2._2$mcI$sp();
        XSSFCell cell = header$1.createCell(columnIndex);
        cell.setCellValue(key);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$4(XSSFRow labelHeader$1, XSSFCellStyle boldStyle$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String value = (String)tuple2._1();
        int columnIndex = tuple2._2$mcI$sp();
        XSSFCell cell = labelHeader$1.createCell(columnIndex);
        cell.setCellValue(value);
        cell.setCellStyle((CellStyle)boldStyle$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void fillHeaders$1(List headers, XSSFSheet sheet, XSSFCellStyle boldStyle$1) {
        XSSFRow header = sheet.createRow(0);
        header.setHeight((short)0);
        ((List)((IterableLike)headers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = key = (String)tuple2._1();
            return string;
        }, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$2(header, x0$2);
            return BoxedUnit.UNIT;
        });
        XSSFRow labelHeader = sheet.createRow(1);
        ((List)((IterableLike)headers.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            String value;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = value = (String)tuple2._2();
            return string;
        }, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$4(labelHeader, boldStyle$1, x0$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$writeDomainXls$16(boolean x$4) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)x$4)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$18(XSSFRow schemaRow$1, MergeOptions mergeOptions) {
        schemaRow$1.createCell(7).setCellValue((String)mergeOptions.timestamp().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow$1.createCell(8).setCellValue(mergeOptions.key().mkString(","));
        schemaRow$1.createCell(15).setCellValue((String)mergeOptions.queryFilter().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$writeDomainXls$54(boolean x$17) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)x$17)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$40(XSSFSheet attributesSheet$1, Metadata metadata$1, Tuple2 x0$2) {
        XSSFRow attrRow;
        Attribute attr;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            attr = (Attribute)tuple2._1();
            int rowIndex = tuple2._2$mcI$sp();
            attrRow = attributesSheet$1.createRow(2 + rowIndex);
            attrRow.createCell(0).setCellValue(attr.name());
            attrRow.createCell(1).setCellValue((String)attr.rename().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(2).setCellValue(attr.type());
            attrRow.createCell(3).setCellValue(attr.required());
            attrRow.getCell(3).setCellType(CellType.BOOLEAN);
            attrRow.createCell(4).setCellValue(attr.getPrivacy().toString());
            attrRow.createCell(5).setCellValue((String)attr.metricType().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(6).setCellValue((String)attr.default().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(7).setCellValue((String)attr.script().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(8).setCellValue((String)attr.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            attrRow.createCell(9).setCellValue("");
            attrRow.createCell(10).setCellValue("");
            Object object = metadata$1.format().getOrElse((Function0 & Serializable & scala.Serializable)() -> Format$DSV$.MODULE$);
            Format$POSITION$ format$POSITION$ = Format$POSITION$.MODULE$;
            if (!(object != null ? !object.equals(format$POSITION$) : format$POSITION$ != null)) {
                attrRow.getCell(9).setCellType(CellType.NUMERIC);
                attrRow.getCell(10).setCellType(CellType.NUMERIC);
                attrRow.getCell(9).setCellValue((String)attr.position().map((Function1 & Serializable & scala.Serializable)x$14 -> ((Object)BoxesRunTime.boxToInteger((int)x$14.first())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
                attrRow.getCell(10).setCellValue((String)attr.position().map((Function1 & Serializable & scala.Serializable)x$15 -> ((Object)BoxesRunTime.boxToInteger((int)x$15.last())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        attrRow.createCell(11).setCellValue((String)attr.trim().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        attrRow.createCell(12).setCellValue((String)attr.ignore().map((Function1 & Serializable & scala.Serializable)x$17 -> Yml2XlsWriter.$anonfun$writeDomainXls$54(BoxesRunTime.unboxToBoolean((Object)x$17))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "false"));
        attrRow.createCell(13).setCellValue((String)attr.foreignKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        attrRow.createCell(14).setCellValue((String)attr.tags().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writeDomainXls$9(Yml2XlsWriter $this, Domain domain$1, XSSFSheet schemaSheet$1, XSSFWorkbook workbook$1, XSSFCellStyle boldStyle$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Schema schema = (Schema)tuple2._1();
        int rowIndex = tuple2._2$mcI$sp();
        Metadata metadata = schema.mergedMetadata(domain$1.metadata());
        XSSFRow schemaRow = schemaSheet$1.createRow(2 + rowIndex);
        schemaRow.createCell(0).setCellValue(schema.name());
        schemaRow.createCell(1).setCellValue(schema.pattern().toString());
        schemaRow.createCell(2).setCellValue((String)metadata.mode().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(3).setCellValue((String)metadata.write().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(4).setCellValue((String)metadata.format().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(5).setCellValue((String)metadata.withHeader().map((Function1 & Serializable & scala.Serializable)x$4 -> Yml2XlsWriter.$anonfun$writeDomainXls$16(BoxesRunTime.unboxToBoolean((Object)x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.getCell(5).setCellType(CellType.BOOLEAN);
        schemaRow.createCell(6).setCellValue(metadata.getSeparator());
        schema.merge().foreach((Function1 & Serializable & scala.Serializable)mergeOptions -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$18(schemaRow, mergeOptions);
            return BoxedUnit.UNIT;
        });
        schemaRow.createCell(9).setCellValue((String)schema.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(10).setCellValue((String)metadata.encoding().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(11).setCellValue((String)metadata.partition().map((Function1 & Serializable & scala.Serializable)x$5 -> ((Object)BoxesRunTime.boxToDouble((double)x$5.getSampling())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(12).setCellValue((String)metadata.partition().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAttributes().mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(13).setCellValue((String)metadata.getSink().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(14).setCellValue((String)metadata.clustering().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(15).setCellValue((String)schema.presql().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.mkString("###")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(16).setCellValue((String)schema.presql().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.mkString("###")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(17).setCellValue((String)schema.primaryKey().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        schemaRow.createCell(18).setCellValue((String)schema.tags().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        $this.allSchemaHeaders().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> schemaSheet$1.autoSizeColumn(i));
        XSSFSheet attributesSheet = workbook$1.createSheet(schema.name());
        Yml2XlsWriter.fillHeaders$1($this.allAttributeHeaders(), attributesSheet, boldStyle$1);
        ((List)schema.attributes().zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Yml2XlsWriter.$anonfun$writeDomainXls$40(attributesSheet, metadata, x0$2);
            return BoxedUnit.UNIT;
        });
        $this.allAttributeHeaders().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> attributesSheet.autoSizeColumn(i));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Yml2XlsWriter(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        LazyLogging.$init$((LazyLogging)this);
        XlsModel.$init$(this);
    }
}

