/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.schema.handlers.StorageHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0011#\u0001%B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")\u0001\u000b\u0001C\u0001#\")a\u000b\u0001C\u0001/\")1\f\u0001C\u0001/\"9A\f\u0001b\u0001\n\u0013i\u0006bBA\u0016\u0001\u0001\u0006IA\u0018\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\t\u0019\u0007AI\u0001\n\u0003\t)\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\u0013\u0005E\u0005!%A\u0005\u0002\u0005M\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\n\u0003G\u0003\u0011\u0013!C\u0001\u0003OBq!a\n\u0001\t\u0003\ti\u0001C\u0004\u0002&\u0002!I!!\u0004\b\u000b\u0001\u0014\u0003\u0012A1\u0007\u000b\u0005\u0012\u0003\u0012\u00012\t\u000bA\u000bB\u0011A2\u0007\t\u0011\fB!\u001a\u0005\tuM\u0011\t\u0011)A\u0005w!Aqi\u0005B\u0001B\u0003%\u0001\n\u0003\u0005r'\t\u0005\t\u0015!\u0003Y\u0011\u0015\u00016\u0003\"\u0001s\u0011\u001dA8C1A\u0005\neDq!!\u0003\u0014A\u0003%!\u0010C\u0004\u0002\fM!\t!!\u0004\t\u0011\u0005U1C1A\u0005\neDq!a\u0006\u0014A\u0003%!\u0010C\u0005\u0002\u001aM\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011QE\n!\u0002\u0013\ti\u0002C\u0004\u0002(M!\t!!\u0004\t\u000f\u0005%2\u0003\"\u0011\u0002\u000e\tAa)\u001b7f\u0019>\u001c7N\u0003\u0002$I\u0005)Q\u000f^5mg*\u0011QEJ\u0001\tgR\f'\u000f\\1lK*\tq%\u0001\u0002bS\u000e\u00011c\u0001\u0001+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005U2\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003]\n1aY8n\u0013\tI$GA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0005a\u0006$\b\u000e\u0005\u0002=\u000b6\tQH\u0003\u0002?\u007f\u0005\u0011am\u001d\u0006\u0003\u0001\u0006\u000ba\u0001[1e_>\u0004(B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001eL!AR\u001f\u0003\tA\u000bG\u000f[\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\tIe*D\u0001K\u0015\tYE*\u0001\u0005iC:$G.\u001a:t\u0015\tiE%\u0001\u0004tG\",W.Y\u0005\u0003\u001f*\u0013ab\u0015;pe\u0006<W\rS1oI2,'/\u0001\u0004=S:LGO\u0010\u000b\u0004%R+\u0006CA*\u0001\u001b\u0005\u0011\u0003\"\u0002\u001e\u0004\u0001\u0004Y\u0004\"B$\u0004\u0001\u0004A\u0015!D2iK\u000e\\\u0017N\u001c)fe&|G-F\u0001Y!\tY\u0013,\u0003\u0002[Y\t!Aj\u001c8h\u00035\u0011XM\u001a:fg\"\u0004VM]5pI\u0006Ya-\u001b7f/\u0006$8\r[3s+\u0005q\u0006CA0\u0014\u001d\t\u0019\u0006#\u0001\u0005GS2,Gj\\2l!\t\u0019\u0016c\u0005\u0002\u0012UQ\t\u0011MA\u0006M_\u000e\\w+\u0019;dQ\u0016\u00148\u0003B\ng]B\u0002\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\t1\fgn\u001a\u0006\u0002W\u0006!!.\u0019<b\u0013\ti\u0007N\u0001\u0004PE*,7\r\u001e\t\u0003O>L!\u0001\u001d5\u0003\u0011I+hN\\1cY\u0016\fqB]3q_J$\u0018N\\4QKJLw\u000e\u001a\u000b\u0005gV4x\u000f\u0005\u0002u'5\t\u0011\u0003C\u0003;/\u0001\u00071\bC\u0003H/\u0001\u0007\u0001\nC\u0003r/\u0001\u0007\u0001,\u0001\u0005qe&\u001cH/\u001b8f+\u0005Q\bcA>\u0002\u00065\tAP\u0003\u0002~}\u00061\u0011\r^8nS\u000eT1a`A\u0001\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u0007Q\u0017\u0001B;uS2L1!a\u0002}\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006I\u0001O]5ti&tW\rI\u0001\u000eG\",7m\u001b)sSN$\u0018N\\3\u0015\u0005\u0005=\u0001cA\u0016\u0002\u0012%\u0019\u00111\u0003\u0017\u0003\tUs\u0017\u000e^\u0001\u0006gB,g\u000e^\u0001\u0007gB,g\u000e\u001e\u0011\u0002\u0007M,W.\u0006\u0002\u0002\u001eA!\u0011qDA\u0011\u001b\u0005q\u0018bAA\u0012}\nI1+Z7ba\"|'/Z\u0001\u0005g\u0016l\u0007%A\u0004sK2,\u0017m]3\u0002\u0007I,h.\u0001\u0007gS2,w+\u0019;dQ\u0016\u0014\b%\u0001\buef,\u0005p\u00197vg&4X\r\\=\u0016\t\u0005E\u00121\t\u000b\u0005\u0003g\ty\u0006\u0006\u0003\u00026\u0005U\u0003CBA\u001c\u0003w\ty$\u0004\u0002\u0002:)\u0019\u00111\u0001\u0017\n\t\u0005u\u0012\u0011\b\u0002\u0004)JL\b\u0003BA!\u0003\u0007b\u0001\u0001B\u0004\u0002F!\u0011\r!a\u0012\u0003\u0003Q\u000bB!!\u0013\u0002PA\u00191&a\u0013\n\u0007\u00055CFA\u0004O_RD\u0017N\\4\u0011\u0007-\n\t&C\u0002\u0002T1\u00121!\u00118z\u0011!\t9\u0006\u0003CA\u0002\u0005e\u0013AA8q!\u0015Y\u00131LA \u0013\r\ti\u0006\f\u0002\ty\tLh.Y7f}!A\u0011\u0011\r\u0005\u0011\u0002\u0003\u0007\u0001,A\buS6,w.\u001e;J]6KG\u000e\\5t\u0003a!(/_#yG2,8/\u001b<fYf$C-\u001a4bk2$H%M\u000b\u0005\u0003O\ni(\u0006\u0002\u0002j)\u001a\u0001,a\u001b,\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001e-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\n\tHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!!\u0012\n\u0005\u0004\t9%A\u0007e_\u0016C8\r\\;tSZ,G._\u000b\u0005\u0003\u0007\u000bI\t\u0006\u0003\u0002\u0006\u0006=E\u0003BAD\u0003\u0017\u0003B!!\u0011\u0002\n\u00129\u0011Q\t\u0006C\u0002\u0005\u001d\u0003\u0002CA,\u0015\u0011\u0005\r!!$\u0011\u000b-\nY&a\"\t\u0011\u0005\u0005$\u0002%AA\u0002a\u000bq\u0003Z8Fq\u000edWo]5wK2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\t\u0005\u001d\u0014Q\u0013\u0003\b\u0003\u000bZ!\u0019AA$\u0003\u001d!(/\u001f'pG.$B!a'\u0002\"B\u00191&!(\n\u0007\u0005}EFA\u0004C_>dW-\u00198\t\u0011\u0005\u0005D\u0002%AA\u0002a\u000b\u0011\u0003\u001e:z\u0019>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003\u00159\u0018\r^2i\u0001")
public class FileLock
implements StrictLogging {
    private final Path path;
    private final StorageHandler storageHandler;
    private final LockWatcher fileWatcher;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long checkinPeriod() {
        return this.storageHandler.lockAcquisitionPollTime().toMillis();
    }

    public long refreshPeriod() {
        return this.storageHandler.lockRefreshPollTime().toMillis();
    }

    private LockWatcher fileWatcher() {
        return this.fileWatcher;
    }

    public <T> Try<T> tryExclusively(long timeoutInMillis, Function0<T> op) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.doExclusively(timeoutInMillis, op));
    }

    public <T> long tryExclusively$default$1() {
        return -1L;
    }

    public <T> T doExclusively(long timeoutInMillis, Function0<T> op) {
        Object object;
        if (this.tryLock(timeoutInMillis)) {
            try {
                object = op.apply();
            }
            finally {
                this.release();
            }
        } else {
            throw new TimeoutException(new StringBuilder(47).append("Failed to obtain lock on file ").append(this.path).append(" waited (millis) ").append(timeoutInMillis).toString());
        }
        return (T)object;
    }

    public <T> long doExclusively$default$1() {
        return -1L;
    }

    public boolean tryLock(long timeoutInMillis) {
        BoxedUnit boxedUnit;
        int maxTries;
        this.fileWatcher().checkPristine();
        this.storageHandler.mkdirs(this.path.getParent());
        int n = maxTries = timeoutInMillis == -1L ? Integer.MAX_VALUE : (int)(timeoutInMillis / this.checkinPeriod());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Trying to acquire lock for file {} during {} ms", new Object[]{this.path.toString(), BoxesRunTime.boxToLong((long)timeoutInMillis)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getLock$1(maxTries);
    }

    public long tryLock$default$1() {
        return -1L;
    }

    public void release() {
        this.fileWatcher().release();
    }

    private void watch() {
        Thread th = new Thread((Runnable)this.fileWatcher(), new StringBuilder(13).append("LockWatcher-").append(System.currentTimeMillis()).append("-").append(this.path.toString()).toString());
        th.start();
    }

    private final boolean getLock$1(int numberOfTries) {
        boolean bl;
        block15: {
            block16: {
                Try<BoxedUnit> try_;
                while (true) {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    if (numberOfTries == 0) {
                        bl = false;
                        break block15;
                    }
                    try_ = this.storageHandler.touchz(this.path);
                    if (try_ instanceof Success) {
                        BoxedUnit boxedUnit3;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Succeeded to acquire lock for file {} after {} tries", new Object[]{this.path.toString(), BoxesRunTime.boxToInteger((int)numberOfTries)});
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        break block16;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Audit lock {} already in use waiting ...  {}", new Object[]{this.path.toString(), e.getMessage()});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.storageHandler.lastModified($this.path));
                    if (try_2 instanceof Success) {
                        BoxedUnit boxedUnit4;
                        Success success = (Success)try_2;
                        long lastModified = BoxesRunTime.unboxToLong((Object)success.value());
                        long currentTimeMillis = System.currentTimeMillis();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(237).append("\n                               |lastModified=").append(lastModified).append("\n                               |System.currentTimeMillis()=").append(currentTimeMillis).append("\n                               |checkinPeriod*4=").append(this.checkinPeriod() * 4L).append("\n                               |refreshPeriod*4=").append(this.refreshPeriod() * 4L).append("\n                               |").toString())).stripMargin());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit = currentTimeMillis - lastModified > this.refreshPeriod() * 4L ? BoxesRunTime.boxToBoolean((boolean)this.storageHandler.delete(this.path)) : BoxedUnit.UNIT;
                    } else if (try_2 instanceof Failure) {
                        BoxedUnit boxedUnit5;
                        Failure failure2 = (Failure)try_2;
                        Throwable e2 = failure2.exception();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("{} was deleted during access to modification date {}", new Object[]{this.path.toString(), e2.getMessage()});
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit5;
                    } else {
                        throw new MatchError((Object)try_2);
                    }
                    Thread.sleep(this.checkinPeriod());
                    --numberOfTries;
                }
                throw new MatchError(try_);
            }
            this.watch();
            boolean bl2 = true;
            bl = bl2;
        }
        return bl;
    }

    public FileLock(Path path, StorageHandler storageHandler) {
        this.path = path;
        this.storageHandler = storageHandler;
        StrictLogging.$init$((StrictLogging)this);
        this.fileWatcher = new LockWatcher(path, storageHandler, this.refreshPeriod());
    }

    public static class LockWatcher
    implements Runnable,
    StrictLogging {
        private final Path path;
        private final StorageHandler storageHandler;
        private final long reportingPeriod;
        private final AtomicBoolean pristine;
        private final AtomicBoolean spent;
        private final Semaphore sem;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private AtomicBoolean pristine() {
            return this.pristine;
        }

        public void checkPristine() {
            boolean wasPristine = this.pristine().getAndSet(false);
            if (!wasPristine) {
                throw new IllegalStateException(new StringBuilder(58).append("FileLock instance on ").append(this.path).append(" had already been used, cannot re-use").toString());
            }
        }

        private AtomicBoolean spent() {
            return this.spent;
        }

        private Semaphore sem() {
            return this.sem;
        }

        public void release() {
            boolean wasAlreadySpent = this.spent().getAndSet(true);
            if (wasAlreadySpent) {
                throw new IllegalStateException(new StringBuilder(58).append("LockWatcher thread on ").append(this.path).append(" already spent, cannot release again").toString());
            }
            this.sem().release();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    BoxedUnit boxedUnit;
                    if (this.sem().tryAcquire(this.reportingPeriod, TimeUnit.MILLISECONDS)) {
                        this.storageHandler.delete(this.path);
                        return;
                    }
                    this.storageHandler.touch(this.path);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("watcher {} modified={}", new Object[]{this.path, BoxesRunTime.boxToLong((long)this.storageHandler.lastModified(this.path))});
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }

        public LockWatcher(Path path, StorageHandler storageHandler, long reportingPeriod) {
            this.path = path;
            this.storageHandler = storageHandler;
            this.reportingPeriod = reportingPeriod;
            StrictLogging.$init$((StrictLogging)this);
            this.pristine = new AtomicBoolean(true);
            this.spent = new AtomicBoolean(false);
            this.sem = new Semaphore(0);
        }
    }
}

