/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils.conversion;

import ai.starlake.utils.repackaged.BigQuerySchemaConverters;
import com.google.cloud.bigquery.Schema;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class BigQueryUtils$ {
    public static BigQueryUtils$ MODULE$;
    private final Function1<Dataset<Row>, Schema> sparkToBq;

    static {
        new BigQueryUtils$();
    }

    public Function1<Dataset<Row>, Schema> sparkToBq() {
        return this.sparkToBq;
    }

    public Schema bqSchema(DataType schema) {
        return BigQuerySchemaConverters.toBigQuerySchema((StructType)schema);
    }

    public StructType normalizeSchema(StructType schema) {
        StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            boolean bl = false;
            ArrayType arrayType = null;
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructType x$1 = MODULE$.normalizeSchema(structType);
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, (DataType)x$1, x$3, x$4);
            }
            if (dataType instanceof ArrayType) {
                bl = true;
                arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean nullable = arrayType.containsNull();
                if (elementType instanceof StructType) {
                    StructType structType = (StructType)elementType;
                    ArrayType x$5 = new ArrayType((DataType)MODULE$.normalizeSchema(structType), nullable);
                    String x$6 = field.copy$default$1();
                    boolean x$7 = field.copy$default$3();
                    Metadata x$8 = field.copy$default$4();
                    return field.copy(x$6, (DataType)x$5, x$7, x$8);
                }
            }
            if (bl) {
                boolean nullable = arrayType.containsNull();
                if (arrayType.elementType() instanceof IntegerType) {
                    ArrayType x$9 = new ArrayType((DataType)LongType$.MODULE$, nullable);
                    String x$10 = field.copy$default$1();
                    boolean x$11 = field.copy$default$3();
                    Metadata x$12 = field.copy$default$4();
                    return field.copy(x$10, (DataType)x$9, x$11, x$12);
                }
            }
            if (!IntegerType$.MODULE$.equals(dataType)) return field;
            LongType$ x$13 = LongType$.MODULE$;
            String x$14 = field.copy$default$1();
            boolean x$15 = field.copy$default$3();
            Metadata x$16 = field.copy$default$4();
            return field.copy(x$14, (DataType)x$13, x$15, x$16);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return schema.copy(fields);
    }

    public List<String> computePartitionsToUpdateAfterMerge(Dataset<Row> mergedDF, Dataset<Row> toDeleteDF, String timestamp) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mergedDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(timestamp)})).union(toDeleteDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(timestamp)}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_format(functions$.MODULE$.col(timestamp), "yyyyMMdd").cast("string")})).where(functions$.MODULE$.col(timestamp).isNotNull()).distinct().collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
    }

    private BigQueryUtils$() {
        MODULE$ = this;
        this.sparkToBq = (Function1 & Serializable & scala.Serializable)df -> MODULE$.bqSchema((DataType)df.schema());
    }
}

