/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.http;

import ai.starlake.job.sink.http.HttpSinkClient;
import ai.starlake.job.sink.http.SinkTransformer;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Set;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001q4AAC\u0006\u0001-!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!a\u0005A!A!\u0002\u0013A\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00119\u0003!\u0011!Q\u0001\n=CQa\u0015\u0001\u0005\u0002QCqa\u0017\u0001C\u0002\u0013\u0005A\f\u0003\u0004a\u0001\u0001\u0006I!\u0018\u0005\u0006C\u0002!\tE\u0019\u0002\n\u0011R$H\u000f]*j].T!\u0001D\u0007\u0002\t!$H\u000f\u001d\u0006\u0003\u001d=\tAa]5oW*\u0011\u0001#E\u0001\u0004U>\u0014'B\u0001\n\u0014\u0003!\u0019H/\u0019:mC.,'\"\u0001\u000b\u0002\u0005\u0005L7\u0001A\n\u0005\u0001]yr\u0006\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\t\u0001S&D\u0001\"\u0015\t\u00113%A\u0005tiJ,\u0017-\\5oO*\u0011A%J\u0001\nKb,7-\u001e;j_:T!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0013\tq\u0013E\u0001\u0003TS:\\\u0007C\u0001\u00198\u001b\u0005\t$B\u0001\u001a4\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t!T'\u0001\u0005usB,7/\u00194f\u0015\u00051\u0014aA2p[&\u0011\u0001(\r\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u0007U\u0014H\u000e\u0005\u0002<\t:\u0011AH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fU\ta\u0001\u0010:p_Rt$\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011!\u0002\u00175\f\u00070T3tg\u0006<Wm\u001d\t\u0003\u0013*k\u0011\u0001Q\u0005\u0003\u0017\u0002\u00131!\u00138u\u0003)qW/\u001c*fiJLWm]\u0001\u000ee\u0016$(/_%oi\u0016\u0014h/\u00197\u0002\u0017Q\u0014\u0018M\\:g_JlWM\u001d\t\u0003!Fk\u0011aC\u0005\u0003%.\u0011qbU5oWR\u0013\u0018M\\:g_JlWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\rU3v\u000bW-[!\t\u0001\u0006\u0001C\u0003:\r\u0001\u0007!\bC\u0003H\r\u0001\u0007\u0001\nC\u0003M\r\u0001\u0007\u0001\nC\u0003N\r\u0001\u0007\u0001\nC\u0003O\r\u0001\u0007q*\u0001\u0004dY&,g\u000e^\u000b\u0002;B\u0011\u0001KX\u0005\u0003?.\u0011a\u0002\u0013;uaNKgn[\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002\u0011\u0005$GMQ1uG\"$2a\u00194l!\tIE-\u0003\u0002f\u0001\n!QK\\5u\u0011\u00159\u0017\u00021\u0001i\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\u0004\"!S5\n\u0005)\u0004%\u0001\u0002'p]\u001eDQ\u0001\\\u0005A\u00025\fA\u0001Z1uCB\u0011a.\u001f\b\u0003_^t!\u0001\u001d<\u000f\u0005E,hB\u0001:u\u001d\ti4/C\u0001-\u0013\tQ3&\u0003\u0002)S%\u0011aeJ\u0005\u0003q\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002{w\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003q\u0016\u0002")
public class HtttpSink
implements Sink,
StrictLogging {
    private final int numRetries;
    private final int retryInterval;
    private final HttpSinkClient client;
    private final Logger logger;

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public HttpSinkClient client() {
        return this.client;
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        BooleanRef success = BooleanRef.create((boolean)false);
        IntRef retried = IntRef.create((int)0);
        while (!success.elem && retried.elem < this.numRetries) {
            BoxedUnit boxedUnit;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ++retried$1.elem;
                this.client().send(data);
                success$1.elem = true;
            });
            if (try_ instanceof Failure) {
                int sleepTime;
                BoxedUnit boxedUnit2;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                success.elem = false;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(Utils$.MODULE$.exceptionAsString(e));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (retried.elem < this.numRetries) {
                    BoxedUnit boxedUnit3;
                    sleepTime = this.retryInterval * retried.elem;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("will retry to send after {}ms", new Object[]{BoxesRunTime.boxToInteger((int)sleepTime)});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    throw e;
                }
                Thread.sleep(sleepTime);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (try_ instanceof Success) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public HtttpSink(String url, int maxMessages, int numRetries, int retryInterval, SinkTransformer transformer) {
        this.numRetries = numRetries;
        this.retryInterval = retryInterval;
        Sink.$init$((Sink)this);
        StrictLogging.$init$((StrictLogging)this);
        this.client = new HttpSinkClient(url, maxMessages, transformer);
    }
}

