/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.jdbc;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.job.sink.jdbc.ConnectionLoadConfig;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.JobInfo;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r4AAC\u0006\u0001-!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0015\r\u0011b\u0001*\u0011!\u0001\u0004A!A!\u0002\u0013Q\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\u001c\u0001\t\u0003B\u0004b\u0002#\u0001\u0005\u0004%\t!\u0012\u0005\u0007#\u0002\u0001\u000b\u0011\u0002$\t\u000bI\u0003A\u0011A*\t\u000bu\u0003A\u0011\t0\u0003#\r{gN\\3di&|g\u000eT8bI*{'M\u0003\u0002\r\u001b\u0005!!\u000e\u001a2d\u0015\tqq\"\u0001\u0003tS:\\'B\u0001\t\u0012\u0003\rQwN\u0019\u0006\u0003%M\t\u0001b\u001d;be2\f7.\u001a\u0006\u0002)\u0005\u0011\u0011-[\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\n\u0012!B;uS2\u001c\u0018B\u0001\u0012 \u0005!\u0019\u0006/\u0019:l\u0015>\u0014\u0017!C2mS\u000e{gNZ5h!\t)c%D\u0001\f\u0013\t93B\u0001\u000bD_:tWm\u0019;j_:du.\u00193D_:4\u0017nZ\u0001\tg\u0016$H/\u001b8hgV\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002.#\u000511m\u001c8gS\u001eL!a\f\u0017\u0003\u0011M+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\rqJg.\u001b;?)\t\u0019d\u0007\u0006\u00025kA\u0011Q\u0005\u0001\u0005\u0006Q\u0011\u0001\u001dA\u000b\u0005\u0006G\u0011\u0001\r\u0001J\u0001\u0005]\u0006lW-F\u0001:!\tQ\u0014I\u0004\u0002<\u007fA\u0011A(G\u0007\u0002{)\u0011a(F\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001K\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\r\u0002\t\r|gNZ\u000b\u0002\rB\u0011qiT\u0007\u0002\u0011*\u0011A)\u0013\u0006\u0003\u0015.\u000ba\u0001[1e_>\u0004(B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001\u0015%\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0015\u0019wN\u001c4!\u0003\u001d\u0011XO\u001c&E\u0005\u000e#\u0012\u0001\u0016\t\u0004+bSV\"\u0001,\u000b\u0005]K\u0012\u0001B;uS2L!!\u0017,\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u001f7&\u0011Al\b\u0002\u000f'B\f'o\u001b&pEJ+7/\u001e7u\u0003\r\u0011XO\u001c\u000b\u0002?B\u0019Q\u000b\u00171\u0011\u0005y\t\u0017B\u00012 \u0005%QuN\u0019*fgVdG\u000f")
public class ConnectionLoadJob
implements SparkJob {
    private final ConnectionLoadConfig cliConfig;
    private final Settings settings;
    private final Configuration conf;
    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv;
    private SparkSession session;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        return SparkJob.withExtraSparkConf$(this, sourceConfig);
    }

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionedDatasetWriter$(this, dataset, partition);
    }

    @Override
    public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionDataset$(this, dataset, partition);
    }

    @Override
    public Object analyze(String fullTableName) {
        return SparkJob.analyze$(this, fullTableName);
    }

    @Override
    public void createSparkViews(Views views, Map<String, String> activeEnv, Map<String, String> sqlParameters) {
        SparkJob.createSparkViews$(this, views, activeEnv, sqlParameters);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$lzycompute() {
        ConnectionLoadJob connectionLoadJob = this;
        synchronized (connectionLoadJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ai$starlake$utils$SparkJob$$sparkEnv = SparkJob.ai$starlake$utils$SparkJob$$sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    @Override
    public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ai$starlake$utils$SparkJob$$sparkEnv$lzycompute() : this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    private SparkSession session$lzycompute() {
        ConnectionLoadJob connectionLoadJob = this;
        synchronized (connectionLoadJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(14).append("jdbcload-JDBC-").append(this.cliConfig.outputTable()).toString();
    }

    public Configuration conf() {
        return this.conf;
    }

    public Try<SparkJobResult> runJDBC() {
        BoxedUnit boxedUnit;
        Either<String, Dataset<Row>> inputPath = this.cliConfig.sourceFile();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Input path {}", new Object[]{inputPath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataset;
            Either either = inputPath;
            if (either instanceof Left) {
                Left left = (Left)either;
                String path = (String)left.value();
                dataset = this.session().read().format(this.settings().comet().defaultFormat()).load(path);
            } else if (either instanceof Right) {
                Dataset df;
                Right right = (Right)either;
                dataset = df = (Dataset)right.value();
            } else {
                throw new MatchError((Object)either);
            }
            Dataset sourceDF = dataset;
            JobInfo.WriteDisposition writeDisposition = $this.cliConfig.writeDisposition();
            JobInfo.WriteDisposition writeDisposition2 = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            SaveMode writeMode = !(writeDisposition != null ? !writeDisposition.equals(writeDisposition2) : writeDisposition2 != null) ? SaveMode.Overwrite : SaveMode.Append;
            JobInfo.WriteDisposition writeDisposition3 = $this.cliConfig.writeDisposition();
            JobInfo.WriteDisposition writeDisposition4 = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            DataFrameWriter dfw = sourceDF.write().format($this.cliConfig.format()).option("truncate", !(writeDisposition3 != null ? !writeDisposition3.equals(writeDisposition4) : writeDisposition4 != null)).option("dbtable", $this.cliConfig.outputTable()).mode((String)$this.cliConfig.mode().getOrElse((Function0 & Serializable & scala.Serializable)() -> writeMode.toString()));
            dfw.options($this.cliConfig.options()).save();
            return new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$);
        });
    }

    @Override
    public Try<JobResult> run() {
        Try<SparkJobResult> res = this.runJDBC();
        return Utils$.MODULE$.logFailure(res, this.logger());
    }

    public ConnectionLoadJob(ConnectionLoadConfig cliConfig, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
        this.conf = this.session().sparkContext().hadoopConfiguration();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JDBC Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

