/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.StorageArea;
import ai.starlake.config.StorageArea$;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AssertionDefinition;
import ai.starlake.schema.model.AssertionDefinitions;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Env;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.SqlTaskExtractor;
import ai.starlake.schema.model.SqlTaskExtractor$;
import ai.starlake.schema.model.Type;
import ai.starlake.schema.model.Types;
import ai.starlake.schema.model.Views;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.CometObjectMapper;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.YamlSerializer$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map;^Ljava.lang.Exception;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0006{!)1\t\u0001C\u0001\t\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB1\u0001A\u0003%1\nC\u0003c\u0001\u0011\u00051\rC\u0004\u00020\u0001!\t!!\r\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!Q\u00111\f\u0001\t\u0006\u0004%\t!!\u0018\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAI\u0001\u0011%\u00111\u0013\u0005\b\u0003o\u0003A\u0011BA]\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!!3\u0001\t\u0003\tY\rC\u0005\u0002^\u0002\t\n\u0011\"\u0001\u0002`\"Q\u0011Q\u001f\u0001\t\u0006\u0004%\t!a>\t\u0013\t\u0015\u0001A1A\u0005\n\t\u001d\u0001\u0002\u0003B\u0013\u0001\u0001\u0006IA!\u0003\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!Q!\u0011\u0007\u0001\t\u0006\u0004%\tAa\r\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!\u0011\r\u0001\u0005\n\t\r\u0004B\u0003B5\u0001!\u0015\r\u0011\"\u0001\u0003l!9!1\u0010\u0001\u0005\u0002\tu\u0004b\u0002BB\u0001\u0011\u0005!Q\u0011\u0005\b\u0005'\u0003A\u0011\u0001BK\u00055\u00196\r[3nC\"\u000bg\u000e\u001a7fe*\u0011adH\u0001\tQ\u0006tG\r\\3sg*\u0011\u0001%I\u0001\u0007g\u000eDW-\\1\u000b\u0005\t\u001a\u0013\u0001C:uCJd\u0017m[3\u000b\u0003\u0011\n!!Y5\u0004\u0001M\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tqS'D\u00010\u0015\t\u0001\u0014'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00023g\u0005AA/\u001f9fg\u00064WMC\u00015\u0003\r\u0019w.\\\u0005\u0003m=\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017aB:u_J\fw-\u001a\t\u0003sij\u0011!H\u0005\u0003wu\u0011ab\u0015;pe\u0006<W\rS1oI2,'/\u0001\u0005tKR$\u0018N\\4t!\tq\u0014)D\u0001@\u0015\t\u0001\u0015%\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0005~\u0012\u0001bU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0015CEC\u0001$H!\tI\u0004\u0001C\u0003=\u0007\u0001\u000fQ\bC\u00038\u0007\u0001\u0007\u0001(\u0001\u0004nCB\u0004XM]\u000b\u0002\u0017J\u0019AJ\u0014-\u0007\t5\u0003\u0001a\u0013\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003'R\u000bqA[1dWN|gN\u0003\u0002Vg\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003/B\u0013Ab\u00142kK\u000e$X*\u00199qKJ\u0004\"!W0\u000e\u0003iS!a\u0017/\u0002\u0019\u0015D\b/\u001a:j[\u0016tG/\u00197\u000b\u0005)j&B\u00010S\u0003\u0019iw\u000eZ;mK&\u0011\u0001M\u0017\u0002\u0012'\u000e\fG.Y(cU\u0016\u001cG/T1qa\u0016\u0014\u0018aB7baB,'\u000fI\u0001\u000eG\",7m\u001b,bY&$\u0017\u000e^=\u0015\u0003\u0011\u0004\"\u0001K3\n\u0005\u0019L#\u0001B+oSRD3A\u00025x!\rA\u0013n[\u0005\u0003U&\u0012a\u0001\u001e5s_^\u001c\bC\u00017u\u001d\ti'O\u0004\u0002oc6\tqN\u0003\u0002qK\u00051AH]8pizJ\u0011AK\u0005\u0003g&\nq\u0001]1dW\u0006<W-\u0003\u0002vm\nIQ\t_2faRLwN\u001c\u0006\u0003g&\ndA\b=\u0002\u0002\u00055\u0002CA=~\u001d\tQ8\u0010\u0005\u0002oS%\u0011A0K\u0001\u0007!J,G-\u001a4\n\u0005y|(AB*ue&twM\u0003\u0002}SEJ1%a\u0001\u0002\f\u0005\r\u0012QB\u000b\u0005\u0003\u000b\t9!F\u0001y\t\u001d\tI!\nb\u0001\u0003'\u0011\u0011\u0001V\u0005\u0005\u0003\u001b\ty!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003#I\u0013A\u0002;ie><8/\u0005\u0003\u0002\u0016\u0005m\u0001c\u0001\u0015\u0002\u0018%\u0019\u0011\u0011D\u0015\u0003\u000f9{G\u000f[5oOB!\u0011QDA\u0010\u001d\tA#/C\u0002\u0002\"Y\u0014\u0011\u0002\u00165s_^\f'\r\\32\u0013\r\n)#a\n\u0002*\u0005Eab\u0001\u0015\u0002(%\u0019\u0011\u0011C\u00152\u000b\tB\u0013&a\u000b\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019Z\u0017AE2iK\u000e\\g+[3xgZ\u000bG.\u001b3jif$\"!a\r\u0011\u000f1\f)$!\u000f\u0002@%\u0019\u0011q\u0007<\u0003\r\u0015KG\u000f[3s!\u0011a\u00171\b=\n\u0007\u0005ubO\u0001\u0003MSN$\bc\u0001\u0015\u0002B%\u0019\u00111I\u0015\u0003\u000f\t{w\u000e\\3b]\u0006IAn\\1e)f\u0004Xm\u001d\u000b\u0005\u0003\u0013\n9\u0006E\u0003m\u0003w\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tfH\u0001\u0006[>$W\r\\\u0005\u0005\u0003+\nyE\u0001\u0003UsB,\u0007BBA-\u0011\u0001\u0007\u00010\u0001\u0005gS2,g.Y7f\u0003\u0015!\u0018\u0010]3t+\t\tI\u0005\u000b\u0003\nQ\u0006\u0005\u0014G\u0002\u0010y\u0003G\nI'M\u0005$\u0003\u0007\tY!!\u001a\u0002\u000eEJ1%!\n\u0002(\u0005\u001d\u0014\u0011C\u0019\u0006E!J\u00131F\u0019\u0003M-\fa\u0002\\8bI\u0006\u001b8/\u001a:uS>t7\u000f\u0006\u0003\u0002p\u0005m\u0004CB=\u0002ra\f)(C\u0002\u0002t}\u00141!T1q!\u0011\ti%a\u001e\n\t\u0005e\u0014q\n\u0002\u0014\u0003N\u001cXM\u001d;j_:$UMZ5oSRLwN\u001c\u0005\u0007\u00033R\u0001\u0019\u0001=\u0002\u0015\u0005\u001c8/\u001a:uS>t7\u000f\u0006\u0003\u0002p\u0005\u0005\u0005BBAB\u0017\u0001\u0007\u00010\u0001\u0003oC6,\u0007\u0006B\u0006i\u0003\u000f\u000bdA\b=\u0002\n\u0006=\u0015'C\u0012\u0002\u0004\u0005-\u00111RA\u0007c%\u0019\u0013QEA\u0014\u0003\u001b\u000b\t\"M\u0003#Q%\nY#\r\u0002'W\u0006YAn\\1e'Fdg)\u001b7f)\u0011\t)*a'\u0011\u000b!\n9\n\u001f=\n\u0007\u0005e\u0015F\u0001\u0004UkBdWM\r\u0005\b\u0003;c\u0001\u0019AAP\u0003\u001d\u0019\u0018\u000f\u001c$jY\u0016\u0004B!!)\u000246\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0002gg*!\u0011\u0011VAV\u0003\u0019A\u0017\rZ8pa*!\u0011QVAX\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011W\u0001\u0004_J<\u0017\u0002BA[\u0003G\u0013A\u0001U1uQ\u0006aAn\\1e'Fdg)\u001b7fgR!\u00111XA_!\u0015I\u0018\u0011\u000f=y\u0011\u001d\ty,\u0004a\u0001\u0003?\u000bA\u0001]1uQ\u0006aAn\\1e'Fdg+[3xgR!\u00111XAc\u0011\u001d\t9M\u0004a\u0001\u0003?\u000b\u0011B^5foN\u0004\u0016\r\u001e5\u0002\u000bYLWm^:\u0015\t\u00055\u00171\u001b\t\u0005\u0003\u001b\ny-\u0003\u0003\u0002R\u0006=#!\u0002,jK^\u001c\b\"CAk\u001fA\u0005\t\u0019AAl\u0003!1\u0018.Z<OC6,\u0007\u0003\u0002\u0015\u0002ZbL1!a7*\u0005\u0019y\u0005\u000f^5p]\u0006ya/[3xg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b*\"\u0011q[ArW\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\u0013Ut7\r[3dW\u0016$'bAAxS\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!C1di&4X-\u00128w+\t\tY\f\u000b\u0003\u0012Q\u0006m\u0018G\u0002\u0010y\u0003{\u0014\u0019!M\u0005$\u0003\u0007\tY!a@\u0002\u000eEJ1%!\n\u0002(\t\u0005\u0011\u0011C\u0019\u0006E!J\u00131F\u0019\u0003M-\fQbY8nKR$\u0015\r^3WCJ\u001cXC\u0001B\u0005!!\u0011YA!\u0006\u0003\u0018\t]QB\u0001B\u0007\u0015\u0011\u0011yA!\u0005\u0002\u0013%lW.\u001e;bE2,'b\u0001B\nS\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M$Q\u0002\t\u0005\u00053\u0011\u0019#\u0004\u0002\u0003\u001c)!!Q\u0004B\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\t\u0005\u0012\u0001\u00026bm\u0006L1A B\u000e\u00039\u0019w.\\3u\t\u0006$XMV1sg\u0002\nqaZ3u)f\u0004X\r\u0006\u0003\u0003,\t5\u0002#\u0002\u0015\u0002Z\u0006-\u0003B\u0002B\u0018)\u0001\u0007\u00010A\u0002ua\u0016\fq\u0001Z8nC&t7/\u0006\u0002\u00036A)A.a\u000f\u00038A!\u0011Q\nB\u001d\u0013\u0011\u0011Y$a\u0014\u0003\r\u0011{W.Y5oQ\u0011)\u0002Na\u00102\ryA(\u0011\tB$c%\u0019\u00131AA\u0006\u0005\u0007\ni!M\u0005$\u0003K\t9C!\u0012\u0002\u0012E*!\u0005K\u0015\u0002,E\u0012ae[\u0001\u0010Y>\fGMS8c\rJ|WNR5mKR!!Q\nB0!\u0019\u0011yE!\u0016\u0003Z5\u0011!\u0011\u000b\u0006\u0004\u0005'J\u0013\u0001B;uS2LAAa\u0016\u0003R\t\u0019AK]=\u0011\t\u00055#1L\u0005\u0005\u0005;\nyEA\u0006BkR|'j\u001c2EKN\u001c\u0007bBA`-\u0001\u0007\u0011qT\u0001\u0015M&t\u0017\r\u001c#p[\u0006Lgn\u0014:K_\nt\u0015-\\3\u0015\r\t]!Q\rB4\u0011\u001d\tyl\u0006a\u0001\u0003?Ca!a!\u0018\u0001\u0004A\u0018\u0001\u00026pEN,\"A!\u001c\u0011\re\f\t\b\u001fB-Q\u0011A\u0002N!\u001d2\ryA(1\u000fB=c%\u0019\u00131AA\u0006\u0005k\ni!M\u0005$\u0003K\t9Ca\u001e\u0002\u0012E*!\u0005K\u0015\u0002,E\u0012ae[\u0001\nO\u0016$Hi\\7bS:$BAa \u0003\u0002B)\u0001&!7\u00038!1\u00111Q\rA\u0002a\f!bZ3u'\u000eDW-\\1t)\u0011\u00119Ia$\u0011\u000b1\fYD!#\u0011\t\u00055#1R\u0005\u0005\u0005\u001b\u000byE\u0001\u0004TG\",W.\u0019\u0005\u0007\u0005#S\u0002\u0019\u0001=\u0002\r\u0011|W.Y5o\u0003%9W\r^*dQ\u0016l\u0017\r\u0006\u0004\u0003\u0018\ne%Q\u0014\t\u0006Q\u0005e'\u0011\u0012\u0005\u0007\u00057[\u0002\u0019\u0001=\u0002\u0015\u0011|W.Y5o\u001d\u0006lW\r\u0003\u0004\u0003 n\u0001\r\u0001_\u0001\u000bg\u000eDW-\\1OC6,\u0007")
public class SchemaHandler
implements StrictLogging {
    private scala.collection.immutable.List;^Ljava.lang.Exception types;
    private Exception activeEnv;
    private scala.collection.immutable.List;^Ljava.lang.Exception domains;
    private Exception jobs;
    private final StorageHandler storage;
    private final Settings settings;
    private final ObjectMapper mapper;
    private final Map<String, String> cometDateVars;
    private final Logger logger;
    private volatile byte bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void checkValidity() throws java.lang.Exception {
        List errs;
        List typesValidity = (List)this.types().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.checkValidity(), List$.MODULE$.canBuildFrom());
        List domainsValidty = (List)this.domains().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.checkValidity(this, $this.settings), List$.MODULE$.canBuildFrom());
        this.activeEnv();
        this.jobs();
        List allErrors = (List)((SeqLike)typesValidity.$plus$plus((GenTraversableOnce)domainsValidty, List$.MODULE$.canBuildFrom())).$colon$plus(this.checkViewsValidity(), List$.MODULE$.canBuildFrom());
        List list = errs = (List)allErrors.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Nil$ nil$;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                List values = (List)left.value();
                nil$ = values;
            } else if (either instanceof Right) {
                nil$ = Nil$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            return nil$;
        }, List$.MODULE$.canBuildFrom());
        if (!Nil$.MODULE$.equals(list)) {
            errs.foreach((Function1 & Serializable & scala.Serializable)err -> {
                SchemaHandler.$anonfun$checkValidity$4(this, err);
                return BoxedUnit.UNIT;
            });
            throw new java.lang.Exception("Invalid YML file(s) found. See errors above.");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Either<List<String>, Object> checkViewsValidity() {
        Path viewsPath;
        MutableList errorList = (MutableList)MutableList$.MODULE$.empty();
        Path x$1 = viewsPath = DatasetArea$.MODULE$.views(this.settings);
        String x$2 = ".sql";
        boolean x$3 = true;
        LocalDateTime x$42 = this.storage.list$default$3();
        Option<Pattern> x$5 = this.storage.list$default$5();
        List<Path> sqlFiles = this.storage.list(x$1, x$2, x$42, x$3, x$5);
        Map duplicates = (Map)sqlFiles.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$checkViewsValidity$2(x0$1)));
        duplicates.foreach((Function1 & Serializable & scala.Serializable)duplicate -> errorList.$plus$eq((Object)new StringBuilder(25).append("Found duplicate views => ").append(duplicate).toString()));
        return errorList.nonEmpty() ? package$.MODULE$.Left().apply((Object)errorList.toList()) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public List<Type> loadTypes(String filename) {
        Path deprecatedTypesPath = new Path(DatasetArea$.MODULE$.types(this.settings), new StringBuilder(4).append(filename).append(".yml").toString());
        Path typesCometPath = new Path(DatasetArea$.MODULE$.types(this.settings), new StringBuilder(10).append(filename).append(".comet.yml").toString());
        return this.storage.exists(typesCometPath) ? ((Types)this.mapper().readValue(this.storage.read(typesCometPath), Types.class)).types() : (this.storage.exists(deprecatedTypesPath) ? ((Types)this.mapper().readValue(this.storage.read(deprecatedTypesPath), Types.class)).types() : List$.MODULE$.empty());
    }

    private List<Type> types$lzycompute() {
        SchemaHandler schemaHandler = this;
        synchronized (schemaHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                List<Type> defaultTypes = this.loadTypes("default");
                List<Type> types = this.loadTypes("types");
                List redefinedTypeNames = (List)((SeqLike)defaultTypes.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom())).intersect((GenSeq)types.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), List$.MODULE$.canBuildFrom()));
                this.types = (List)((List)defaultTypes.filter((Function1 & Serializable & scala.Serializable)defaultType -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$types$3(redefinedTypeNames, defaultType)))).$plus$plus(types, List$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.types;
    }

    public List<Type> types() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.types$lzycompute() : this.types;
    }

    public Map<String, AssertionDefinition> loadAssertions(String filename) {
        Map<String, AssertionDefinition> map;
        BoxedUnit boxedUnit;
        Path assertionsPath = new Path(DatasetArea$.MODULE$.assertions(this.settings), filename);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Loading assertions {}", new Object[]{assertionsPath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.storage.exists(assertionsPath)) {
            BoxedUnit boxedUnit2;
            String content = Formatter$.MODULE$.RichFormatter(this.storage.read(assertionsPath)).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), this.settings);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("reading content {}", new Object[]{content});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            map = ((AssertionDefinitions)this.mapper().readValue(content, AssertionDefinitions.class)).assertionDefinitions();
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Map<String, AssertionDefinition> assertions(String name) throws java.lang.Exception {
        Map<String, AssertionDefinition> defaultAssertions = this.loadAssertions("default.comet.yml");
        Map<String, AssertionDefinition> assertions = this.loadAssertions("assertions.comet.yml");
        Map<String, AssertionDefinition> resAssertions = this.loadAssertions(new StringBuilder(10).append(name).append(".comet.yml").toString());
        return defaultAssertions.$plus$plus(assertions).$plus$plus(resAssertions);
    }

    private Tuple2<String, String> loadSqlFile(Path sqlFile) {
        String sqlExpr = Formatter$.MODULE$.RichFormatter(this.storage.read(sqlFile)).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), this.settings);
        String sqlFilename = (String)new StringOps(Predef$.MODULE$.augmentString(sqlFile.getName())).dropRight(".sql".length());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sqlFilename), (Object)sqlExpr);
    }

    private Map<String, String> loadSqlFiles(Path path) {
        Path x$1 = path;
        String x$2 = ".sql";
        boolean x$3 = true;
        LocalDateTime x$4 = this.storage.list$default$3();
        Option<Pattern> x$5 = this.storage.list$default$5();
        List<Path> sqlFiles = this.storage.list(x$1, x$2, x$4, x$3, x$5);
        return ((TraversableOnce)sqlFiles.map((Function1 & Serializable & scala.Serializable)sqlFile -> this.loadSqlFile((Path)sqlFile), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> loadSqlViews(Path viewsPath) {
        void var2_2;
        Map<String, String> sqlViews = this.loadSqlFiles(viewsPath);
        sqlViews.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaHandler.$anonfun$loadSqlViews$1(x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Views views(Option<String> viewName2) {
        Path viewsPath = (Path)viewName2.map((Function1 & Serializable & scala.Serializable)viewName -> DatasetArea$.MODULE$.views((String)viewName, $this.settings)).getOrElse((Function0 & Serializable & scala.Serializable)() -> DatasetArea$.MODULE$.views($this.settings));
        Map<String, String> viewMap = this.loadSqlViews(viewsPath);
        return new Views(viewMap);
    }

    public Option<String> views$default$1() {
        return None$.MODULE$;
    }

    private Map<String, String> activeEnv$lzycompute() {
        SchemaHandler schemaHandler = this;
        synchronized (schemaHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Path globalsCometPath = new Path(DatasetArea$.MODULE$.metadata(this.settings), "env.comet.yml");
                Path envsCometPath = new Path(DatasetArea$.MODULE$.metadata(this.settings), new StringBuilder(14).append("env.").append(this.settings.comet().env()).append(".comet.yml").toString());
                Map globalEnv = this.loadEnv$1(globalsCometPath).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> Formatter$.MODULE$.RichFormatter((String)x$7).richFormat((Map<String, String>)scala.sys.package$.MODULE$.env(), this.cometDateVars(), $this.settings));
                Map localEnv = this.loadEnv$1(envsCometPath).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> Formatter$.MODULE$.RichFormatter((String)x$8).richFormat((Map<String, String>)scala.sys.package$.MODULE$.env(), (Map<String, String>)globalEnv.$plus$plus(this.cometDateVars()), $this.settings));
                this.activeEnv = this.cometDateVars().$plus$plus((GenTraversableOnce)globalEnv).$plus$plus((GenTraversableOnce)localEnv);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.activeEnv;
    }

    public Map<String, String> activeEnv() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.activeEnv$lzycompute() : this.activeEnv;
    }

    private Map<String, String> cometDateVars() {
        return this.cometDateVars;
    }

    public Option<Type> getType(String tpe) {
        return this.types().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$getType$1(tpe, x$9)));
    }

    private List<Domain> domains$lzycompute() {
        SchemaHandler schemaHandler = this;
        synchronized (schemaHandler) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Path x$1 = DatasetArea$.MODULE$.domains(this.settings);
                String x$2 = ".yml";
                boolean x$3 = true;
                Some x$4 = new Some((Object)Pattern.compile("_.*"));
                LocalDateTime x$5 = this.storage.list$default$3();
                Tuple2 tuple2 = ((TraversableLike)this.storage.list(x$1, x$2, x$5, x$3, (Option<Pattern>)x$4).map((Function1 & Serializable & scala.Serializable)path -> {
                    Failure failure;
                    Try<Domain> domain = YamlSerializer$.MODULE$.deserializeDomain(Formatter$.MODULE$.RichFormatter($this.storage.read((Path)path)).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), path.toString());
                    Try<Domain> try_ = domain;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Domain domain2 = (Domain)success.value();
                        Path folder = path.getParent();
                        List schemaRefs = (List)((List)((List)domain2.schemaRefs().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)ref -> {
                            if (!ref.startsWith("_")) {
                                throw new java.lang.Exception(new StringBuilder(74).append("reference to a schema should start with '_' in domain ").append(domain2.name()).append(" in ").append(path).append(" for schema ref ").append((String)ref).toString());
                            }
                            String refFullName = ref.endsWith(".yml") || ref.endsWith(".yaml") ? ref : new StringBuilder(10).append((String)ref).append(".comet.yml").toString();
                            Path schemaPath = new Path(folder, refFullName);
                            return YamlSerializer$.MODULE$.deserializeSchemas(Formatter$.MODULE$.RichFormatter($this.storage.read(schemaPath)).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), schemaPath.toString());
                        }, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.schemas(), List$.MODULE$.canBuildFrom());
                        List list = (List)Option$.MODULE$.apply(domain2.schemas()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                        List x$6 = schemaRefs.$colon$colon$colon(list);
                        String x$7 = domain2.copy$default$1();
                        Option<String> x$8 = domain2.copy$default$2();
                        Option<Metadata> x$9 = domain2.copy$default$3();
                        Option<List<String>> x$102 = domain2.copy$default$4();
                        Option<String> x$11 = domain2.copy$default$6();
                        Option<List<String>> x$12 = domain2.copy$default$7();
                        Option<String> x$13 = domain2.copy$default$8();
                        Option<Set<String>> x$14 = domain2.copy$default$9();
                        Option<String> x$15 = domain2.copy$default$10();
                        failure = new Success((Object)domain2.copy(x$7, x$8, x$9, x$102, (List<Schema>)x$6, x$11, x$12, x$13, x$14, x$15));
                    } else if (try_ instanceof Failure) {
                        Failure failure2 = (Failure)try_;
                        Throwable e = failure2.exception();
                        Utils$.MODULE$.logException(this.logger(), e);
                        failure = new Failure(e);
                    } else {
                        throw new MatchError(try_);
                    }
                    return failure;
                }, List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isSuccess()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List validDomainsFile = (List)tuple2._1();
                List invalidDomainsFiles = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)validDomainsFile, (Object)invalidDomainsFiles);
                Tuple2 tuple23 = tuple22;
                List validDomainsFile2 = (List)tuple23._1();
                List invalidDomainsFiles2 = (List)tuple23._2();
                invalidDomainsFiles2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SchemaHandler.$anonfun$domains$7(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                List domains = (List)validDomainsFile2.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Try<Domain>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof Success) {
                            Success success = (Success)A1;
                            Domain domain = (Domain)success.value();
                            object = domain;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Try<Domain> x1) {
                        Try<Domain> try_ = x1;
                        boolean bl = try_ instanceof Success;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom());
                Either<List<String>, Object> either = Utils$.MODULE$.duplicates((List<String>)((List)domains.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), List$.MODULE$.canBuildFrom())), "%s is defined %d times. A domain can only be defined once.");
                if (!(either instanceof Right)) {
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        List errors = (List)left.value();
                        errors.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                            SchemaHandler.$anonfun$domains$9(this, x$15);
                            return BoxedUnit.UNIT;
                        });
                        throw new java.lang.Exception("Duplicated domain name(s)");
                    }
                    throw new MatchError(either);
                }
                List list = domains;
                Either<List<String>, Object> either2 = Utils$.MODULE$.duplicates((List<String>)((List)domains.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.resolveDirectory(), List$.MODULE$.canBuildFrom())), "%s is defined %d times. A directory can only appear once in a domain definition file.");
                if (!(either2 instanceof Right)) {
                    if (either2 instanceof Left) {
                        Left left = (Left)either2;
                        List errors = (List)left.value();
                        errors.foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                            SchemaHandler.$anonfun$domains$11(this, x$17);
                            return BoxedUnit.UNIT;
                        });
                        throw new java.lang.Exception("Duplicated domain directory name");
                    }
                    throw new MatchError(either2);
                }
                List list2 = domains;
                this.domains = list2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.domains;
    }

    public List<Domain> domains() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.domains$lzycompute() : this.domains;
    }

    public Try<AutoJobDesc> loadJobFromFile(Path path) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            JsonNode jsonNode;
            JsonNode rootNode = this.mapper().readTree(Formatter$.MODULE$.RichFormatter($this.storage.read(path)).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings));
            JsonNode tranformNode = rootNode.path("transform");
            if (tranformNode.isNull() || tranformNode.isMissingNode()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Defining a autojob outside a transform node is now deprecated. Please update definition {}", new Object[]{path});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                jsonNode = rootNode;
            } else {
                jsonNode = tranformNode;
            }
            JsonNode autojobNode = jsonNode;
            AutoJobDesc jobDesc = (AutoJobDesc)this.mapper().treeToValue((TreeNode)autojobNode, AutoJobDesc.class);
            String sqlFilePrefix = path.toString().substring(0, path.toString().length() - ".comet.yml".length());
            List tasks = (List)jobDesc.tasks().map((Function1 & Serializable & scala.Serializable)taskDesc -> {
                AutoTaskDesc autoTaskDesc;
                Path path;
                Option<String> option = taskDesc.name();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String taskName = (String)some.value();
                    path = new Path(new StringBuilder(5).append(sqlFilePrefix).append(".").append(taskName).append(".sql").toString());
                } else if (None$.MODULE$.equals(option)) {
                    path = new Path(new StringBuilder(4).append(sqlFilePrefix).append(".sql").toString());
                } else {
                    throw new MatchError(option);
                }
                Path sqlTaskFile = path;
                if ($this.storage.exists(sqlTaskFile)) {
                    SqlTaskExtractor sqlTask = SqlTaskExtractor$.MODULE$.apply($this.storage.read(sqlTaskFile));
                    Option<List<String>> x$1 = sqlTask.presql();
                    Option x$2 = Option$.MODULE$.apply((Object)sqlTask.sql());
                    Option<List<String>> x$3 = sqlTask.postsql();
                    String x$4 = Formatter$.MODULE$.RichFormatter(taskDesc.domain()).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings);
                    String x$5 = Formatter$.MODULE$.RichFormatter(taskDesc.dataset()).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings);
                    Option x$6 = taskDesc.area().map((Function1 & Serializable & scala.Serializable)area -> StorageArea$.MODULE$.fromString(Formatter$.MODULE$.RichFormatter(area.value()).richFormat(this.activeEnv(), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), $this.settings));
                    Option<String> x$7 = taskDesc.copy$default$1();
                    WriteMode x$8 = taskDesc.copy$default$5();
                    Option<List<String>> x$9 = taskDesc.copy$default$6();
                    Option<Sink> x$10 = taskDesc.copy$default$10();
                    Option<List<RowLevelSecurity>> x$11 = taskDesc.copy$default$11();
                    Option<Map<String, String>> x$12 = taskDesc.copy$default$12();
                    Option<Engine> x$13 = taskDesc.copy$default$13();
                    autoTaskDesc = taskDesc.copy(x$7, (Option<String>)x$2, x$4, x$5, x$8, x$9, x$1, x$3, (Option<StorageArea>)x$6, x$10, x$11, x$12, x$13);
                } else {
                    autoTaskDesc = taskDesc;
                }
                return autoTaskDesc;
            }, List$.MODULE$.canBuildFrom());
            String jobName = this.finalDomainOrJobName(path, jobDesc.name());
            return jobDesc.copy(jobName, (List<AutoTaskDesc>)tasks, jobDesc.copy$default$3(), jobDesc.copy$default$4(), jobDesc.copy$default$5(), jobDesc.copy$default$6(), jobDesc.copy$default$7(), jobDesc.copy$default$8());
        });
    }

    private String finalDomainOrJobName(Path path, String name) {
        String string;
        String string2 = path.getName();
        String string3 = new StringBuilder(10).append(name).append(".comet.yml").toString();
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            BoxedUnit boxedUnit;
            String newJobName = path.getName().substring(0, path.getName().length() - ".comet.yml".length());
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("deprecated: Please set the job name of {} to reflect the filename. Job renamed to {}. This feature will be removed soon", new Object[]{path.getName(), newJobName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = newJobName;
        } else {
            string = name;
        }
        return string;
    }

    private Map<String, AutoJobDesc> jobs$lzycompute() {
        SchemaHandler schemaHandler = this;
        synchronized (schemaHandler) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Option<Pattern> x$5;
                Path x$1 = DatasetArea$.MODULE$.jobs(this.settings);
                String x$2 = ".yml";
                boolean x$3 = true;
                LocalDateTime x$4 = this.storage.list$default$3();
                List<Path> jobs2 = this.storage.list(x$1, x$2, x$4, x$3, x$5 = this.storage.list$default$5());
                Tuple2 tuple2 = ((TraversableLike)jobs2.map((Function1 & Serializable & scala.Serializable)path -> this.loadJobFromFile((Path)path), List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isSuccess()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List validJobsFile = (List)tuple2._1();
                List invalidJobsFile = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)validJobsFile, (Object)invalidJobsFile);
                Tuple2 tuple23 = tuple22;
                List validJobsFile2 = (List)tuple23._1();
                List invalidJobsFile2 = (List)tuple23._2();
                invalidJobsFile2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SchemaHandler.$anonfun$jobs$3(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.jobs = ((TraversableOnce)((List)validJobsFile2.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Try<AutoJobDesc>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof Success) {
                            Success success = (Success)A1;
                            AutoJobDesc job = (AutoJobDesc)success.value();
                            object = job;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Try<AutoJobDesc> x1) {
                        Try<AutoJobDesc> try_ = x1;
                        boolean bl = try_ instanceof Success;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)job -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)job.name()), job), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.jobs;
    }

    public Map<String, AutoJobDesc> jobs() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.jobs$lzycompute() : this.jobs;
    }

    public Option<Domain> getDomain(String name) {
        return this.domains().find((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$getDomain$1(name, x$20)));
    }

    public List<Schema> getSchemas(String domain) {
        return (List)this.getDomain(domain).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.schemas()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Option<Schema> getSchema(String domainName, String schemaName) {
        return this.getDomain(domainName).flatMap((Function1 & Serializable & scala.Serializable)domain -> domain.schemas().find((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$getSchema$2(schemaName, x$22))).map((Function1 & Serializable & scala.Serializable)schema -> schema));
    }

    public static final /* synthetic */ void $anonfun$checkValidity$4(SchemaHandler $this, String err) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(err);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkViewsValidity$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List paths = (List)tuple2._2();
        boolean bl = paths.length() > 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$types$3(List redefinedTypeNames$1, Type defaultType) {
        return !redefinedTypeNames$1.contains((Object)defaultType.name());
    }

    public static final /* synthetic */ void $anonfun$loadSqlViews$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String viewName = (String)tuple2._1();
        String string = viewName.substring(viewName.lastIndexOf(46) + 1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Map loadEnv$1(Path path) {
        return this.storage.exists(path) ? (Map)Option$.MODULE$.apply(((Env)this.mapper().readValue(this.storage.read(path), Env.class)).env()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()) : Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ boolean $anonfun$getType$1(String tpe$1, Type x$9) {
        String string = x$9.name();
        String string2 = tpe$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$domains$7(SchemaHandler $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("There is one or more invalid Yaml files in your domains folder:{}", new Object[]{err.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ($this.settings.comet().validateOnLoad()) {
                throw err;
            }
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$domains$9(SchemaHandler $this, String x$15) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(x$15);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$domains$11(SchemaHandler $this, String x$17) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(x$17);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$jobs$3(SchemaHandler $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            err.printStackTrace();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("There is one or more invalid Yaml files in your jobs folder:{}", new Object[]{err.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ($this.settings.comet().validateOnLoad()) {
                throw err;
            }
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getDomain$1(String name$1, Domain x$20) {
        String string = x$20.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSchema$2(String schemaName$1, Schema x$22) {
        String string = x$22.name();
        String string2 = schemaName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SchemaHandler(StorageHandler storage, Settings settings) {
        this.storage = storage;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        Tuple2 tuple2 = new Tuple2(Settings.class, (Object)settings);
        this.mapper = new CometObjectMapper((JsonFactory)new YAMLFactory(), (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$.$colon$colon((Object)tuple2));
        LocalDateTime today = LocalDateTime.now();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MM");
        DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("dd");
        DateTimeFormatter hourFormatter = DateTimeFormatter.ofPattern("HH");
        DateTimeFormatter minuteFormatter = DateTimeFormatter.ofPattern("mm");
        DateTimeFormatter secondFormatter = DateTimeFormatter.ofPattern("ss");
        DateTimeFormatter milliFormatter = DateTimeFormatter.ofPattern("SSS");
        DateTimeFormatter instantFormatter = DateTimeFormatter.ofPattern("SSS");
        long epochMillis = today.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.cometDateVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_date"), (Object)today.format(dateFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_datetime"), (Object)today.format(dateTimeFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_year"), (Object)today.format(yearFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_month"), (Object)today.format(monthFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_day"), (Object)today.format(dayFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_hour"), (Object)today.format(hourFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_minute"), (Object)today.format(minuteFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_second"), (Object)today.format(secondFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_milli"), (Object)today.format(milliFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_epoch_second"), (Object)((Object)BoxesRunTime.boxToLong((long)(epochMillis / 1000L))).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_epoch_milli"), (Object)((Object)BoxesRunTime.boxToLong((long)epochMillis)).toString())}));
    }
}

