/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils.repackaged;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.spark.ml.linalg.SQLDataTypes;
import org.apache.spark.sql.types.DataType;

public enum SupportedCustomDataType {
    SPARK_ML_VECTOR("vector", SQLDataTypes.VectorType()),
    SPARK_ML_MATRIX("matrix", SQLDataTypes.MatrixType());

    private final String typeMarker;
    private final DataType sparkDataType;

    private SupportedCustomDataType(String string2, DataType dataType) {
        this.typeMarker = "{spark.type=" + string2 + "}";
        this.sparkDataType = dataType;
    }

    public DataType getSparkDataType() {
        return this.sparkDataType;
    }

    public String getTypeMarker() {
        return this.typeMarker;
    }

    public static Optional<SupportedCustomDataType> of(DataType dataType) {
        Preconditions.checkNotNull((Object)dataType);
        return Stream.of(SupportedCustomDataType.values()).filter(supportedCustomDataType -> supportedCustomDataType.sparkDataType.equals(dataType)).findFirst();
    }

    public static Optional<SupportedCustomDataType> forDescription(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"description cannot be null");
        return Stream.of(SupportedCustomDataType.values()).filter(supportedCustomDataType -> string.endsWith(supportedCustomDataType.typeMarker)).findFirst();
    }
}

