/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.ingest;

import ai.starlake.config.Settings;
import ai.starlake.job.ingest.AuditLog;
import ai.starlake.job.ingest.AuditLog$;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig$;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob$;
import ai.starlake.job.sink.jdbc.ConnectionLoadConfig;
import ai.starlake.job.sink.jdbc.ConnectionLoadConfig$;
import ai.starlake.job.sink.jdbc.ConnectionLoadJob;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.BigQuerySink;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.EsSink;
import ai.starlake.schema.model.FsSink;
import ai.starlake.schema.model.JdbcSink;
import ai.starlake.schema.model.NoneSink;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.utils.FileLock;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;

public final class AuditLog$
implements StrictLogging,
scala.Serializable {
    public static AuditLog$ MODULE$;
    private final List<Tuple3<String, StandardSQLTypeName, AtomicType>> auditCols;
    private final Logger logger;

    static {
        new AuditLog$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public List<Tuple3<String, StandardSQLTypeName, AtomicType>> auditCols() {
        return this.auditCols;
    }

    private com.google.cloud.bigquery.Schema bqSchema() {
        List fields = (List)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String name = (String)tuple3._1();
            StandardSQLTypeName tpe = (StandardSQLTypeName)tuple3._2();
            Field field = Field.newBuilder((String)name, (StandardSQLTypeName)tpe, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("").build();
            return field;
        }, List$.MODULE$.canBuildFrom());
        return com.google.cloud.bigquery.Schema.of((Field[])((Field[])fields.toArray(ClassTag$.MODULE$.apply(Field.class))));
    }

    public Object sink(SparkSession session, AuditLog log, Settings settings) {
        Object object;
        Sink sink;
        if (settings.comet().sinkToFile()) {
            AuditLog$.sinkToFile$1(log, settings, session);
        }
        if ((sink = settings.comet().audit().sink()) instanceof JdbcSink) {
            JdbcSink jdbcSink = (JdbcSink)sink;
            RDD auditTypedRDD = session.sparkContext().parallelize((Seq)new .colon.colon((Object)log, (List)Nil$.MODULE$), session.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(AuditLog.class));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_starlake_job_ingest_AuditLog$$typecreator6$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.starlake.job.ingest.AuditLog").asType().toTypeConstructor();
                }

                public Ai_starlake_job_ingest_AuditLog$$typecreator6$2() {
                }
            }
            Dataset auditDF = session.createDataFrame(session.implicits().rddToDatasetHolder(auditTypedRDD, session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_job_ingest_AuditLog$$typecreator6$2()))).toDF().rdd(), StructType$.MODULE$.apply((Seq)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String name = (String)tuple3._1();
                AtomicType sparkType = (AtomicType)tuple3._3();
                StructField structField = new StructField(name, (DataType)sparkType, true, StructField$.MODULE$.apply$default$4());
                return structField;
            }, List$.MODULE$.canBuildFrom()))).toDF((Seq)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                String name;
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String string = name = (String)tuple3._1();
                return string;
            }, List$.MODULE$.canBuildFrom()));
            String x$1 = jdbcSink.connection();
            Settings.Comet x$2 = settings.comet();
            Right x$3 = package$.MODULE$.Right().apply((Object)auditDF);
            String x$4 = "audit";
            int x$5 = BoxesRunTime.unboxToInt((Object)jdbcSink.partitions().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            int x$6 = BoxesRunTime.unboxToInt((Object)jdbcSink.batchsize().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1000));
            Map<String, String> x$7 = jdbcSink.getOptions();
            JobInfo.CreateDisposition x$8 = ConnectionLoadConfig$.MODULE$.fromComet$default$5();
            JobInfo.WriteDisposition x$9 = ConnectionLoadConfig$.MODULE$.fromComet$default$6();
            boolean x$10 = ConnectionLoadConfig$.MODULE$.fromComet$default$10();
            ConnectionLoadConfig jdbcConfig = ConnectionLoadConfig$.MODULE$.fromComet(x$1, x$2, (Either<String, Dataset<Row>>)x$3, x$4, x$8, x$9, x$5, x$6, x$7, x$10);
            object = new ConnectionLoadJob(jdbcConfig, settings).run();
        } else if (sink instanceof BigQuerySink) {
            BigQuerySink bigQuerySink = (BigQuerySink)sink;
            String auditDataset = (String)bigQuerySink.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
            BigQueryNativeJob$.MODULE$.createTable(auditDataset, "audit", this.bqSchema());
            Left x$11 = package$.MODULE$.Left().apply((Object)"ignore");
            String x$12 = auditDataset;
            String x$13 = "audit";
            None$ x$14 = None$.MODULE$;
            Nil$ x$15 = Nil$.MODULE$;
            String x$16 = settings.comet().defaultFormat();
            String x$17 = "CREATE_IF_NEEDED";
            String x$18 = "WRITE_APPEND";
            None$ x$19 = None$.MODULE$;
            None$ x$20 = None$.MODULE$;
            Map<String, String> x$21 = bigQuerySink.getOptions();
            Option<List<RowLevelSecurity>> x$22 = BigQueryLoadConfig$.MODULE$.apply$default$11();
            boolean x$23 = BigQueryLoadConfig$.MODULE$.apply$default$12();
            Engine x$24 = BigQueryLoadConfig$.MODULE$.apply$default$13();
            Option<List<String>> x$25 = BigQueryLoadConfig$.MODULE$.apply$default$15();
            Option<List<AccessControlEntry>> x$26 = BigQueryLoadConfig$.MODULE$.apply$default$16();
            Option<Schema> x$27 = BigQueryLoadConfig$.MODULE$.apply$default$17();
            Option<Set<String>> x$28 = BigQueryLoadConfig$.MODULE$.apply$default$18();
            BigQueryLoadConfig bqConfig = new BigQueryLoadConfig((Either<String, Dataset<Row>>)x$11, x$12, x$13, (Option<String>)x$14, (Seq<String>)x$15, x$16, x$17, x$18, (Option<String>)x$19, (Option<Object>)x$20, x$22, x$23, x$24, x$21, x$25, x$26, x$27, x$28);
            Try<Job> res = new BigQueryNativeJob(bqConfig, log.asBqInsert(new StringBuilder(1).append(bqConfig.outputDataset()).append(".").append(bqConfig.outputTable()).toString()), (Option<String>)None$.MODULE$, settings).runBatchQuery();
            object = Utils$.MODULE$.logFailure(res, this.logger());
        } else {
            if (sink instanceof EsSink) {
                throw new Exception("Sinking Audit log to Elasticsearch not yet supported");
            }
            boolean bl = sink instanceof NoneSink ? true : sink instanceof FsSink;
            if (bl && !settings.comet().sinkToFile()) {
                AuditLog$.sinkToFile$1(log, settings, session);
                object = BoxedUnit.UNIT;
            } else {
                boolean bl2 = sink instanceof NoneSink ? true : sink instanceof FsSink;
                if (bl2 && settings.comet().sinkToFile()) {
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)sink);
                }
            }
        }
        return object;
    }

    public AuditLog apply(String jobid, String paths, String domain, String schema, boolean success, long count, long countAccepted, long countRejected, Timestamp timestamp, long duration, String message, String step) {
        return new AuditLog(jobid, paths, domain, schema, success, count, countAccepted, countRejected, timestamp, duration, message, step);
    }

    public Option<Tuple12<String, String, String, String, Object, Object, Object, Object, Timestamp, Object, String, String>> unapply(AuditLog x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.jobid(), (Object)x$0.paths(), (Object)x$0.domain(), (Object)x$0.schema(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.success()), (Object)BoxesRunTime.boxToLong((long)x$0.count()), (Object)BoxesRunTime.boxToLong((long)x$0.countAccepted()), (Object)BoxesRunTime.boxToLong((long)x$0.countRejected()), (Object)x$0.timestamp(), (Object)BoxesRunTime.boxToLong((long)x$0.duration()), (Object)x$0.message(), (Object)x$0.step()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void sinkToFile$1(AuditLog log, Settings settings, SparkSession session$1) {
        Path lockPath = new Path(settings.comet().audit().path(), "audit.lock");
        FileLock locker = new FileLock(lockPath, settings.storageHandler());
        locker.doExclusively(locker.doExclusively$default$1(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Path auditPath = new Path(settings.comet().audit().path(), "ingestion-log");
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Ai_starlake_job_ingest_AuditLog$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.starlake.job.ingest.AuditLog").asType().toTypeConstructor();
                }

                public Ai_starlake_job_ingest_AuditLog$$typecreator6$1() {
                }
            }
            DataFrameWriter dfWriter = session$1.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)log, (List)Nil$.MODULE$), session$1.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_job_ingest_AuditLog$$typecreator6$1()))).toDF().write().mode(SaveMode.Append);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Saving audit to path {}", new Object[]{auditPath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (settings.comet().hive()) {
                BoxedUnit boxedUnit2;
                String hiveDB = (String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
                String tableName = "audit";
                String fullTableName = new StringBuilder(1).append(hiveDB).append(".").append(tableName).toString();
                session$1.sql(new StringBuilder(30).append("create database if not exists ").append(hiveDB).toString());
                session$1.sql(new StringBuilder(4).append("use ").append(hiveDB).toString());
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Saving audit to table {}", new Object[]{fullTableName});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                dfWriter.format(settings.comet().defaultAuditWriteFormat()).saveAsTable(fullTableName);
            } else {
                BoxedUnit boxedUnit3;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Saving audit to file {}", new Object[]{auditPath});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                dfWriter.format(settings.comet().defaultAuditWriteFormat()).option("path", auditPath.toString()).save();
            }
        });
    }

    private AuditLog$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.auditCols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"jobid", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"paths", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"domain", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"schema", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"success", (Object)StandardSQLTypeName.BOOL, (Object)BooleanType$.MODULE$), new Tuple3((Object)"count", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"countAccepted", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"countRejected", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"timestamp", (Object)StandardSQLTypeName.TIMESTAMP, (Object)TimestampType$.MODULE$), new Tuple3((Object)"duration", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"message", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"step", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$)}));
    }
}

