/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BigQueryNativeJob$
implements StrictLogging {
    public static BigQueryNativeJob$ MODULE$;
    private final Logger logger;

    static {
        new BigQueryNativeJob$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void createTable(String datasetName, String tableName, Schema schema) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Table tbl;
            TableId tableId = TableId.of((String)datasetName, (String)tableName);
            Option table = Option$.MODULE$.apply((Object)BigQueryJobBase$.MODULE$.bigquery().getTable(tableId, new BigQuery.TableOption[0]));
            Option option = table;
            if (option instanceof Some && (tbl = (Table)(some = (Some)option).value()).exists()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)schema);
                TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
                BigQueryJobBase$.MODULE$.bigquery().create(tableInfo, new BigQuery.TableOption[0]);
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Table {}.{} created successfully", new Object[]{datasetName, tableName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        });
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Table {}.{} was not created.", new Object[]{datasetName, tableName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Utils$.MODULE$.logException(this.logger(), e);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public void createViews(Map<String, String> views, Option<String> udf) {
        views.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BigQueryNativeJob$.$anonfun$createViews$1(udf, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createViews$1(Option udf$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            ViewDefinition.Builder viewQuery = ViewDefinition.newBuilder((String)value).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false));
            ViewDefinition.Builder viewDefinition = (ViewDefinition.Builder)udf$1.map((Function1 & Serializable & scala.Serializable)udf -> viewQuery.setUserDefinedFunctions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)UserDefinedFunction.fromUri((String)udf), (List)Nil$.MODULE$)).asJava())).getOrElse((Function0 & Serializable & scala.Serializable)() -> viewQuery);
            TableId tableId = BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(key);
            Option viewRef = Option$.MODULE$.apply((Object)BigQueryJobBase$.MODULE$.bigquery().getTable(tableId, new BigQuery.TableOption[0]));
            if (viewRef.isEmpty()) {
                BoxedUnit boxedUnit2;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("View {} does not exist, creating it!", new Object[]{tableId});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BigQueryJobBase$.MODULE$.bigquery().create(TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition.build()), new BigQuery.TableOption[0]);
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("View {} created", new Object[]{tableId});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("View {} already exist", new Object[]{tableId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    private BigQueryNativeJob$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

