/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.job.sink.bigquery.BigQueryJobBase;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryJobResult;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob$;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.SinkType;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.Policy;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.DatasetLogging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tE\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!b\u0001\n\u0007A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bA\u0003A\u0011A)\t\u000ba\u0003A\u0011I-\t\u000fi\u0003!\u0019!C!3\"11\f\u0001Q\u0001\naBQ\u0001\u0018\u0001\u0005\u0002uCQ!\u0019\u0001\u0005\n\tDQ\u0001\u001e\u0001\u0005BUDaa \u0001\u0005\u0002\u0005\u0005qaBA\u0006+!\u0005\u0011Q\u0002\u0004\u0007)UA\t!a\u0004\t\rA\u0003B\u0011AA\u0011\u0011\u001d\t\u0019\u0003\u0005C\u0001\u0003KAq!a\u0010\u0011\t\u0003\t\tEA\tCS\u001e\fV/\u001a:z\u001d\u0006$\u0018N^3K_\nT!AF\f\u0002\u0011\tLw-];fefT!\u0001G\r\u0002\tMLgn\u001b\u0006\u00035m\t1A[8c\u0015\taR$\u0001\u0005ti\u0006\u0014H.Y6f\u0015\u0005q\u0012AA1j\u0007\u0001\u0019B\u0001A\u0011([A\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002&pE\n\u000b7/\u001a\t\u0003]=j\u0011!F\u0005\u0003aU\u0011qBQ5h#V,'/\u001f&pE\n\u000b7/Z\u0001\nG2L7i\u001c8gS\u001e,\u0012a\r\t\u0003]QJ!!N\u000b\u0003%\tKw-U;fefdu.\u00193D_:4\u0017nZ\u0001\u000bG2L7i\u001c8gS\u001e\u0004\u0013aA:rYB\u0011\u0011\b\u0011\b\u0003uy\u0002\"aO\u0012\u000e\u0003qR!!P\u0010\u0002\rq\u0012xn\u001c;?\u0013\ty4%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA $\u0003\r)HM\u001a\t\u0004E\u0015C\u0014B\u0001$$\u0005\u0019y\u0005\u000f^5p]\u0006A1/\u001a;uS:<7/F\u0001J!\tQU*D\u0001L\u0015\ta5$\u0001\u0004d_:4\u0017nZ\u0005\u0003\u001d.\u0013\u0001bU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\na\u0001P5oSRtD\u0003\u0002*V-^#\"a\u0015+\u0011\u00059\u0002\u0001\"B$\b\u0001\bI\u0005\"B\u0019\b\u0001\u0004\u0019\u0004\"B\u001c\b\u0001\u0004A\u0004\"B\"\b\u0001\u0004!\u0015\u0001\u00028b[\u0016,\u0012\u0001O\u0001\naJ|'.Z2u\u0013\u0012\f!\u0002\u001d:pU\u0016\u001cG/\u00133!\u0003M\u0011XO\\%oi\u0016\u0014\u0018m\u0019;jm\u0016\fV/\u001a:z)\u0005q\u0006C\u0001\u0018`\u0013\t\u0001WCA\tCS\u001e\fV/\u001a:z\u0015>\u0014'+Z:vYR\f1#\u00193e+\u00123Ek\\)vKJL8i\u001c8gS\u001e$\"a\u0019:\u0011\u0005\u0011|gBA3n\u001b\u00051'B\u0001\fh\u0015\tA\u0017.A\u0003dY>,HM\u0003\u0002kW\u00061qm\\8hY\u0016T\u0011\u0001\\\u0001\u0004G>l\u0017B\u00018g\u0003U\tV/\u001a:z\u0015>\u00147i\u001c8gS\u001e,(/\u0019;j_:L!\u0001]9\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011aN\u001a\u0005\u0006g2\u0001\raY\u0001\fcV,'/_\"p]\u001aLw-A\u0002sk:$\u0012A\u001e\t\u0004ojdX\"\u0001=\u000b\u0005e\u001c\u0013\u0001B;uS2L!a\u001f=\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002){&\u0011a0\u000b\u0002\n\u0015>\u0014'+Z:vYR\fQB];o\u0005\u0006$8\r[)vKJLHCAA\u0002!\u00119(0!\u0002\u0011\u0007\u0015\f9!C\u0002\u0002\n\u0019\u00141AS8c\u0003E\u0011\u0015nZ)vKJLh*\u0019;jm\u0016TuN\u0019\t\u0003]A\u0019B\u0001E\u0011\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001D:dC2\fGn\\4hS:<'bAA\u000eW\u0006AA/\u001f9fg\u00064W-\u0003\u0003\u0002 \u0005U!!D*ue&\u001cG\u000fT8hO&tw\r\u0006\u0002\u0002\u000e\u0005Y1M]3bi\u0016$\u0016M\u00197f)!\t9#!\f\u00022\u0005U\u0002c\u0001\u0012\u0002*%\u0019\u00111F\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003_\u0011\u0002\u0019\u0001\u001d\u0002\u0017\u0011\fG/Y:fi:\u000bW.\u001a\u0005\u0007\u0003g\u0011\u0002\u0019\u0001\u001d\u0002\u0013Q\f'\r\\3OC6,\u0007bBA\u001c%\u0001\u0007\u0011\u0011H\u0001\u0007g\u000eDW-\\1\u0011\u0007\u0015\fY$C\u0002\u0002>\u0019\u0014aaU2iK6\f\u0017aC2sK\u0006$XMV5foN$b!a\n\u0002D\u00055\u0003bBA#'\u0001\u0007\u0011qI\u0001\u0006m&,wo\u001d\t\u0006s\u0005%\u0003\bO\u0005\u0004\u0003\u0017\u0012%aA'ba\")1i\u0005a\u0001\t\":1#!\u0015\u0002X\u0005m\u0003c\u0001\u0012\u0002T%\u0019\u0011QK\u0012\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002Z\u0005)d+[3xg\u0002\n'/\u001a\u0011o_^\u00043M]3bi\u0016$\u0007%^:j]\u001e\u0004C\u000f[3!gftG/\u0019=!/RC\u0005E\f\u0018/A\u0005\u001b\u0006E\f\u0018/C\t\ti&\u0001\u00041]Er#'\u000e")
public class BigQueryNativeJob
implements JobBase,
BigQueryJobBase {
    private final BigQueryLoadConfig cliConfig;
    private final String sql;
    private final Option<String> udf;
    private final Settings settings;
    private final String projectId;
    private final TableId tableId;
    private final DatasetId datasetId;
    private final String bqTable;
    private final Logger logger;

    public static void createViews(Map<String, String> map, Option<String> option) {
        BigQueryNativeJob$.MODULE$.createViews(map, option);
    }

    public static void createTable(String string, String string2, Schema schema) {
        BigQueryNativeJob$.MODULE$.createTable(string, string2, schema);
    }

    @Override
    public Try<BoxedUnit> applyRLSAndCLS(boolean forceApply, Settings settings) {
        return BigQueryJobBase.applyRLSAndCLS$(this, forceApply, settings);
    }

    @Override
    public boolean applyRLSAndCLS$default$1() {
        return BigQueryJobBase.applyRLSAndCLS$default$1$(this);
    }

    @Override
    public List<String> prepareRLS() {
        return BigQueryJobBase.prepareRLS$(this);
    }

    @Override
    public Dataset getOrCreateDataset() {
        return BigQueryJobBase.getOrCreateDataset$(this);
    }

    @Override
    public void setTagsOnTable(Table table) {
        BigQueryJobBase.setTagsOnTable$(this, table);
    }

    @Override
    public void setTagsOnDataset(Dataset dataset) {
        BigQueryJobBase.setTagsOnDataset$(this, dataset);
    }

    @Override
    public Policy applyACL(TableId tableId, List<AccessControlEntry> acl) {
        return BigQueryJobBase.applyACL$(this, tableId, acl);
    }

    @Override
    public TimePartitioning.Builder timePartitioning(String partitionField, Option<Object> days, boolean requirePartitionFilter) {
        return BigQueryJobBase.timePartitioning$(this, partitionField, days, requirePartitionFilter);
    }

    @Override
    public Option<Object> timePartitioning$default$2() {
        return BigQueryJobBase.timePartitioning$default$2$(this);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(org.apache.spark.sql.Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public DatasetId datasetId() {
        return this.datasetId;
    }

    @Override
    public String bqTable() {
        return this.bqTable;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$_setter_$tableId_$eq(TableId x$1) {
        this.tableId = x$1;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$_setter_$datasetId_$eq(DatasetId x$1) {
        this.datasetId = x$1;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$_setter_$bqTable_$eq(String x$1) {
        this.bqTable = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BigQueryLoadConfig cliConfig() {
        return this.cliConfig;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(8).append("bqload-").append(this.cliConfig().outputDataset()).append("-").append(this.cliConfig().outputTable()).toString();
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public BigQueryJobResult runInteractiveQuery() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)this.sql).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running BQ Query {}", new Object[]{this.sql});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfig);
        TableResult results = BigQueryJobBase$.MODULE$.bigquery().query(queryConfigWithUDF.setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build(), new BigQuery.JobOption[0]);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Query large results performed successfully: {} rows inserted.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new BigQueryJobResult((Option<TableResult>)new Some((Object)results));
    }

    /*
     * WARNING - void declaration
     */
    private QueryJobConfiguration.Builder addUDFToQueryConfig(QueryJobConfiguration.Builder queryConfig) {
        void var2_2;
        QueryJobConfiguration.Builder queryConfigWithUDF = (QueryJobConfiguration.Builder)this.udf.map((Function1 & Serializable & scala.Serializable)udf -> queryConfig.setUserDefinedFunctions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)UserDefinedFunction.fromUri((String)udf), (List)Nil$.MODULE$)).asJava())).getOrElse((Function0 & Serializable & scala.Serializable)() -> queryConfig);
        return var2_2;
    }

    @Override
    public Try<JobResult> run() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            QueryJobConfiguration.Builder builder;
            QueryJobConfiguration.Builder builder2;
            Dataset targetDataset = this.getOrCreateDataset();
            QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setDefaultDataset(targetDataset.getDatasetId()).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                builder2 = queryConfig.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
                builder2 = queryConfig;
            } else {
                throw new MatchError(option);
            }
            QueryJobConfiguration.Builder queryConfigWithPartition = builder2;
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
                builder = queryConfigWithPartition;
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                builder = queryConfigWithPartition.setClustering(clustering);
            }
            QueryJobConfiguration.Builder queryConfigWithClustering = builder;
            QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfigWithClustering);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            TableResult results = BigQueryJobBase$.MODULE$.bigquery().query(queryConfigWithUDF.setDestinationTable(this.tableId()).build(), new BigQuery.JobOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Query large results performed successfully: {} rows inserted.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.applyRLSAndCLS(this.applyRLSAndCLS$default$1(), this.settings()).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BigQueryNativeJob $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Utils$.MODULE$.logException(this.$outer.logger(), A1);
                    throw new Exception(A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return new BigQueryJobResult((Option<TableResult>)new Some((Object)results));
        });
    }

    public Try<Job> runBatchQuery() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            this.getOrCreateDataset();
            JobId jobId = JobId.newBuilder().setJob(UUID.randomUUID().toString()).setLocation(this.cliConfig().getLocation()).build();
            QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setPriority(QueryJobConfiguration.Priority.BATCH).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).build();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Job job = BigQueryJobBase$.MODULE$.bigquery().create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Batch query wth jobId {} sent to BigQuery ", new Object[]{jobId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (job == null) {
                throw new Exception("Job not executed since it no longer exists.");
            }
            return var3_3;
        });
    }

    public BigQueryNativeJob(BigQueryLoadConfig cliConfig, String sql, Option<String> udf, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.sql = sql;
        this.udf = udf;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        BigQueryJobBase.$init$(this);
        this.projectId = ServiceOptions.getDefaultProjectId();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("BigQuery Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

