/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.generator;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.schema.generator.JDBC2Yml$;
import ai.starlake.schema.generator.JDBCSchema;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Domain$;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Mode;
import ai.starlake.schema.model.Partition;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrivacyLevel;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteMode;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JDBCUtils$
implements LazyLogging {
    public static JDBCUtils$ MODULE$;
    private final Map<String, Object> sqlTypes;
    private final Map<Object, String> reverseSqlTypes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JDBCUtils$();
    }

    private Logger logger$lzycompute() {
        JDBCUtils$ jDBCUtils$ = this;
        synchronized (jDBCUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Map<String, Object> sqlTypes() {
        return this.sqlTypes;
    }

    public Map<Object, String> reverseSqlTypes() {
        return this.reverseSqlTypes;
    }

    private <T> T withJDBCConnection(String connString, Function1<Connection, T> f, Settings settings) {
        Object object;
        Settings.Connection jdbcOptions = (Settings.Connection)settings.comet().connections().apply((Object)connString);
        String string = jdbcOptions.format();
        String string2 = "jdbc";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        String url = (String)jdbcOptions.options().apply((Object)"url");
        Properties properties = new Properties();
        jdbcOptions.options().$minus((Object)"url").foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Object object = properties.setProperty(key, value);
            return object;
        });
        Connection connection = DriverManager.getConnection(url, properties);
        try {
            Object result;
            object = result = f.apply((Object)connection);
        }
        catch (Throwable throwable) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Closed connection to {}", new Object[]{connString});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(connString).toString(), exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)try_);
            }
            throw throwable;
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Closed connection to {}", new Object[]{connString});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(connString).toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
        return (T)object;
    }

    public boolean applyScript(String script, String connectionString, Settings settings) {
        return BoxesRunTime.unboxToBoolean(this.withJDBCConnection(connectionString, (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$applyScript$1(script, conn)), settings));
    }

    public Map<String, Tuple3<String, List<Attribute>, List<String>>> extractJDBCTables(JDBCSchema jdbcSchema, Settings settings) {
        return (Map)this.withJDBCConnection(jdbcSchema.connection(), (Function1 & Serializable & scala.Serializable)connection -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Map jdbcTableMap = ((TraversableOnce)jdbcSchema.tables().map((Function1 & Serializable & scala.Serializable)tblSchema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tblSchema.name().toUpperCase()), tblSchema), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List tableNames = jdbcTableMap.keys().toList();
            Map allExtractedTables = JDBCUtils$.extractTables$1(databaseMetaData, jdbcSchema);
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                JDBCUtils$.extractTables$1(databaseMetaData, jdbcSchema).keys().foreach((Function1 & Serializable & scala.Serializable)table -> {
                    JDBCUtils$.$anonfun$extractJDBCTables$3(table);
                    return BoxedUnit.UNIT;
                });
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            List list = tableNames;
            Map map = Nil$.MODULE$.equals(list) ? allExtractedTables : (Map)allExtractedTables.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractJDBCTables$4(list, x0$1)));
            Map selectedTables = map;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                selectedTables.keys().foreach((Function1 & Serializable & scala.Serializable)table -> {
                    JDBCUtils$.$anonfun$extractJDBCTables$5(table);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Map selectedTablesAndColumns = (Map)selectedTables.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                List selectedColumns;
                String tableRemarks;
                String tableName;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    tableName = (String)tuple2._1();
                    tableRemarks = (String)tuple2._2();
                    ResultSet foreignKeysResultSet = databaseMetaData.getImportedKeys((String)jdbcSchema.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema.schema(), tableName);
                    Map foreignKeys = new Iterator<Tuple2<String, String>>(foreignKeysResultSet){
                        private final ResultSet foreignKeysResultSet$1;

                        public Iterator<Tuple2<String, String>> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<Tuple2<String, String>> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<Tuple2<String, String>> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<Tuple2<String, String>> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<Tuple2<String, String>> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<Tuple2<String, String>, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<Tuple2<String, String>, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<Tuple2<String, String>> filter(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<String, String>, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<Tuple2<String, String>> withFilter(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<Tuple2<String, String>> filterNot(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<Tuple2<String, String>, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<String, String>, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<Tuple2<String, String>, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<Tuple2<String, String>> takeWhile(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> partition(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> span(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<Tuple2<String, String>> dropWhile(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<Tuple2<String, String>, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<Tuple2<String, String>, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<Tuple2<String, String>, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<Tuple2<String, String>> find(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Tuple2<String, String>, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<Tuple2<String, String>> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<Tuple2<String, String>> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<Tuple2<String, String>> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<Tuple2<String, String>> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<Tuple2<String, String>> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<Tuple2<String, String>, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<Tuple2<String, String>, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, Tuple2<String, String>, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<Tuple2<String, String>, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, Tuple2<String, String>, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<Tuple2<String, String>, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, Tuple2<String, String>, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<Tuple2<String, String>, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<String, String>, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<Tuple2<String, String>, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<String, String>, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<Tuple2<String, String>> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<Tuple2<String, String>> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<Tuple2<String, String>> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<Tuple2<String, String>> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<Tuple2<String, String>> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<String, String>, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<String, String>, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.foreignKeysResultSet$1.next();
                        }

                        public Tuple2<String, String> next() {
                            String pkSchemaName = this.foreignKeysResultSet$1.getString("PKTABLE_SCHEM");
                            String pkTableName = this.foreignKeysResultSet$1.getString("PKTABLE_NAME");
                            String pkColumnName = this.foreignKeysResultSet$1.getString("PKCOLUMN_NAME");
                            String fkColumnName = this.foreignKeysResultSet$1.getString("FKCOLUMN_NAME").toUpperCase();
                            String pkCompositeName = pkSchemaName == null ? new java.lang.StringBuilder(1).append(pkTableName).append(".").append(pkColumnName).toString() : new java.lang.StringBuilder(2).append(pkSchemaName).append(".").append(pkTableName).append(".").append(pkColumnName).toString();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fkColumnName), (Object)pkCompositeName);
                        }
                        {
                            this.foreignKeysResultSet$1 = foreignKeysResultSet$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.toMap(Predef$.MODULE$.$conforms());
                    ResultSet columnsResultSet = databaseMetaData.getColumns((String)jdbcSchema.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema.schema(), tableName, null);
                    ListBuffer attrs = (ListBuffer)new Iterator<Attribute>(columnsResultSet, tableName, foreignKeys){
                        private final ResultSet columnsResultSet$1;
                        private final String tableName$1;
                        private final Map foreignKeys$1;

                        public Iterator<Attribute> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<Attribute> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<Attribute> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<Attribute> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<Attribute> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<Attribute, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<Attribute, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<Attribute> filter(Function1<Attribute, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Attribute, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<Attribute> withFilter(Function1<Attribute, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<Attribute> filterNot(Function1<Attribute, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<Attribute, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, Attribute, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<Attribute, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<Attribute> takeWhile(Function1<Attribute, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Attribute>, Iterator<Attribute>> partition(Function1<Attribute, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Attribute>, Iterator<Attribute>> span(Function1<Attribute, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<Attribute> dropWhile(Function1<Attribute, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<Attribute, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<Attribute, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<Attribute, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<Attribute, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<Attribute, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<Attribute> find(Function1<Attribute, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Attribute, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Attribute, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<Attribute> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<Attribute>, Iterator<Attribute>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<Attribute> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<Attribute> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<Attribute> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<Attribute> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<Attribute, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<Attribute, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, Attribute, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<Attribute, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, Attribute, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<Attribute, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, Attribute, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<Attribute, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, Attribute, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<Attribute, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, Attribute, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<Attribute> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<Attribute> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<Attribute> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<Attribute> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<Attribute> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, Attribute, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Attribute, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.columnsResultSet$1.next();
                        }

                        public Attribute next() {
                            BoxedUnit boxedUnit;
                            String colName = this.columnsResultSet$1.getString("COLUMN_NAME");
                            if (JDBCUtils$.MODULE$.logger().underlying().isInfoEnabled()) {
                                JDBCUtils$.MODULE$.logger().underlying().info("COLUMN_NAME={}.{}", new Object[]{this.tableName$1, colName});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            int colType = this.columnsResultSet$1.getInt("DATA_TYPE");
                            String colTypename = this.columnsResultSet$1.getString("TYPE_NAME");
                            String colRemarks = this.columnsResultSet$1.getString("REMARKS");
                            boolean colRequired = this.columnsResultSet$1.getString("IS_NULLABLE").equals("NO");
                            Option foreignKey = this.foreignKeys$1.get((Object)colName.toUpperCase());
                            String x$1 = colName;
                            String x$2 = JDBCUtils$.MODULE$.ai$starlake$schema$generator$JDBCUtils$$sparkType(colType, this.tableName$1, colName, colTypename);
                            boolean x$3 = colRequired;
                            Option x$4 = Option$.MODULE$.apply((Object)colRemarks);
                            Option x$5 = foreignKey;
                            Option<Object> x$6 = Attribute$.MODULE$.apply$default$3();
                            PrivacyLevel x$7 = Attribute$.MODULE$.apply$default$5();
                            Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
                            Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
                            Option<List<Attribute>> x$10 = Attribute$.MODULE$.apply$default$9();
                            Option<Position> x$11 = Attribute$.MODULE$.apply$default$10();
                            Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
                            Option<Set<String>> x$13 = Attribute$.MODULE$.apply$default$12();
                            Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
                            Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
                            Option<Object> x$16 = Attribute$.MODULE$.apply$default$16();
                            Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
                            return new Attribute(x$1, x$2, x$6, x$3, x$7, (Option<String>)x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$5, x$16, x$17);
                        }
                        {
                            this.columnsResultSet$1 = columnsResultSet$1;
                            this.tableName$1 = tableName$1;
                            this.foreignKeys$1 = foreignKeys$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.to(ListBuffer$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Iterable columns = (scala.collection.immutable.Iterable)attrs.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        ListBuffer uniqAttr = (ListBuffer)tuple2._2();
                        Attribute attribute = (Attribute)uniqAttr.head();
                        return attribute;
                    }, Iterable$.MODULE$.canBuildFrom());
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                            JDBCUtils$.$anonfun$extractJDBCTables$9(tableName, column);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    List currentTableRequestedColumns = (List)jdbcTableMap.get((Object)tableName).map((Function1 & Serializable & scala.Serializable)x$3 -> (List)((List)x$3.columns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toUpperCase(), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                    List list = selectedColumns = currentTableRequestedColumns.isEmpty() ? columns.toList() : (List)columns.toList().filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)currentTableRequestedColumns.contains((Object)col.name().toUpperCase())));
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                            JDBCUtils$.$anonfun$extractJDBCTables$15(tableName, column);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                ResultSet primaryKeysResultSet = databaseMetaData.getPrimaryKeys((String)jdbcSchema.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema.schema(), tableName);
                List<String> primaryKeys = new Iterator<String>(primaryKeysResultSet){
                    private final ResultSet primaryKeysResultSet$1;

                    public Iterator<String> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<String> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<String> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<String> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<String> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<String, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<String> filter(Function1<String, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<String> withFilter(Function1<String, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<String> filterNot(Function1<String, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<String> takeWhile(Function1<String, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<String> dropWhile(Function1<String, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<String, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<String, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<String, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<String, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<String> find(Function1<String, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<String, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<String, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<String> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<String> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<String> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<String> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public List<String> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<String, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, String, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, String, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<String, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, String, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<String, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<String> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<String> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<String> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<String> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<String> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public boolean hasNext() {
                        return this.primaryKeysResultSet$1.next();
                    }

                    public String next() {
                        return this.primaryKeysResultSet$1.getString("COLUMN_NAME");
                    }
                    {
                        this.primaryKeysResultSet$1 = primaryKeysResultSet$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                    }
                }.toList();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)new Tuple3((Object)tableRemarks, (Object)selectedColumns, primaryKeys));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return selectedTablesAndColumns;
        }, settings);
    }

    public Domain extractDomain(JDBCSchema jdbcSchema, Option<Domain> domainTemplate, Map<String, Tuple3<String, List<Attribute>, List<String>>> selectedTablesAndColumns) {
        Option schemaMetadata = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.schemas().headOption().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.metadata()));
        scala.collection.immutable.Iterable cometSchema = (scala.collection.immutable.Iterable)selectedTablesAndColumns.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3;
            String tableName;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    tableName = (String)tuple2._1();
                    tuple3 = (Tuple3)tuple2._2();
                    if (tuple3 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String tableRemarks = (String)tuple3._1();
            List selectedColumns = (List)tuple3._2();
            List primaryKeys = (List)tuple3._3();
            String x$1 = tableName;
            Pattern x$2 = Pattern.compile(new java.lang.StringBuilder(2).append(tableName).append(".*").toString());
            List x$3 = selectedColumns;
            Option x$4 = schemaMetadata;
            None$ x$5 = None$.MODULE$;
            Option x$6 = Option$.MODULE$.apply((Object)tableRemarks);
            None$ x$7 = None$.MODULE$;
            None$ x$8 = None$.MODULE$;
            None$ x$9 = primaryKeys.isEmpty() ? None$.MODULE$ : new Some((Object)primaryKeys);
            Option<Set<String>> x$10 = Schema$.MODULE$.apply$default$9();
            Option<List<RowLevelSecurity>> x$11 = Schema$.MODULE$.apply$default$10();
            Option<Map<String, String>> x$12 = Schema$.MODULE$.apply$default$11();
            Option<List<AccessControlEntry>> x$13 = Schema$.MODULE$.apply$default$13();
            Option<String> x$14 = Schema$.MODULE$.apply$default$14();
            Schema schema = new Schema(x$1, x$2, (List<Attribute>)x$3, (Option<Metadata>)x$4, (Option<MergeOptions>)x$5, (Option<String>)x$6, (Option<List<String>>)x$7, (Option<List<String>>)x$8, x$10, x$11, x$12, (Option<List<String>>)x$9, x$13, x$14);
            return schema;
        }, Iterable$.MODULE$.canBuildFrom());
        String incomingDir = (String)domainTemplate.map((Function1 & Serializable & scala.Serializable)dom -> DatasetArea$.MODULE$.substituteDomainAndSchemaInPath(jdbcSchema.schema(), "", dom.resolveDirectory()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(1).append("/").append(jdbcSchema.schema()).toString());
        Option extensions = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.resolveExtensions());
        Option ack = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.resolveAck());
        String x$36 = jdbcSchema.schema();
        Option x$37 = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.metadata()).map((Function1 & Serializable & scala.Serializable)x$10 -> {
            Some x$15 = new Some((Object)incomingDir);
            Option x$16 = extensions;
            Option x$17 = ack;
            Option<Mode> x$18 = x$10.copy$default$1();
            Option<Format> x$19 = x$10.copy$default$2();
            Option<String> x$20 = x$10.copy$default$3();
            Option<Object> x$21 = x$10.copy$default$4();
            Option<Object> x$22 = x$10.copy$default$5();
            Option<Object> x$23 = x$10.copy$default$6();
            Option<String> x$24 = x$10.copy$default$7();
            Option<String> x$25 = x$10.copy$default$8();
            Option<String> x$26 = x$10.copy$default$9();
            Option<WriteMode> x$27 = x$10.copy$default$10();
            Option<Partition> x$28 = x$10.copy$default$11();
            Option<Sink> x$29 = x$10.copy$default$12();
            Option<String> x$30 = x$10.copy$default$13();
            Option<Seq<String>> x$31 = x$10.copy$default$14();
            Option<Map<String, String>> x$32 = x$10.copy$default$15();
            Option<Map<String, String>> x$33 = x$10.copy$default$19();
            Option<String> x$34 = x$10.copy$default$20();
            Option<Map<String, String>> x$35 = x$10.copy$default$21();
            return x$10.copy(x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, (Option<String>)x$15, (Option<List<String>>)x$16, (Option<String>)x$17, x$33, x$34, x$35);
        });
        None$ x$38 = None$.MODULE$;
        List x$39 = cometSchema.toList();
        None$ x$40 = None$.MODULE$;
        None$ x$41 = None$.MODULE$;
        None$ x$42 = None$.MODULE$;
        Option<String> x$43 = Domain$.MODULE$.apply$default$2();
        Option<Set<String>> x$44 = Domain$.MODULE$.apply$default$9();
        Option<String> x$45 = Domain$.MODULE$.apply$default$10();
        return new Domain(x$36, x$43, (Option<Metadata>)x$37, (Option<List<String>>)x$38, (List<Schema>)x$39, (Option<String>)x$40, (Option<List<String>>)x$41, (Option<String>)x$42, x$44, x$45);
    }

    public String ai$starlake$schema$generator$JDBCUtils$$sparkType(int jdbcType, String tableName, String colName, String colTypename) {
        String string;
        String sqlType = (String)this.reverseSqlTypes().getOrElse((Object)BoxesRunTime.boxToInteger((int)jdbcType), (Function0 & Serializable & scala.Serializable)() -> colTypename);
        int n = jdbcType;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                string = "string";
                break;
            }
            case -7: 
            case 16: {
                string = "boolean";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "double";
                break;
            }
            case 2: 
            case 3: {
                string = "decimal";
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                string = "long";
                break;
            }
            case 91: {
                string = "date";
                break;
            }
            case 93: {
                string = "timestamp";
                break;
            }
            case 2014: {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("forced conversion for {}.{} from {} to timestamp", new Object[]{tableName, colName, sqlType});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                string = "timestamp";
                break;
            }
            case -3: 
            case -2: {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("forced conversion for {}.{} from {} to string", new Object[]{tableName, colName, sqlType});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                string = "string";
                break;
            }
            default: {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Make sure user defined type  {} is defined. Context: {}.{}  -> {} ({})", new Object[]{colTypename, tableName, colName, sqlType, BoxesRunTime.boxToInteger((int)jdbcType)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                string = colTypename;
                break;
            }
        }
        return string;
    }

    public void main(String[] args) {
        JDBC2Yml$.MODULE$.run(args);
    }

    public static final /* synthetic */ boolean $anonfun$applyScript$1(String script$1, Connection conn) {
        return conn.createStatement().execute(script$1);
    }

    private static final Map extractTables$1(DatabaseMetaData databaseMetaData$1, JDBCSchema jdbcSchema$1) {
        scala.collection.mutable.Map tableNames = Map$.MODULE$.empty();
        ResultSet resultSet = databaseMetaData$1.getTables((String)jdbcSchema$1.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema$1.schema(), "%", (String[])jdbcSchema$1.tableTypes().toArray(ClassTag$.MODULE$.apply(String.class)));
        while (resultSet.next()) {
            String tableName = resultSet.getString("TABLE_NAME");
            String remarks = resultSet.getString("REMARKS");
            tableNames.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)remarks));
        }
        resultSet.close();
        return tableNames.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$3(String table) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Found: {}", new Object[]{table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$4(List x1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String table = (String)tuple2._1();
        boolean bl = x1$1.contains((Object)table.toUpperCase()) || x1$1.contains((Object)"*");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$5(String table) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Selected: {}", new Object[]{table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$9(String tableName$1, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("column: {}.{}", new Object[]{tableName$1, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$15(String tableName$1, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Final schema column: {}.{}", new Object[]{tableName$1, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private JDBCUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.sqlTypes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BIT"), (Object)BoxesRunTime.boxToInteger((int)-7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TINYINT"), (Object)BoxesRunTime.boxToInteger((int)-6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SMALLINT"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTEGER"), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BIGINT"), (Object)BoxesRunTime.boxToInteger((int)-5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FLOAT"), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REAL"), (Object)BoxesRunTime.boxToInteger((int)7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DOUBLE"), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NUMERIC"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DECIMAL"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CHAR"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VARCHAR"), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DATE"), (Object)BoxesRunTime.boxToInteger((int)91)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME"), (Object)BoxesRunTime.boxToInteger((int)92)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIMESTAMP"), (Object)BoxesRunTime.boxToInteger((int)93)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BINARY"), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VARBINARY"), (Object)BoxesRunTime.boxToInteger((int)-3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGVARBINARY"), (Object)BoxesRunTime.boxToInteger((int)-4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NULL"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"OTHER"), (Object)BoxesRunTime.boxToInteger((int)1111)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BOOLEAN"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NCHAR"), (Object)BoxesRunTime.boxToInteger((int)-15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGNVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME_WITH_TIMEZONE"), (Object)BoxesRunTime.boxToInteger((int)2013)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIMESTAMP_WITH_TIMEZONE"), (Object)BoxesRunTime.boxToInteger((int)2014))}));
        this.reverseSqlTypes = (Map)this.sqlTypes().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }
}

