/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.utils.conversion.Conversions$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0010!\u0001%B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0006\u0003\")q\t\u0001C\u0001\u0011\"9Q\n\u0001b\u0001\n\u0003q\u0005B\u0002.\u0001A\u0003%q\n\u0003\u0005\\\u0001!\u0015\r\u0011\"\u0001]\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u00159\u0007\u0001\"\u0011_\u0011\u001dA\u0007A1A\u0005\u0002%Daa\u001c\u0001!\u0002\u0013Q\u0007\"\u00029\u0001\t\u0003\t\b\"\u0002>\u0001\t\u0003Y\b\"B?\u0001\t\u0003q\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005K\u0011!\u0003\u00133ggN#xN]1hK\"\u000bg\u000e\u001a7fe*\u0011\u0011EI\u0001\tQ\u0006tG\r\\3sg*\u00111\u0005J\u0001\u0007g\u000eDW-\\1\u000b\u0005\u00152\u0013\u0001C:uCJd\u0017m[3\u000b\u0003\u001d\n!!Y5\u0004\u0001M\u0019\u0001A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\t$'D\u0001!\u0013\t\u0019\u0004E\u0001\bTi>\u0014\u0018mZ3IC:$G.\u001a:\u0002\u0015\u0019LG.Z*zgR,W\u000e\u0005\u00027{9\u0011qg\u000f\t\u0003q1j\u0011!\u000f\u0006\u0003u!\na\u0001\u0010:p_Rt\u0014B\u0001\u001f-\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qb\u0013\u0001C:fiRLgnZ:\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0013AB2p]\u001aLw-\u0003\u0002G\u0007\nA1+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0003\u00132#\"AS&\u0011\u0005E\u0002\u0001\"\u0002!\u0004\u0001\b\t\u0005\"\u0002\u001b\u0004\u0001\u0004)\u0014\u0001B2p]\u001a,\u0012a\u0014\t\u0003!bk\u0011!\u0015\u0006\u0003\u001bJS!a\u0015+\u0002\r!\fGm\\8q\u0015\t)f+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0006\u0019qN]4\n\u0005e\u000b&!D\"p]\u001aLw-\u001e:bi&|g.A\u0003d_:4\u0007%\u0001\u000bo_Jl\u0017\r\\5{K\u00124\u0015\u000e\\3TsN$X-\\\u000b\u0002k\u00059Bn\\2l\u0003\u000e\fX/[:ji&|g\u000eU8mYRKW.Z\u000b\u0002?B\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\tIV\u0014\u0018\r^5p]*\u0011A\rL\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00014b\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f1\u0003\\8dWJ+gM]3tQB{G\u000e\u001c+j[\u0016\f!AZ:\u0016\u0003)\u0004\"a[7\u000e\u00031T!\u0001\u001b*\n\u00059d'A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006\u0019am\u001d\u0011\u0002\u001f\u001d,GoT;uaV$8\u000b\u001e:fC6$\"A];\u0011\u0005-\u001c\u0018B\u0001;m\u0005I15\u000bR1uC>+H\u000f];u'R\u0014X-Y7\t\u000bY\\\u0001\u0019A<\u0002\tA\fG\u000f\u001b\t\u0003WbL!!\u001f7\u0003\tA\u000bG\u000f[\u0001\u0005e\u0016\fG\r\u0006\u00026y\")a\u000f\u0004a\u0001o\u0006)qO]5uKR)q0!\u0002\u0002\nA\u00191&!\u0001\n\u0007\u0005\rAF\u0001\u0003V]&$\bBBA\u0004\u001b\u0001\u0007Q'\u0001\u0003eCR\f\u0007\"\u0002<\u000e\u0001\u00049\u0018aC<sSR,')\u001b8bef$Ra`A\b\u0003;Aq!a\u0002\u000f\u0001\u0004\t\t\u0002E\u0003,\u0003'\t9\"C\u0002\u0002\u00161\u0012Q!\u0011:sCf\u00042aKA\r\u0013\r\tY\u0002\f\u0002\u0005\u0005f$X\rC\u0003w\u001d\u0001\u0007q/A\bmSN$H)\u001b:fGR|'/[3t)\u0011\t\u0019#!\u000e\u0011\u000b\u0005\u0015\u0012qF<\u000f\t\u0005\u001d\u00121\u0006\b\u0004q\u0005%\u0012\"A\u0017\n\u0007\u00055B&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\u0005\u0019&\u001cHOC\u0002\u0002.1BQA^\bA\u0002]\fA\u0001\\5tiRa\u00111EA\u001e\u0003{\t\t%!\u0016\u0002`!)a\u000f\u0005a\u0001o\"A\u0011q\b\t\u0011\u0002\u0003\u0007Q'A\u0005fqR,gn]5p]\"I\u00111\t\t\u0011\u0002\u0003\u0007\u0011QI\u0001\u0006g&t7-\u001a\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u0003\u0011!\u0018.\\3\u000b\u0005\u0005=\u0013\u0001\u00026bm\u0006LA!a\u0015\u0002J\tiAj\\2bY\u0012\u000bG/\u001a+j[\u0016Dq!a\u0016\u0011\u0001\u0004\tI&A\u0005sK\u000e,(o]5wKB\u00191&a\u0017\n\u0007\u0005uCFA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0004\u0003%AA\u0002\u0005\r\u0014aB3yG2,H-\u001a\t\u0006W\u0005\u0015\u0014\u0011N\u0005\u0004\u0003Ob#AB(qi&|g\u000e\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u000bI,w-\u001a=\u000b\t\u0005M\u0014QJ\u0001\u0005kRLG.\u0003\u0003\u0002x\u00055$a\u0002)biR,'O\\\u0001\u0005[>4X\r\u0006\u0004\u0002Z\u0005u\u0014q\u0010\u0005\u0006mF\u0001\ra\u001e\u0005\u0007\u0003\u0003\u000b\u0002\u0019A<\u0002\t\u0011,7\u000f^\u0001\u0007I\u0016dW\r^3\u0015\t\u0005e\u0013q\u0011\u0005\u0006mJ\u0001\ra^\u0001\u0007[.$\u0017N]:\u0015\t\u0005e\u0013Q\u0012\u0005\u0006mN\u0001\ra^\u0001\u000eG>\u0004\u0018P\u0012:p[2{7-\u00197\u0015\u000b}\f\u0019*a&\t\r\u0005UE\u00031\u0001x\u0003\u0019\u0019x.\u001e:dK\"1\u0011\u0011\u0011\u000bA\u0002]\fQ\"\\8wK\u001a\u0013x.\u001c'pG\u0006dG#B@\u0002\u001e\u0006}\u0005BBAK+\u0001\u0007q\u000f\u0003\u0004\u0002\u0002V\u0001\ra^\u0001\u0012[>4Xm\u00159be.\u0004\u0016M\u001d;GS2,GCBAS\u0003O\u000bY\u000b\u0005\u0003,\u0003K:\bBBAU-\u0001\u0007q/A\u0006ta\u0006\u00148NR8mI\u0016\u0014\bBBA -\u0001\u0007Q'\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u00033\n\t\fC\u0003w/\u0001\u0007q/A\u0005cY>\u001c7nU5{KR!\u0011qWA_!\rY\u0013\u0011X\u0005\u0004\u0003wc#\u0001\u0002'p]\u001eDQA\u001e\rA\u0002]\fabY8oi\u0016tGoU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002D\u0006%\u0007cA6\u0002F&\u0019\u0011q\u00197\u0003\u001d\r{g\u000e^3oiN+X.\\1ss\")a/\u0007a\u0001o\u0006i1\u000f]1dK\u000e{gn];nK\u0012$B!a.\u0002P\")aO\u0007a\u0001o\u0006aA.Y:u\u001b>$\u0017NZ5fIR!\u0011Q\u001bB\u0006!\u0011\t9N!\u0002\u000f\t\u0005e\u0017q \b\u0005\u00037\fIP\u0004\u0003\u0002^\u0006Mh\u0002BAp\u0003[tA!!9\u0002j:!\u00111]At\u001d\rA\u0014Q]\u0005\u0002/&\u0011QKV\u0005\u0004\u0003W$\u0016!B:qCJ\\\u0017\u0002BAx\u0003c\f1a]9m\u0015\r\tY\u000fV\u0005\u0005\u0003k\f90A\u0005fq\u0016\u001cW\u000f^5p]*!\u0011q^Ay\u0013\u0011\tY0!@\u0002\u0013M$(/Z1nS:<'\u0002BA{\u0003oLAA!\u0001\u0003\u0004\u0005\u0001b)\u001b7f'R\u0014X-Y7T_V\u00148-\u001a\u0006\u0005\u0003w\fi0\u0003\u0003\u0003\b\t%!!\u0003+j[\u0016\u001cH/Y7q\u0015\u0011\u0011\tAa\u0001\t\u000bY\\\u0002\u0019A<\u0002\rQ|Wo\u00195{)\u0011\u0011\tBa\u0007\u0011\u000b\tM!qC@\u000e\u0005\tU!bAA:Y%!!\u0011\u0004B\u000b\u0005\r!&/\u001f\u0005\u0006mr\u0001\ra^\u0001\u0006i>,8\r\u001b\u000b\u0005\u0005#\u0011\t\u0003C\u0003w;\u0001\u0007q/A\u0003v]jL\u0007\u000f\u0006\u0004\u0003\u0012\t\u001d\"1\u0006\u0005\u0007\u0005Sq\u0002\u0019A<\u0002\u0015M|WO]2f\r&dW\r\u0003\u0004\u0003.y\u0001\ra^\u0001\ni\u0006\u0014x-\u001a;ESJ\u0004")
public class HdfsStorageHandler
implements StorageHandler {
    private String normalizedFileSystem;
    private final String fileSystem;
    private final Settings settings;
    private final Configuration conf;
    private final FileSystem fs;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public String list$default$2() {
        return StorageHandler.list$default$2$(this);
    }

    @Override
    public LocalDateTime list$default$3() {
        return StorageHandler.list$default$3$(this);
    }

    @Override
    public Option<Pattern> list$default$5() {
        return StorageHandler.list$default$5$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Configuration conf() {
        return this.conf;
    }

    private String normalizedFileSystem$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if (!this.bitmap$0) {
                this.normalizedFileSystem = this.fileSystem.endsWith(":") ? new StringBuilder(3).append(this.fileSystem).append("///").toString() : (!this.fileSystem.endsWith("://") && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(this.fileSystem)).last()) == '/' ? (String)new StringOps(Predef$.MODULE$.augmentString(this.fileSystem)).dropRight(1) : (this.fileSystem.endsWith("://") ? new StringBuilder(2).append(this.fileSystem).append("/.").toString() : this.fileSystem));
                this.bitmap$0 = true;
            }
        }
        return this.normalizedFileSystem;
    }

    public String normalizedFileSystem() {
        return !this.bitmap$0 ? this.normalizedFileSystem$lzycompute() : this.normalizedFileSystem;
    }

    @Override
    public FiniteDuration lockAcquisitionPollTime() {
        return this.settings.comet().lock().pollTime();
    }

    @Override
    public FiniteDuration lockRefreshPollTime() {
        return this.settings.comet().lock().refreshTime();
    }

    public FileSystem fs() {
        return this.fs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FSDataOutputStream getOutputStream(Path path) {
        void var2_2;
        this.fs().delete(path, false);
        FSDataOutputStream outputStream = this.fs().create(path);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String read(Path path) {
        void var3_3;
        FSDataInputStream stream = this.fs().open(path);
        String content = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        return var3_3;
    }

    @Override
    public void write(String data, Path path) {
        FSDataOutputStream os = this.getOutputStream(path);
        os.writeBytes(data);
        os.close();
    }

    public void writeBinary(byte[] data, Path path) {
        FSDataOutputStream os = this.getOutputStream(path);
        os.write(data, 0, data.length);
        os.close();
    }

    @Override
    public List<Path> listDirectories(Path path) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs().listStatus(path))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toList();
    }

    @Override
    public List<Path> list(Path path, String extension, LocalDateTime since, boolean recursive, Option<Pattern> exclude) {
        List list;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("list({}, {}, {})", new Object[]{path, extension, since});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Nil$ nil$;
            if (this.exists(path)) {
                RemoteIterator iterator = this.fs().listFiles(path, recursive);
                nil$ = (List)((List)Conversions$.MODULE$.convertToScalaIterator(iterator).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$2(this, exclude, since, extension, status))).toList().sortBy((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)BoxesRunTime.boxToLong((long)r.getModificationTime()), (Object)r.getPath().getName()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)status -> status.getPath(), List$.MODULE$.canBuildFrom());
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        });
        if (try_ instanceof Success) {
            List list2;
            Success success = (Success)try_;
            list = list2 = (List)success.value();
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            list = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return list;
    }

    @Override
    public boolean move(Path path, Path dest) {
        this.delete(dest);
        this.mkdirs(dest.getParent());
        return this.fs().rename(path, dest);
    }

    @Override
    public boolean delete(Path path) {
        return this.fs().delete(path, true);
    }

    @Override
    public boolean mkdirs(Path path) {
        return this.fs().mkdirs(path);
    }

    @Override
    public void copyFromLocal(Path source, Path dest) {
        this.fs().copyFromLocalFile(source, dest);
    }

    @Override
    public void moveFromLocal(Path source, Path dest) {
        String string = this.fs().getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.fs().moveFromLocalFile(source, dest);
        } else {
            this.move(source, dest);
        }
    }

    @Override
    public Option<Path> moveSparkPartFile(Path sparkFolder, String extension) {
        Path x$1 = sparkFolder;
        String x$2 = extension;
        boolean x$3 = false;
        LocalDateTime x$4 = this.list$default$3();
        Option<Pattern> x$5 = this.list$default$5();
        Option files = this.list(x$1, x$2, x$4, x$3, x$5).headOption();
        return files.map((Function1 & Serializable & scala.Serializable)f -> {
            Path tmpFile = new Path(sparkFolder.getParent(), new StringBuilder(4).append(sparkFolder.getName()).append(".tmp").toString());
            this.move((Path)f, tmpFile);
            this.delete(sparkFolder);
            this.move(tmpFile, sparkFolder);
            return sparkFolder;
        });
    }

    @Override
    public boolean exists(Path path) {
        return this.fs().exists(path);
    }

    @Override
    public long blockSize(Path path) {
        return this.fs().getDefaultBlockSize(path);
    }

    @Override
    public ContentSummary contentSummary(Path path) {
        return this.fs().getContentSummary(path);
    }

    @Override
    public long spaceConsumed(Path path) {
        return this.contentSummary(path).getSpaceConsumed();
    }

    @Override
    public long lastModified(Path path) {
        return this.fs().getFileStatus(path).getModificationTime();
    }

    @Override
    public Try<BoxedUnit> touchz(Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().create(path, false).close());
    }

    @Override
    public Try<BoxedUnit> touch(Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().setTimes(path, System.currentTimeMillis(), -1L));
    }

    @Override
    public Try<BoxedUnit> unzip(Path sourceFile, Path targetDir) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.fs().exists(sourceFile)) {
                throw new Exception(new StringBuilder(15).append(sourceFile.toString()).append(" does not exist").toString());
            }
            FSDataInputStream fsInputStream = this.fs().open(sourceFile);
            ZipInputStream zipInputStream = new ZipInputStream((InputStream)fsInputStream);
            package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> zipInputStream.getNextEntry()).takeWhile((Function1 & Serializable & scala.Serializable)ze -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$unzip$3(ze))).foreach((Function1 & Serializable & scala.Serializable)zipEntry -> {
                HdfsStorageHandler.$anonfun$unzip$4(zipInputStream, zipEntry);
                return BoxedUnit.UNIT;
            });
            zipInputStream.close();
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(HdfsStorageHandler $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        $this.conf().set(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$list$3(LocatedFileStatus status$1, Pattern x$3) {
        return x$3.matcher(status$1.getPath().getName()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$list$2(HdfsStorageHandler $this, Option exclude$1, LocalDateTime since$1, String extension$1, LocatedFileStatus status) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("found file={}", new Object[]{status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(status.getModificationTime()), ZoneId.systemDefault());
        boolean excludeFile = exclude$1.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$3(status, x$3)));
        return !excludeFile && time.isAfter(since$1) && status.getPath().getName().endsWith(extension$1);
    }

    public static final /* synthetic */ boolean $anonfun$unzip$3(ZipEntry ze) {
        return ze != null && !ze.isDirectory();
    }

    public static final /* synthetic */ void $anonfun$unzip$4(ZipInputStream zipInputStream$1, ZipEntry zipEntry) {
        String entryName = zipEntry.getName();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead = zipInputStream$1.read(buf, 0, 4096);
        while (bytesRead > -1) {
            outputStream.write(buf, 0, bytesRead);
            bytesRead = zipInputStream$1.read(buf, 0, 4096);
        }
        outputStream.close();
        zipInputStream$1.closeEntry();
    }

    public HdfsStorageHandler(String fileSystem, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        this.fileSystem = fileSystem;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.conf = new Configuration();
        this.conf().set("fs.defaultFS", this.normalizedFileSystem());
        settings.comet().hadoop().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HdfsStorageHandler.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.fs = FileSystem.get((Configuration)this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(3).append("fs=").append(this.fs()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(20).append("fs.getHomeDirectory=").append(this.fs().getHomeDirectory()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(10).append("fs.getUri=").append(this.fs().getUri()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

