/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.UdfRegistration;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.SinkType$BQ$;
import ai.starlake.schema.model.SinkType$FS$;
import ai.starlake.schema.model.SinkType$JDBC$;
import ai.starlake.schema.model.SinkType$KAFKA$;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.kafka.KafkaClient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005eda\u0002\t\u0012!\u0003\r\t\u0001\u0007\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006Q\u0001!\t\"\u000b\u0005\tm\u0001A)\u0019!C\u0005o!)a\b\u0001C\t\u007f!AQ\n\u0001EC\u0002\u0013\u0005a\nC\u0003V\u0001\u0011%a\u000bC\u0003s\u0001\u0011E1\u000fC\u0003~\u0001\u0011Ea\u0010C\u0004\u0002\u0004\u0001!\t\"!\u0002\t\u000f\u0005E\u0001\u0001\"\u0005\u0002\u0014!9\u0011q\u0007\u0001\u0005\u0012\u0005e\u0002bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!!\u001d\u0001\t\u0013\t\u0019H\u0001\u0005Ta\u0006\u00148NS8c\u0015\t\u00112#A\u0003vi&d7O\u0003\u0002\u0015+\u0005A1\u000f^1sY\u0006\\WMC\u0001\u0017\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!E\u0005\u0003EE\u0011qAS8c\u0005\u0006\u001cX-\u0001\u0004%S:LG\u000f\n\u000b\u0002KA\u0011!DJ\u0005\u0003Om\u0011A!\u00168ji\u0006\u0011r/\u001b;i\u000bb$(/Y*qCJ\\7i\u001c8g)\tQC\u0007\u0005\u0002,e5\tAF\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0013\t\u0019DFA\u0005Ta\u0006\u00148nQ8oM\")QG\u0001a\u0001U\u0005a1o\\;sG\u0016\u001cuN\u001c4jO\u0006A1\u000f]1sW\u0016sg/F\u00019!\tID(D\u0001;\u0015\tY4#\u0001\u0004d_:4\u0017nZ\u0005\u0003{i\u0012\u0001b\u00159be.,eN^\u0001\fe\u0016<\u0017n\u001d;feV#g\r\u0006\u0002&\u0001\")\u0011\t\u0002a\u0001\u0005\u0006\u0019Q\u000f\u001a4\u0011\u0005\rSeB\u0001#I!\t)5$D\u0001G\u0015\t9u#\u0001\u0004=e>|GOP\u0005\u0003\u0013n\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011jG\u0001\bg\u0016\u001c8/[8o+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*-\u0003\r\u0019\u0018\u000f\\\u0005\u0003)F\u0013Ab\u00159be.\u001cVm]:j_:\f!CY;jY\u0012\u0004\u0016M\u001d;ji&|g.\u001a3E\rR\u0019qK\u001a5\u0011\u0005a\u001bgBA-b\u001d\tQ\u0006M\u0004\u0002\\?:\u0011AL\u0018\b\u0003\u000bvK\u0011!M\u0005\u0003_AJ!!\f\u0018\n\u0005Ic\u0013B\u00012R\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00012R\u0011\u00159g\u00011\u0001X\u0003\u001d!\u0017\r^1tKRDQ!\u001b\u0004A\u0002)\fAaY8mgB\u00191n\u001c\"\u000f\u00051tgBA#n\u0013\u0005a\u0012B\u00012\u001c\u0013\t\u0001\u0018O\u0001\u0003MSN$(B\u00012\u001c\u0003a\u0001\u0018M\u001d;ji&|g.\u001a3ECR\f7/\u001a;Xe&$XM\u001d\u000b\u0004ij\\\bc\u0001)vo&\u0011a/\u0015\u0002\u0010\t\u0006$\u0018M\u0012:b[\u0016<&/\u001b;feB\u0011\u0001\u000b_\u0005\u0003sF\u00131AU8x\u0011\u00159w\u00011\u0001X\u0011\u0015ax\u00011\u0001k\u0003%\u0001\u0018M\u001d;ji&|g.\u0001\tqCJ$\u0018\u000e^5p]\u0012\u000bG/Y:fiR!qk`A\u0001\u0011\u00159\u0007\u00021\u0001X\u0011\u0015a\b\u00021\u0001k\u0003\u001d\tg.\u00197zu\u0016$B!a\u0002\u0002\u000eA\u0019!$!\u0003\n\u0007\u0005-1DA\u0002B]fDa!a\u0004\n\u0001\u0004\u0011\u0015!\u00044vY2$\u0016M\u00197f\u001d\u0006lW-\u0001\tde\u0016\fG/Z*qCJ\\g+[3xgR9Q%!\u0006\u0002*\u0005M\u0002bBA\f\u0015\u0001\u0007\u0011\u0011D\u0001\u0006m&,wo\u001d\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0015iw\u000eZ3m\u0015\r\t\u0019cE\u0001\u0007g\u000eDW-\\1\n\t\u0005\u001d\u0012Q\u0004\u0002\u0006-&,wo\u001d\u0005\b\u0003WQ\u0001\u0019AA\u0017\u0003%\t7\r^5wK\u0016sg\u000fE\u0003D\u0003_\u0011%)C\u0002\u000221\u00131!T1q\u0011\u001d\t)D\u0003a\u0001\u0003[\tQb]9m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018aD2sK\u0006$Xm\u00159be.4\u0016.Z<\u0015\u000f]\u000bY$!\u0012\u0002P!9\u0011QH\u0006A\u0002\u0005}\u0012\u0001C:j].$\u0016\u0010]3\u0011\t\u0005m\u0011\u0011I\u0005\u0005\u0003\u0007\niB\u0001\u0005TS:\\G+\u001f9f\u0011\u001d\t9e\u0003a\u0001\u0003\u0013\n!b]5oW\u000e{gNZ5h!\u0011Q\u00121\n\"\n\u0007\u000553D\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003#Z\u0001\u0019\u0001\"\u0002\tA\fG\u000f[\u0001\u000fGJ,\u0017\r^3K\t\n\u001be+[3x)\u0019\t9&!\u0018\u0002`A!\u0001+!\u0017x\u0013\r\tY&\u0015\u0002\b\t\u0006$\u0018m]3u\u0011\u001d\t9\u0005\u0004a\u0001\u0003\u0013Ba!!\u0015\r\u0001\u0004\u0011\u0015\u0001D2sK\u0006$XMR*WS\u0016<H\u0003BA3\u0003S\u00022!a\u001ad\u001d\t\u0001\u0016\r\u0003\u0004\u0002R5\u0001\rAQ\u0001\rGJ,\u0017\r^3C#ZKWm\u001e\u000b\u0005\u0003/\ny\u0007\u0003\u0004\u0002R9\u0001\rAQ\u0001\u0010GJ,\u0017\r^3LC\u001a\\\u0017MV5foR)q+!\u001e\u0002x!9\u0011qI\bA\u0002\u0005%\u0003BBA)\u001f\u0001\u0007!\t")
public interface SparkJob
extends JobBase {
    public static /* synthetic */ SparkConf withExtraSparkConf$(SparkJob $this, SparkConf sourceConfig) {
        return $this.withExtraSparkConf(sourceConfig);
    }

    default public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        BoxedUnit boxedUnit;
        sourceConfig.remove("spark.datasource.bigquery.allowFieldAddition");
        sourceConfig.remove("spark.datasource.bigquery.allowFieldRelaxation");
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss.SSS"));
        String appName = new StringBuilder(1).append(this.name()).append("-").append(now).toString();
        SparkConf thisConf = sourceConfig.setAppName(appName).set("spark.app.id", appName);
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(thisConf.toDebugString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return thisConf;
    }

    public static /* synthetic */ SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$(SparkJob $this) {
        return $this.ai$starlake$utils$SparkJob$$sparkEnv();
    }

    default public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
        return new SparkEnv(this.name(), (Function1<SparkConf, SparkConf>)(Function1 & Serializable & scala.Serializable)sourceConfig -> this.withExtraSparkConf((SparkConf)sourceConfig), this.settings());
    }

    public static /* synthetic */ void registerUdf$(SparkJob $this, String udf) {
        $this.registerUdf(udf);
    }

    default public void registerUdf(String udf) {
        UdfRegistration udfInstance = (UdfRegistration)Class.forName(udf).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        udfInstance.register(this.ai$starlake$utils$SparkJob$$sparkEnv().session());
    }

    public static /* synthetic */ SparkSession session$(SparkJob $this) {
        return $this.session();
    }

    default public SparkSession session() {
        List udfs2 = (List)this.settings().comet().udfs().map((Function1 & Serializable & scala.Serializable)udfs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(udfs)).split(','))).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        udfs2.foreach((Function1 & Serializable & scala.Serializable)udf -> {
            this.registerUdf(udf);
            return BoxedUnit.UNIT;
        });
        return this.ai$starlake$utils$SparkJob$$sparkEnv().session();
    }

    private Dataset<Row> buildPartitionedDF(Dataset<Row> dataset, List<String> cols) {
        ObjectRef partitionedDF = ObjectRef.create((Object)dataset.withColumn("comet_date", functions$.MODULE$.current_timestamp()));
        List dataSetsCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).toList();
        cols.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            String string = x0$1;
            if ("comet_date".equals(string) && !dataSetsCols.contains((Object)"date")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("date", functions$.MODULE$.date_format(functions$.MODULE$.col("comet_date"), "yyyyMMdd").cast((DataType)IntegerType$.MODULE$));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("comet_year".equals(string) && !dataSetsCols.contains((Object)"year")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("year", functions$.MODULE$.year(functions$.MODULE$.col("comet_date")));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("comet_month".equals(string) && !dataSetsCols.contains((Object)"month")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("month", functions$.MODULE$.month(functions$.MODULE$.col("comet_date")));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("comet_day".equals(string) && !dataSetsCols.contains((Object)"day")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("day", functions$.MODULE$.dayofmonth(functions$.MODULE$.col("comet_date")));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("comet_hour".equals(string) && !dataSetsCols.contains((Object)"hour")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("hour", functions$.MODULE$.hour(functions$.MODULE$.col("comet_date")));
                boxedUnit = BoxedUnit.UNIT;
            } else if ("comet_minute".equals(string) && !dataSetsCols.contains((Object)"minute")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("minute", functions$.MODULE$.minute(functions$.MODULE$.col("comet_date")));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = (Dataset)partitionedDF$1.elem;
            }
            return boxedUnit;
        });
        return ((Dataset)partitionedDF.elem).drop("comet_date");
    }

    public static /* synthetic */ DataFrameWriter partitionedDatasetWriter$(SparkJob $this, Dataset dataset, List partition) {
        return $this.partitionedDatasetWriter((Dataset<Row>)dataset, (List<String>)partition);
    }

    default public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        DataFrameWriter dataFrameWriter;
        List<String> list = partition;
        if (Nil$.MODULE$.equals(list)) {
            dataFrameWriter = dataset.write();
        } else if (list.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionedDatasetWriter$1(elem)))) {
            List strippedCols = (List)list.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.substring("comet_".length()), List$.MODULE$.canBuildFrom());
            Dataset<Row> partitionedDF = this.buildPartitionedDF(dataset, list);
            dataFrameWriter = partitionedDF.write().partitionBy((Seq)strippedCols);
        } else if (!list.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionedDatasetWriter$3(elem)))) {
            dataFrameWriter = dataset.write().partitionBy(list);
        } else {
            throw new Exception("Cannot mix comet & non comet col names");
        }
        return dataFrameWriter;
    }

    public static /* synthetic */ Dataset partitionDataset$(SparkJob $this, Dataset dataset, List partition) {
        return $this.partitionDataset((Dataset<Row>)dataset, (List<String>)partition);
    }

    default public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Partitioning on {}", new Object[]{partition.mkString(",")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<String> list = partition;
        Dataset<Row> dataset2 = Nil$.MODULE$.equals(list) ? dataset : (list.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionDataset$1(elem))) ? this.buildPartitionedDF(dataset, list) : (!list.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionDataset$2(elem))) ? dataset : dataset));
        return dataset2;
    }

    public static /* synthetic */ Object analyze$(SparkJob $this, String fullTableName) {
        return $this.analyze(fullTableName);
    }

    default public Object analyze(String fullTableName) {
        BoxedUnit boxedUnit;
        if (this.settings().comet().analyze()) {
            Some some;
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("computing statistics on table {}", new Object[]{fullTableName});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String allCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.session().table(fullTableName).columns())).mkString(",");
            this.session().table(fullTableName);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Dataset partitionedColsDF = this.session().sql(new StringBuilder(16).append("show partitions ").append(fullTableName).toString());
                String partitionedCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)partitionedColsDF.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.getAs(0), this.session().implicits().newStringEncoder()).first())).split('/'))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split("=")[0], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().mkString(",");
                return new Some((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(fullTableName).append(" PARTITION (").append(partitionedCols).append(") COMPUTE STATISTICS").toString());
            });
            if (try_ instanceof Success) {
                Some value;
                Success success = (Success)try_;
                some = value = (Some)success.value();
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit3;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(Utils$.MODULE$.exceptionAsString(e));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            Some partitionedCols = some;
            StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(this.session().version().substring(0, 3)));
            if (stringOps.toDouble() >= 2.4) {
                List analyzeCommands = (List)new .colon.colon((Object)new Some((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(fullTableName).append(" COMPUTE STATISTICS NOSCAN").toString()), (List)new .colon.colon((Object)partitionedCols, (List)new .colon.colon((Object)new Some((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(fullTableName).append(" COMPUTE STATISTICS FOR COLUMNS ").append(allCols).toString()), (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
                analyzeCommands.foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Dataset dataset;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.session().sql(command));
                    if (try_ instanceof Success) {
                        Dataset df;
                        Success success = (Success)try_;
                        dataset = df = (Dataset)success.value();
                    } else if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Failed to compute statistics for table {} on columns {}", new Object[]{fullTableName, allCols});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        e.printStackTrace();
                        dataset = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return dataset;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static /* synthetic */ void createSparkViews$(SparkJob $this, Views views, Map activeEnv, Map sqlParameters) {
        $this.createSparkViews(views, (Map<String, String>)activeEnv, (Map<String, String>)sqlParameters);
    }

    default public void createSparkViews(Views views, Map<String, String> activeEnv, Map<String, String> sqlParameters) {
        views.views().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkJob.$anonfun$createSparkViews$1(this, activeEnv, sqlParameters, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ Dataset createSparkView$(SparkJob $this, SinkType sinkType, Option sinkConfig, String path) {
        return $this.createSparkView(sinkType, (Option<String>)sinkConfig, path);
    }

    default public Dataset<Row> createSparkView(SinkType sinkType, Option<String> sinkConfig, String path) {
        Dataset<Row> dataset;
        SinkType sinkType2 = sinkType;
        if (((Object)SinkType$FS$.MODULE$).equals(sinkType2)) {
            dataset = this.createFSView(path);
        } else if (((Object)SinkType$JDBC$.MODULE$).equals(sinkType2)) {
            dataset = this.createJDBCView(sinkConfig, path);
        } else if (((Object)SinkType$KAFKA$.MODULE$).equals(sinkType2)) {
            dataset = this.createKafkaView(sinkConfig, path);
        } else if (((Object)SinkType$BQ$.MODULE$).equals(sinkType2)) {
            dataset = this.createBQView(path);
        } else {
            throw new Exception("Should never happen");
        }
        Dataset<Row> df = dataset;
        return df;
    }

    private Dataset<Row> createJDBCView(Option<String> sinkConfig, String path) {
        Settings.Connection jdbcConfig = (Settings.Connection)this.settings().comet().connections().apply(sinkConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("");
        }));
        return this.session().read().options(jdbcConfig.options()).format(jdbcConfig.format()).option(JDBCOptions$.MODULE$.JDBC_QUERY_STRING(), path).load().cache();
    }

    private Dataset<Row> createFSView(String path) {
        return path.startsWith("/") ? this.session().read().format(this.settings().comet().defaultFormat()).load(path) : (path.trim().toLowerCase().startsWith("select ") ? this.session().sql(path) : this.session().read().format(this.settings().comet().defaultFormat()).load(new StringBuilder(1).append(this.settings().comet().datasets()).append("/").append(path).toString()));
    }

    private Dataset<Row> createBQView(String path) {
        Dataset dataset;
        String string;
        Regex TablePathWithFilter = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_filter\\((.*)\\)")).r();
        Regex TablePathWithSelect = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_select\\((.*)\\)")).r();
        Regex TablePathWithFilterAndSelect = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_select\\((.*)\\)\\.comet_filter\\((.*)\\)")).r();
        Option option = TablePathWithFilterAndSelect.unapplySeq((CharSequence)(string = path));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            BoxedUnit boxedUnit;
            String tablePath = (String)((LinearSeqOptimized)option.get()).apply(0);
            String select = (String)((LinearSeqOptimized)option.get()).apply(1);
            String filter = (String)((LinearSeqOptimized)option.get()).apply(2);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("We are loading the Table with columns: {} and filters: {}", new Object[]{select, filter});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dataset = this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).option("filter", filter).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])select.replaceAll("\\s", "").split(","))).cache();
        } else {
            Option option2 = TablePathWithFilter.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                BoxedUnit boxedUnit;
                String tablePath = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String filter = (String)((LinearSeqOptimized)option2.get()).apply(1);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("We are loading the Table with filters: {}", new Object[]{filter});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                dataset = this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).option("filter", filter).load().cache();
            } else {
                Option option3 = TablePathWithSelect.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    BoxedUnit boxedUnit;
                    String tablePath = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String select = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("We are loading the Table with columns: {}", new Object[]{select});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    dataset = this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])select.replaceAll("\\s", "").split(","))).cache();
                } else {
                    dataset = this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", path).load().cache();
                }
            }
        }
        return dataset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dataset<Row> createKafkaView(Option<String> sinkConfig, String path) {
        Option<String> option = sinkConfig;
        if (!(option instanceof Some)) return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
            Dataset dataframe;
            Tuple2<Dataset<Row>, List<Tuple2<Object, Object>>> tuple2 = kafkaClient.consumeTopicBatch(path, this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dataset dataset = dataframe = (Dataset)tuple2._1();
            Dataset dataframe2 = dataset;
            return dataframe2;
        });
        Some some = (Some)option;
        String x = (String)some.value();
        String string = x.toLowerCase();
        String string2 = "stream";
        if (string != null) {
            if (!string.equals(string2)) return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
                Dataset dataframe;
                Tuple2<Dataset<Row>, List<Tuple2<Object, Object>>> tuple2 = kafkaClient.consumeTopicBatch(path, this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Dataset dataset = dataframe = (Dataset)tuple2._1();
                Dataset dataframe2 = dataset;
                return dataframe2;
            });
            return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> kafkaClient.consumeTopicStreaming(this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path)));
        }
        if (string2 == null) return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> kafkaClient.consumeTopicStreaming(this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path)));
        return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
            Dataset dataframe;
            Tuple2<Dataset<Row>, List<Tuple2<Object, Object>>> tuple2 = kafkaClient.consumeTopicBatch(path, this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dataset dataset = dataframe = (Dataset)tuple2._1();
            Dataset dataframe2 = dataset;
            return dataframe2;
        });
    }

    public static /* synthetic */ boolean $anonfun$partitionedDatasetWriter$1(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ boolean $anonfun$partitionedDatasetWriter$3(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ boolean $anonfun$partitionDataset$1(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ boolean $anonfun$partitionDataset$2(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ void $anonfun$createSparkViews$1(SparkJob $this, Map activeEnv$1, Map sqlParameters$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit2;
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String valueWithEnv = Formatter$.MODULE$.RichFormatter(value).richFormat((Map<String, String>)activeEnv$1, (Map<String, String>)sqlParameters$1, $this.settings());
            Tuple3<SinkType, Option<String>, String> tuple3 = $this.parseViewDefinition(valueWithEnv);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            SinkType sinkType = (SinkType)tuple3._1();
            Option sinkConfig = (Option)tuple3._2();
            String path = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)sinkType, (Object)sinkConfig, (Object)path);
            Tuple3 tuple33 = tuple32;
            SinkType sinkType2 = (SinkType)tuple33._1();
            Option sinkConfig2 = (Option)tuple33._2();
            String path2 = (String)tuple33._3();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Loading view {} from {}", new Object[]{path2, sinkType2});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Dataset<Row> df = $this.createSparkView(sinkType2, (Option<String>)sinkConfig2, path2);
            df.createOrReplaceTempView(key);
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Created view {}", new Object[]{key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public static void $init$(SparkJob $this) {
    }
}

