/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.config;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DatasetArea$
implements StrictLogging {
    public static DatasetArea$ MODULE$;
    private final Logger logger;

    static {
        new DatasetArea$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Path path(String domain, String area, Settings settings) {
        return new Path(new StringBuilder(3).append(settings.comet().fileSystem()).append("/").append(settings.comet().datasets()).append("/").append(area).append("/").append(domain).toString());
    }

    public Path path(Path domainPath, String schema) {
        return new Path(domainPath, schema);
    }

    public Path pending(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().pending(), settings);
    }

    public Path unresolved(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().unresolved(), settings);
    }

    public Path archive(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().archive(), settings);
    }

    public Path ingesting(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().ingesting(), settings);
    }

    public Path accepted(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().accepted(), settings);
    }

    public Path rejected(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().rejected(), settings);
    }

    public Path metrics(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.comet().metrics().path());
    }

    public Path assertions(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.comet().assertions().path());
    }

    public Path replay(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().replay(), settings);
    }

    public Path substituteDomainAndSchemaInPath(String domain, String schema, String path) {
        return new Path(path.replace("{domain}", domain).replace("{schema}", schema));
    }

    public Path discreteMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "discrete");
    }

    public Path continuousMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "continuous");
    }

    public Path frequenciesMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "frequencies");
    }

    public Path business(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().business(), settings);
    }

    public Path metadata(Settings settings) {
        return new Path(String.valueOf(settings.comet().metadata()));
    }

    public Path types(Settings settings) {
        return new Path(this.metadata(settings), "types");
    }

    public Path assertions(Settings settings) {
        return new Path(this.metadata(settings), "assertions");
    }

    public Path mapping(Settings settings) {
        return new Path(this.metadata(settings), "mapping");
    }

    public Path domains(Settings settings) {
        return new Path(this.metadata(settings), "domains");
    }

    public Path extract(Settings settings) {
        return new Path(this.metadata(settings), "extract");
    }

    public Path jobs(Settings settings) {
        return new Path(this.metadata(settings), "jobs");
    }

    public Path views(Settings settings) {
        return new Path(this.metadata(settings), "views");
    }

    public Path views(String viewsPath, Settings settings) {
        if (viewsPath.startsWith("/")) {
            return new Path(this.views(settings), (String)new StringOps(Predef$.MODULE$.augmentString(viewsPath)).drop(1));
        }
        return new Path(this.views(settings), viewsPath);
    }

    public void initMetadata(StorageHandler storage, Settings settings) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{this.metadata(settings), this.types(settings), this.domains(settings), this.extract(settings), this.jobs(settings), this.assertions(settings), this.views(settings), this.mapping(settings)})).foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage.mkdirs(path)));
    }

    public void initDomains(StorageHandler storage, Iterable<String> domains, Settings settings) {
        domains.foreach((Function1 & Serializable & scala.Serializable)domain -> {
            DatasetArea$.$anonfun$initDomains$1(settings, storage, domain);
            return BoxedUnit.UNIT;
        });
    }

    public void bootstrap(StorageHandler storage, Settings settings) {
        this.initMetadata(storage, settings);
        List metadataResources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"domains/hr.comet.yml", "domains/sales.comet.yml", "jobs/kpi.comet.yml", "jobs/kpi.byseller.sql.j2", "types/default.comet.yml", "types/types.comet.yml", "env.comet.yml", "env.BQ.comet.yml", "env.FS.comet.yml"}));
        storage.mkdirs(this.metadata(settings));
        DatasetArea$.copyToFolder$1(metadataResources, "quickstart-template/metadata", this.metadata(settings), settings, storage);
        Path incomingFolder = new Path(this.metadata(settings).getParent(), "incoming");
        storage.mkdirs(incomingFolder);
        List rootResources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incoming/hr/locations-2018-01-01.ack", "incoming/hr/locations-2018-01-01.json", "incoming/hr/sellers-2018-01-01.ack", "incoming/hr/sellers-2018-01-01.json", "incoming/sales/customers-2018-01-01.ack", "incoming/sales/customers-2018-01-01.psv", "incoming/sales/orders-2018-01-01.ack", "incoming/sales/orders-2018-01-01.csv"}));
        DatasetArea$.copyToFolder$1(rootResources, "quickstart-template", incomingFolder, settings, storage);
    }

    public static final /* synthetic */ void $anonfun$initDomains$1(Settings settings$1, StorageHandler storage$2, String domain2) {
        ((List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.pending((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.unresolved((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.archive((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.accepted((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.rejected((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.business((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.replay((String)domain, settings$1), (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Path)x$1.apply((Object)domain2), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage$2.mkdirs(path)));
    }

    public static final /* synthetic */ void $anonfun$bootstrap$1(String resourceFolder$1, Path targetFolder$1, Settings settings$2, StorageHandler storage$3, String resource) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Boostrapping {}", new Object[]{resource});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BufferedSource source = Source$.MODULE$.fromResource(new StringBuilder(1).append(resourceFolder$1).append("/").append(resource).toString(), Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec());
        if (source == null) {
            throw new Exception(new StringBuilder(31).append("Resource ").append(resource).append(" not found in assembly").toString());
        }
        Iterator lines = source.getLines();
        Path targetFile = new Path(new StringBuilder(1).append(targetFolder$1.toString()).append("/").append(resource).toString());
        String contents = lines.mkString("\n").replace("__COMET_TEST_ROOT__", MODULE$.metadata(settings$2).getParent().toString());
        storage$3.write(contents, targetFile);
    }

    private static final void copyToFolder$1(List resources, String resourceFolder, Path targetFolder, Settings settings$2, StorageHandler storage$3) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            DatasetArea$.$anonfun$bootstrap$1(resourceFolder, targetFolder, settings$2, storage$3, resource);
            return BoxedUnit.UNIT;
        });
    }

    private DatasetArea$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

