/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extractor;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.StorageArea;
import ai.starlake.extractor.ExtractScriptGenConfig;
import ai.starlake.extractor.ExtractScriptGenConfig$;
import ai.starlake.extractor.TemplateParams;
import ai.starlake.extractor.TemplateParams$;
import ai.starlake.extractor.config.Settings$;
import ai.starlake.job.transform.AutoTaskJob;
import ai.starlake.schema.handlers.HdfsStorageHandler;
import ai.starlake.schema.handlers.LaunchHandler;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.SimpleLauncher;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Engine$BQ$;
import ai.starlake.schema.model.Engine$SPARK$;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.Views;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.Formatter$;
import ai.starlake.workflow.IngestionWorkflow;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.TemplateEngine$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\b\u0011\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005:\u0001\t\u0005\t\u0015a\u0003;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001dI\u0005A1A\u0005\u0002)Ca!\u0016\u0001!\u0002\u0013Y\u0005\"\u0002,\u0001\t\u00039\u0006\"B:\u0001\t\u0003!\bbBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t)\u0005\u0001C\u0001\u00033Bq!a\u001a\u0001\t\u0013\tI\u0007C\u0004\u0002z\u0001!I!a\u001f\u0003\u0013M\u001b'/\u001b9u\u000f\u0016t'BA\t\u0013\u0003%)\u0007\u0010\u001e:bGR|'O\u0003\u0002\u0014)\u0005A1\u000f^1sY\u0006\\WMC\u0001\u0016\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nAb]2bY\u0006dwnZ4j]\u001eT!a\t\u0013\u0002\u0011QL\b/Z:bM\u0016T\u0011!J\u0001\u0004G>l\u0017BA\u0014!\u00055\u0019FO]5di2{wmZ5oO\u0006q1\u000f^8sC\u001e,\u0007*\u00198eY\u0016\u0014\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003!A\u0017M\u001c3mKJ\u001c(B\u0001\u0018\u0013\u0003\u0019\u00198\r[3nC&\u0011\u0001g\u000b\u0002\u000f'R|'/Y4f\u0011\u0006tG\r\\3s\u00035\u00198\r[3nC\"\u000bg\u000e\u001a7feB\u0011!fM\u0005\u0003i-\u0012QbU2iK6\f\u0007*\u00198eY\u0016\u0014\u0018!\u00047bk:\u001c\u0007\u000eS1oI2,'\u000f\u0005\u0002+o%\u0011\u0001h\u000b\u0002\u000e\u0019\u0006,hn\u00195IC:$G.\u001a:\u0002\u0011M,G\u000f^5oON\u0004\"a\u000f \u000e\u0003qR!!\u0010\n\u0002\r\r|gNZ5h\u0013\tyDH\u0001\u0005TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q!!IR$I)\t\u0019U\t\u0005\u0002E\u00015\t\u0001\u0003C\u0003:\u000b\u0001\u000f!\bC\u0003)\u000b\u0001\u0007\u0011\u0006C\u00032\u000b\u0001\u0007!\u0007C\u00036\u000b\u0001\u0007a'\u0001\u0004f]\u001eLg.Z\u000b\u0002\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\bg\u000e\fG.\u0019;f\u0015\t\u0001\u0016+\u0001\u0006gkN,7o\\;sG\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+N\u00059!V-\u001c9mCR,WI\\4j]\u0016\fq!\u001a8hS:,\u0007%\u0001\u0006uK6\u0004H.\u0019;ju\u0016$2\u0001\u00177o!\rI\u0016\r\u001a\b\u00035~s!a\u00170\u000e\u0003qS!!\u0018\f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012B\u00011\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\t1K7\u000f\u001e\u0006\u0003Aj\u0001\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u000b\u0019LG.Z:\u000b\u0003%\faAY3ui\u0016\u0014\u0018BA6g\u0005\u00111\u0015\u000e\\3\t\u000b5D\u0001\u0019\u00013\u0002\u0011Q,W\u000e\u001d7bi\u0016DQa\u001c\u0005A\u0002A\fa\u0002^3na2\fG/\u001a)be\u0006l7\u000f\u0005\u0002Ec&\u0011!\u000f\u0005\u0002\u000f)\u0016l\u0007\u000f\\1uKB\u000b'/Y7t\u000399WM\\3sCR,Gi\\7bS:$B\u0002W;~\u007f\u0006\r\u0011QDA\u0011\u0003WAQA^\u0005A\u0002]\fa\u0001Z8nC&t\u0007C\u0001=|\u001b\u0005I(B\u0001>.\u0003\u0015iw\u000eZ3m\u0013\ta\u0018P\u0001\u0004E_6\f\u0017N\u001c\u0005\u0006}&\u0001\r\u0001Z\u0001\u0013g\u000e\u0014\u0018\u000e\u001d;UK6\u0004H.\u0019;f\r&dW\r\u0003\u0004\u0002\u0002%\u0001\r\u0001Z\u0001\u0012g\u000e\u0014\u0018\u000e\u001d;t\u001fV$\b/\u001e;QCRD\u0007bBA\u0003\u0013\u0001\u0007\u0011qA\u0001\u0014g\u000e\u0014\u0018\u000e\u001d;PkR\u0004X\u000f\u001e)biR,'O\u001c\t\u00063\u0005%\u0011QB\u0005\u0004\u0003\u0017Q\"AB(qi&|g\u000e\u0005\u0003\u0002\u0010\u0005]a\u0002BA\t\u0003'\u0001\"a\u0017\u000e\n\u0007\u0005U!$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+Q\u0002bBA\u0010\u0013\u0001\u0007\u0011qA\u0001\u0013I\u00164\u0017-\u001e7u\t\u0016dG/Y\"pYVlg\u000eC\u0004\u0002$%\u0001\r!!\n\u0002\u0019\u0011,G\u000e^1D_2,XN\\:\u0011\u0011\u0005=\u0011qEA\u0007\u0003\u001bIA!!\u000b\u0002\u001c\t\u0019Q*\u00199\t\u000f\u00055\u0012\u00021\u0001\u0002&\u0005I\u0011m\u0019;jm\u0016,eN^\u0001\fO\u0016tWM]1uK*{'\rF\u0005e\u0003g\ti$a\u0010\u0002D!9\u0011Q\u0007\u0006A\u0002\u0005]\u0012a\u00016pEB\u0019\u00010!\u000f\n\u0007\u0005m\u0012PA\u0006BkR|'j\u001c2EKN\u001c\u0007\"\u0002@\u000b\u0001\u0004!\u0007BBA!\u0015\u0001\u0007A-A\ntGJL\u0007\u000f^:PkR\u0004X\u000f\u001e$pY\u0012,'\u000fC\u0004\u0002\u0006)\u0001\r!a\u0002\u0002\u0007I,h\u000e\u0006\u0003\u0002J\u0005=\u0003cA\r\u0002L%\u0019\u0011Q\n\u000e\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011K\u0006A\u0002\u0005M\u0013\u0001B1sON\u0004R!GA+\u0003\u001bI1!a\u0016\u001b\u0005\u0015\t%O]1z)\u0011\tY&a\u0018\u0015\t\u0005%\u0013Q\f\u0005\u0006s1\u0001\u001dA\u000f\u0005\u0007{1\u0001\r!!\u0019\u0011\u0007\u0011\u000b\u0019'C\u0002\u0002fA\u0011a#\u0012=ue\u0006\u001cGoU2sSB$x)\u001a8D_:4\u0017nZ\u0001\reVtwJ\u001c#p[\u0006Lgn\u001d\u000b\t\u0003\u0013\nY'!\u001c\u0002p!1Q(\u0004a\u0001\u0003CBQ!M\u0007A\u0002IBq!!\u001d\u000e\u0001\u0004\t\u0019(A\u0006e_6\f\u0017N\u001c(b[\u0016\u001c\b#B-\u0002v\u00055\u0011bAA<G\n\u00191+Z9\u0002\u0013I,hn\u00148K_\n\u001cH\u0003CA%\u0003{\ny(!!\t\rur\u0001\u0019AA1\u0011\u0015\td\u00021\u00013\u0011\u001d\t\u0019I\u0004a\u0001\u0003g\n\u0001B[8c\u001d\u0006lWm\u001d")
public class ScriptGen
implements StrictLogging {
    private final SchemaHandler schemaHandler;
    private final Settings settings;
    private final TemplateEngine engine;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public TemplateEngine engine() {
        return this.engine;
    }

    public List<File> templatize(File template, TemplateParams templateParams) {
        Iterator iterator;
        if (template.isDirectory(template.isDirectory$default$1())) {
            iterator = template.list().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.pathAsString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$templatize$2(name))).map((Function1 & Serializable & scala.Serializable)name -> new Tuple2(name, (Object)ScriptGen.formatFilename$1(name, templateParams)));
        } else {
            String outputFilename = (String)templateParams.scriptOutputFile().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.pathAsString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ScriptGen.formatFilename$1(template.pathAsString(), templateParams));
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)template.pathAsString(), (Object)outputFilename)}));
        }
        Iterator filesPath = iterator;
        return filesPath.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                String inputPath = (String)tuple2._1();
                String outputPath = (String)tuple2._2();
                String scriptPayload = this.engine().layout(inputPath, templateParams.paramMap(), this.engine().layout$default$3());
                File outputFile = File$.MODULE$.apply(outputPath, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                boolean x$1 = outputFile.createFileIfNotExists$default$1();
                Seq x$2 = outputFile.createFileIfNotExists$default$2(x$1);
                Seq x$3 = outputFile.createFileIfNotExists$default$3(x$1);
                File qual$1 = outputFile.createFileIfNotExists(x$1, x$2, x$3);
                String x$4 = scriptPayload;
                Seq x$5 = qual$1.overwrite$default$2(x$4);
                Charset x$6 = qual$1.overwrite$default$3(x$4);
                qual$1.overwrite(x$4, x$5, x$6);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Successfully generated script {}", new Object[]{outputFile});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return outputFile;
            }
            throw new MatchError((Object)tuple2);
        }).toList();
    }

    public List<File> generateDomain(Domain domain, File scriptTemplateFile, File scriptsOutputPath, Option<String> scriptOutputPattern, Option<String> defaultDeltaColumn, Map<String, String> deltaColumns, Map<String, String> activeEnv) {
        List<TemplateParams> templateSettings = TemplateParams$.MODULE$.fromDomain(domain, scriptsOutputPath, scriptOutputPattern, defaultDeltaColumn, deltaColumns, activeEnv, this.settings);
        return (List)templateSettings.flatMap((Function1 & Serializable & scala.Serializable)ts -> this.templatize(scriptTemplateFile, (TemplateParams)ts), List$.MODULE$.canBuildFrom());
    }

    public File generateJob(AutoJobDesc job, File scriptTemplateFile, File scriptsOutputFolder, Option<String> scriptOutputPattern) {
        BoxedUnit boxedUnit;
        IngestionWorkflow workflow = new IngestionWorkflow(this.settings.metadataStorageHandler(), this.schemaHandler, new SimpleLauncher(), this.settings);
        Seq<AutoTaskJob> actions = workflow.buildTasks(job.name(), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<String>)None$.MODULE$);
        actions.map((Function1 & Serializable & scala.Serializable)action -> {
            Tuple3<List<String>, String, List<String>> tuple3;
            Engine engine = action.engine();
            if (((Object)Engine$BQ$.MODULE$).equals(engine)) {
                tuple3 = action.buildQueryBQ();
            } else if (((Object)Engine$SPARK$.MODULE$).equals(engine)) {
                tuple3 = action.buildQuerySpark((List<String>)Nil$.MODULE$);
            } else {
                throw new Exception("not supported");
            }
            Tuple3<List<String>, String, List<String>> tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            List preSql = (List)tuple32._1();
            String sql = (String)tuple32._2();
            List postSql = (List)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)preSql, (Object)sql, (Object)postSql);
            List preSql2 = (List)tuple33._1();
            String sql2 = (String)tuple33._2();
            List postSql2 = (List)tuple33._3();
            Some x$1 = new Some((Object)preSql2);
            Option x$2 = Option$.MODULE$.apply((Object)sql2);
            Some x$3 = new Some((Object)postSql2);
            Option<String> x$4 = action.task().copy$default$1();
            String x$5 = action.task().copy$default$3();
            String x$6 = action.task().copy$default$4();
            WriteMode x$7 = action.task().copy$default$5();
            Option<List<String>> x$8 = action.task().copy$default$6();
            Option<StorageArea> x$9 = action.task().copy$default$9();
            Option<Sink> x$10 = action.task().copy$default$10();
            Option<List<RowLevelSecurity>> x$11 = action.task().copy$default$11();
            Option<Map<String, String>> x$12 = action.task().copy$default$12();
            Option<Engine> x$13 = action.task().copy$default$13();
            Option<List<AccessControlEntry>> x$14 = action.task().copy$default$14();
            AutoTaskDesc x$15 = action.task().copy(x$4, (Option<String>)x$2, x$5, x$6, x$7, x$8, (Option<List<String>>)x$1, (Option<List<String>>)x$3, x$9, x$10, x$11, x$12, x$13, x$14);
            String x$16 = action.copy$default$1();
            StorageArea x$17 = action.copy$default$2();
            Option<String> x$18 = action.copy$default$3();
            boolean x$19 = action.copy$default$4();
            Option<String> x$20 = action.copy$default$5();
            Views x$21 = action.copy$default$6();
            Engine x$22 = action.copy$default$7();
            Map<String, String> x$23 = action.copy$default$9();
            Option<Sink> x$24 = action.copy$default$10();
            Option<String> x$25 = action.copy$default$11();
            Settings x$26 = $this.settings;
            HdfsStorageHandler x$27 = $this.settings.metadataStorageHandler();
            SchemaHandler x$28 = $this.schemaHandler;
            return action.copy(x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$15, x$23, x$24, x$25, x$26, x$27, x$28);
        }, Seq$.MODULE$.canBuildFrom());
        String scriptPayload = this.engine().layout(scriptTemplateFile.pathAsString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job"), (Object)job), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actions"), actions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"env"), this.schemaHandler.activeEnv(this.schemaHandler.activeEnv$default$1()))})), this.engine().layout$default$3());
        String scriptOutputFileName = (String)scriptOutputPattern.map((Function1 & Serializable & scala.Serializable)x$4 -> Formatter$.MODULE$.RichFormatter((String)x$4).richFormat($this.schemaHandler.activeEnv($this.schemaHandler.activeEnv$default$1()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job"), (Object)job.name())}))), $this.settings)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append(job.name()).append(".py").toString());
        File scriptOutputFile = scriptsOutputFolder.$div(scriptOutputFileName);
        boolean x$29 = scriptOutputFile.createFileIfNotExists$default$1();
        Seq x$30 = scriptOutputFile.createFileIfNotExists$default$2(x$29);
        Seq x$31 = scriptOutputFile.createFileIfNotExists$default$3(x$29);
        File qual$1 = scriptOutputFile.createFileIfNotExists(x$29, x$30, x$31);
        String x$32 = scriptPayload;
        Seq x$33 = qual$1.overwrite$default$2(x$32);
        Charset x$34 = qual$1.overwrite$default$3(x$32);
        File scriptFile = qual$1.overwrite(x$32, x$33, x$34);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Successfully generated job script {}", new Object[]{scriptFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return scriptFile;
    }

    public boolean run(String[] args) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        List arglist = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running Starlake {}", new Object[]{arglist});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option<ExtractScriptGenConfig> option = ExtractScriptGenConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (option instanceof Some) {
            Some some = (Some)option;
            ExtractScriptGenConfig config = (ExtractScriptGenConfig)some.value();
            return this.run(config, this.settings);
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Program execution or parameters are wrong, please check usage");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return false;
    }

    public boolean run(ExtractScriptGenConfig config, Settings settings) {
        DatasetArea$.MODULE$.initMetadata(settings.metadataStorageHandler(), settings);
        SchemaHandler schemaHandler = new SchemaHandler(settings.metadataStorageHandler(), settings);
        Tuple2 tuple2 = new Tuple2(config.domain(), config.jobs());
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq seq2 = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq) && Nil$.MODULE$.equals(seq2)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("No domain or jobs provided. Extracting all domains");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                List domainNames = (List)schemaHandler.domains(schemaHandler.domains$default$1()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom());
                return this.runOnDomains(config, schemaHandler, (Seq<String>)domainNames);
            }
        }
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq jobNames = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return this.runOnJobs(config, schemaHandler, (Seq<String>)jobNames);
            }
        }
        if (tuple2 != null) {
            Seq domainNames = (Seq)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return this.runOnDomains(config, schemaHandler, (Seq<String>)domainNames);
            }
        }
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Only one of domain or job list should be passed as an argument");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        throw new MatchError((Object)tuple2);
    }

    private boolean runOnDomains(ExtractScriptGenConfig config, SchemaHandler schemaHandler, Seq<String> domainNames) {
        List<Domain> domains = schemaHandler.domains(schemaHandler.domains$default$1());
        return ((IterableLike)domainNames.map((Function1 & Serializable & scala.Serializable)domainName -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$1(this, domains, config, schemaHandler, domainName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$4(BoxesRunTime.unboxToBoolean((Object)x$7))));
    }

    private boolean runOnJobs(ExtractScriptGenConfig config, SchemaHandler schemaHandler, Seq<String> jobNames) {
        Map<String, AutoJobDesc> jobs = schemaHandler.jobs(schemaHandler.jobs$default$1());
        return ((IterableLike)jobNames.map((Function1 & Serializable & scala.Serializable)jobName -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnJobs$1(this, jobs, config, jobName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnJobs$2(BoxesRunTime.unboxToBoolean((Object)x$8))));
    }

    private static final String formatFilename$1(String name, TemplateParams templateParams$1) {
        return name.substring(0, name.lastIndexOf(".")).replaceAll("domain", templateParams$1.domainToExport()).replaceAll("schema", templateParams$1.tableToExport());
    }

    public static final /* synthetic */ boolean $anonfun$templatize$2(String name) {
        return name.endsWith(".ssp") || name.endsWith(".mustache");
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$2(String domainName$1, Domain x$6) {
        String string = x$6.name();
        String string2 = domainName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$1(ScriptGen $this, List domains$1, ExtractScriptGenConfig config$1, SchemaHandler schemaHandler$1, String domainName) {
        Option option = domains$1.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$2(domainName, x$6)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Domain domain = (Domain)some.value();
            $this.generateDomain(domain, config$1.scriptTemplateFile(), config$1.scriptOutputDir(), config$1.scriptOutputPattern(), (Option<String>)config$1.deltaColumn().orElse((Function0 & Serializable & scala.Serializable)() -> Settings$.MODULE$.deltaColumns().defaultColumn()), Settings$.MODULE$.deltaColumns().deltaColumns(), schemaHandler$1.activeEnv(schemaHandler$1.activeEnv$default$1()));
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No domain found for domain name {}", new Object[]{config$1.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$4(boolean x$7) {
        return x$7;
    }

    public static final /* synthetic */ boolean $anonfun$runOnJobs$1(ScriptGen $this, Map jobs$1, ExtractScriptGenConfig config$2, String jobName) {
        Option option = jobs$1.get((Object)jobName);
        if (option instanceof Some) {
            Some some = (Some)option;
            AutoJobDesc job = (AutoJobDesc)some.value();
            $this.generateJob(job, config$2.scriptTemplateFile(), config$2.scriptOutputDir(), config$2.scriptOutputPattern());
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No file found for domain name {}", new Object[]{config$2.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$runOnJobs$2(boolean x$8) {
        return x$8;
    }

    public ScriptGen(StorageHandler storageHandler, SchemaHandler schemaHandler, LaunchHandler launchHandler, Settings settings) {
        this.schemaHandler = schemaHandler;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.engine = new TemplateEngine(TemplateEngine$.MODULE$.$lessinit$greater$default$1(), TemplateEngine$.MODULE$.$lessinit$greater$default$2());
    }
}

