/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.load;

import ai.starlake.job.load.LoadStrategy;
import ai.starlake.utils.conversion.Conversions$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class IngestionTimeStrategy$
implements LoadStrategy,
StrictLogging {
    public static IngestionTimeStrategy$ MODULE$;
    private final Logger logger;

    static {
        new IngestionTimeStrategy$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public List<Path> list(FileSystem fs, Path path, String extension, LocalDateTime since, boolean recursive) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            RemoteIterator iterator = fs.listFiles(path, recursive);
            return (List)((List)Conversions$.MODULE$.convertToScalaIterator(iterator).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)IngestionTimeStrategy$.$anonfun$list$2(since, extension, status))).toList().sortBy((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p.getModificationTime()), (Object)p.getPath().getName()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)status -> status.getPath(), List$.MODULE$.canBuildFrom());
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List list = (List)success.value();
            return list;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public String list$default$3() {
        return "";
    }

    @Override
    public LocalDateTime list$default$4() {
        return LocalDateTime.MIN;
    }

    public static final /* synthetic */ boolean $anonfun$list$2(LocalDateTime since$1, String extension$1, LocatedFileStatus status) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("found file={}", new Object[]{status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(status.getModificationTime()), ZoneId.systemDefault());
        return time.isAfter(since$1) && status.getPath().getName().endsWith(extension$1);
    }

    private IngestionTimeStrategy$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

