/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.metrics;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.job.metrics.AssertionJob$;
import ai.starlake.job.metrics.AssertionReport;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AssertionCall;
import ai.starlake.schema.model.AssertionCalls;
import ai.starlake.schema.model.AssertionDefinition;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.Stage;
import ai.starlake.schema.model.Stage$UNIT$;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SinkUtils;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import ai.starlake.utils.Utils$;
import com.hubspot.jinjava.Jinjava;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\t\u0012\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005Q!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A!\u000f\u0001BC\u0002\u0013\r1\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003u\u0011\u0015Y\b\u0001\"\u0001}\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u00022\u0001!\t%a\r\u0003\u0019\u0005\u001b8/\u001a:uS>t'j\u001c2\u000b\u0005I\u0019\u0012aB7fiJL7m\u001d\u0006\u0003)U\t1A[8c\u0015\t1r#\u0001\u0005ti\u0006\u0014H.Y6f\u0015\u0005A\u0012AA1j\u0007\u0001\u00192\u0001A\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!%J\u0007\u0002G)\u0011A%F\u0001\u0006kRLGn]\u0005\u0003M\r\u0012\u0001b\u00159be.TuNY\u0001\u000bI>l\u0017-\u001b8OC6,\u0007CA\u00151\u001d\tQc\u0006\u0005\u0002,;5\tAF\u0003\u0002.3\u00051AH]8pizJ!aL\u000f\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_u\t!b]2iK6\fg*Y7f\u0003)\t7o]3si&|gn\u001d\t\u0005SYB\u0003&\u0003\u00028e\t\u0019Q*\u00199\u0002\u000bM$\u0018mZ3\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!B7pI\u0016d'B\u0001 \u0016\u0003\u0019\u00198\r[3nC&\u0011\u0001i\u000f\u0002\u0006'R\fw-Z\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\t\u0019e)D\u0001E\u0015\t)U(\u0001\u0005iC:$G.\u001a:t\u0013\t9EI\u0001\bTi>\u0014\u0018mZ3IC:$G.\u001a:\u0002\u001bM\u001c\u0007.Z7b\u0011\u0006tG\r\\3s!\t\u0019%*\u0003\u0002L\t\ni1k\u00195f[\u0006D\u0015M\u001c3mKJ\fq\u0001Z1uCN,G\u000fE\u0002\u001d\u001dBK!aT\u000f\u0003\r=\u0003H/[8o!\t\tFM\u0004\u0002SC:\u00111K\u0018\b\u0003)ns!!\u0016-\u000f\u0005-2\u0016\"A,\u0002\u0007=\u0014x-\u0003\u0002Z5\u00061\u0011\r]1dQ\u0016T\u0011aV\u0005\u00039v\u000bQa\u001d9be.T!!\u0017.\n\u0005}\u0003\u0017aA:rY*\u0011A,X\u0005\u0003E\u000e\fq\u0001]1dW\u0006<WM\u0003\u0002`A&\u0011QM\u001a\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!AY2\u0002\r\u0015tw-\u001b8f!\tQ\u0014.\u0003\u0002kw\t1QI\\4j]\u0016\f\u0011b]9m%Vtg.\u001a:\u0011\tqi\u0007f\\\u0005\u0003]v\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005q\u0001\u0018BA9\u001e\u0005\u0011auN\\4\u0002\u0011M,G\u000f^5oON,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003oV\taaY8oM&<\u0017BA=w\u0005!\u0019V\r\u001e;j]\u001e\u001c\u0018!C:fiRLgnZ:!\u0003\u0019a\u0014N\\5u}Q\u0019R0a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014Q\u0019a0!\u0001\u0011\u0005}\u0004Q\"A\t\t\u000bId\u00019\u0001;\t\u000b\u001db\u0001\u0019\u0001\u0015\t\u000bMb\u0001\u0019\u0001\u0015\t\u000bQb\u0001\u0019A\u001b\t\u000bab\u0001\u0019A\u001d\t\u000b\u0005c\u0001\u0019\u0001\"\t\u000b!c\u0001\u0019A%\t\u000b1c\u0001\u0019A'\t\u000b\u001dd\u0001\u0019\u00015\t\u000b-d\u0001\u0019\u00017\u0002\t9\fW.Z\u000b\u0002Q\u0005AAn\\2l!\u0006$\b\u000e\u0006\u0003\u0002\u001e\u00055\u0002\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0003MNT1!a\n^\u0003\u0019A\u0017\rZ8pa&!\u00111FA\u0011\u0005\u0011\u0001\u0016\r\u001e5\t\r\u0005=b\u00021\u0001)\u0003\u0011\u0001\u0018\r\u001e5\u0002\u0007I,h\u000e\u0006\u0002\u00026A1\u0011qGA\u001f\u0003\u0003j!!!\u000f\u000b\u0007\u0005mR$\u0001\u0003vi&d\u0017\u0002BA \u0003s\u00111\u0001\u0016:z!\r\u0011\u00131I\u0005\u0004\u0003\u000b\u001a#!\u0003&pEJ+7/\u001e7u\u0001")
public class AssertionJob
implements SparkJob {
    private final String domainName;
    private final String schemaName;
    private final Map<String, String> assertions;
    private final StorageHandler storageHandler;
    private final SchemaHandler schemaHandler;
    private final Option<Dataset<Row>> dataset;
    private final Engine engine;
    private final Function1<String, Object> sqlRunner;
    private final Settings settings;
    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv;
    private SparkSession session;
    private final Jinjava jinjava;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        return SparkJob.withExtraSparkConf$(this, sourceConfig);
    }

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionedDatasetWriter$(this, dataset, partition);
    }

    @Override
    public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        return SparkJob.partitionDataset$(this, dataset, partition);
    }

    @Override
    public Object analyze(String fullTableName) {
        return SparkJob.analyze$(this, fullTableName);
    }

    @Override
    public List<String> createSparkViews(Views views, SchemaHandler schemaHandler, Map<String, String> sqlParameters) {
        return SparkJob.createSparkViews$(this, views, schemaHandler, sqlParameters);
    }

    @Override
    public Dataset<Row> createSparkView(SinkType sinkType, Option<String> sinkConfig, String path) {
        return SparkJob.createSparkView$(this, sinkType, sinkConfig, path);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public String parseJinja(String str, Map<String, String> params) {
        return JobBase.parseJinja$((JobBase)this, str, params);
    }

    @Override
    public List<String> parseJinja(List<String> str, Map<String, String> params) {
        return JobBase.parseJinja$((JobBase)this, str, params);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$lzycompute() {
        AssertionJob assertionJob = this;
        synchronized (assertionJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ai$starlake$utils$SparkJob$$sparkEnv = SparkJob.ai$starlake$utils$SparkJob$$sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    @Override
    public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.ai$starlake$utils$SparkJob$$sparkEnv$lzycompute();
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    private SparkSession session$lzycompute() {
        AssertionJob assertionJob = this;
        synchronized (assertionJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    @Override
    public Jinjava jinjava() {
        return this.jinjava;
    }

    @Override
    public void ai$starlake$utils$JobBase$_setter_$jinjava_$eq(Jinjava x$1) {
        this.jinjava = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return "Check Assertions";
    }

    public Path lockPath(String path) {
        return new Path(this.settings().comet().lock().path(), new StringBuilder(15).append("assertions").append(path.replace("{domain}", this.domainName).replace("{schema}", this.schemaName).replace('/', '_')).append(".lock").toString());
    }

    @Override
    public Try<JobResult> run() {
        Try<BoxedUnit> try_;
        Object count = this.dataset.map((Function1 & Serializable & scala.Serializable)dataset -> BoxesRunTime.boxToLong((long)AssertionJob.$anonfun$run$1(dataset))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Map<String, AssertionDefinition> assertionLibrary = this.schemaHandler.assertions(this.domainName);
        Map<String, AssertionCall> calls = new AssertionCalls(this.assertions).assertionCalls();
        List assertionReports = ((TraversableOnce)calls.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                AssertionCall assertion = (AssertionCall)tuple2._2();
                String sql = (String)assertionLibrary.get((Object)assertion.name()).map((Function1 & Serializable & scala.Serializable)ad -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Applying substitution {} -> {}", new Object[]{ad.name(), ad.sql()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Map paramsMap = $this.schemaHandler.activeEnv($this.schemaHandler.activeEnv$default$1()).$plus$plus((GenTraversableOnce)((TraversableOnce)ad.params().zip(assertion.paramValues(), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                    return Utils$.MODULE$.subst(Formatter$.MODULE$.RichFormatter(this.parseJinja(ad.sql(), (Map<String, String>)$this.schemaHandler.activeEnv($this.schemaHandler.activeEnv$default$1()).$plus$plus((GenTraversableOnce)paramsMap))).richFormat($this.schemaHandler.activeEnv($this.schemaHandler.activeEnv$default$1()), (Map<String, String>)paramsMap, this.settings()), (Map<String, String>)paramsMap);
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> assertion.sql());
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Applying assertion {} with request {}", new Object[]{assertion.name(), sql});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                boolean bl = false;
                Failure failure = null;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    long assertionCount = BoxesRunTime.unboxToLong((Object)$this.sqlRunner.apply((Object)sql));
                    return new AssertionReport(assertion.name(), assertion.paramValues().toString(), (Option<String>)new Some((Object)sql), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)assertionCount)), (Option<String>)None$.MODULE$, true);
                });
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (e instanceof IllegalArgumentException) {
                        IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                        return new AssertionReport(assertion.name(), assertion.paramValues().toString(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)Utils$.MODULE$.exceptionAsString(illegalArgumentException)), false);
                    }
                }
                if (bl) {
                    Throwable e = failure.exception();
                    return new AssertionReport(assertion.name(), assertion.paramValues().toString(), (Option<String>)new Some((Object)sql), (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)Utils$.MODULE$.exceptionAsString(e)), false);
                }
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    AssertionReport value = (AssertionReport)success.value();
                    return value;
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        if (assertionReports.nonEmpty()) {
            assertionReports.foreach((Function1 & Serializable & scala.Serializable)r -> {
                AssertionJob.$anonfun$run$7(this, r);
                return BoxedUnit.UNIT;
            });
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AssertionJob.class.getClassLoader());
            public final class Ai_starlake_job_metrics_AssertionJob$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.starlake.job.metrics.AssertionReport").asType().toTypeConstructor();
                }

                public Ai_starlake_job_metrics_AssertionJob$$typecreator1$1(AssertionJob $outer) {
                }
            }
            Dataset assertionsDF = this.session().createDataFrame((Seq)assertionReports, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_job_metrics_AssertionJob$$typecreator1$1(null))).withColumn("jobId", functions$.MODULE$.lit((Object)this.session().sparkContext().applicationId())).withColumn("domain", functions$.MODULE$.lit((Object)this.domainName)).withColumn("schema", functions$.MODULE$.lit((Object)this.schemaName)).withColumn("count", functions$.MODULE$.lit(count)).withColumn("cometTime", functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).withColumn("cometStage", functions$.MODULE$.lit((Object)Stage$UNIT$.MODULE$.value()));
            try_ = new SinkUtils(this.settings()).sink(this.settings().comet().assertions().sink(), (Dataset<Row>)assertionsDF, (String)this.settings().comet().assertions().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "assertions"), DatasetArea$.MODULE$.assertions(this.domainName, this.schemaName, this.settings()), this.lockPath(this.settings().comet().assertions().path()), this.storageHandler, this.engine, this.session());
        } else {
            try_ = BoxedUnit.UNIT;
        }
        return new Success((Object)new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$run$1(Dataset dataset) {
        dataset.createOrReplaceTempView("comet_table");
        return dataset.count();
    }

    public static final /* synthetic */ void $anonfun$run$7(AssertionJob $this, AssertionReport r) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(r.toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public AssertionJob(String domainName, String schemaName, Map<String, String> assertions, Stage stage, StorageHandler storageHandler, SchemaHandler schemaHandler, Option<Dataset<Row>> dataset, Engine engine, Function1<String, Object> sqlRunner, Settings settings) {
        this.domainName = domainName;
        this.schemaName = schemaName;
        this.assertions = assertions;
        this.storageHandler = storageHandler;
        this.schemaHandler = schemaHandler;
        this.dataset = dataset;
        this.engine = engine;
        this.sqlRunner = sqlRunner;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
    }
}

